/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.Update;
import org.hswebframework.ezorm.core.Validator;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.core.param.UpdateParam;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.simple.SimpleTable;
import org.hswebframework.ezorm.rdb.simple.ValidatorAndTriggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleUpdate<T>
extends ValidatorAndTriggerSupport<Update<T>>
implements Update<T> {
    private static final Logger logger = LoggerFactory.getLogger(Update.class);
    private UpdateParam updateParam;
    private SimpleTable<T> table;
    private SqlExecutor sqlExecutor;
    private TermTypeConditionalSupport.Accepter accepter = this::and;

    public SimpleUpdate(SimpleTable<T> table, SqlExecutor sqlExecutor) {
        this.table = table;
        this.sqlExecutor = sqlExecutor;
        this.updateParam = new UpdateParam();
    }

    public Update<T> set(T data) {
        this.updateParam.setData(data);
        return this;
    }

    public Update<T> set(String property, Object value) {
        if (this.updateParam.getData() == null) {
            this.updateParam.setData(new HashMap());
        }
        if (this.updateParam.getData() instanceof Map) {
            ((Map)this.updateParam.getData()).put(property, value);
        } else {
            try {
                BeanUtils.setProperty((Object)this.updateParam.getData(), (String)property, (Object)value);
            }
            catch (Exception e) {
                logger.warn("property error", (Throwable)e);
            }
        }
        return this;
    }

    protected Update<T> addSqlTerm(SqlTerm term) {
        this.updateParam.addTerm((Term)term);
        return this;
    }

    public Update<T> includes(String ... fields) {
        this.updateParam.includes(fields);
        return this;
    }

    public Update<T> excludes(String ... fields) {
        this.updateParam.excludes(fields);
        return this;
    }

    public Update<T> and(String condition, String termType, Object value) {
        this.updateParam.and(condition, termType, value);
        return this;
    }

    public Update<T> or(String condition, String termType, Object value) {
        this.updateParam.or(condition, termType, value);
        return this;
    }

    public Update<T> and() {
        this.setAnd();
        this.accepter = this::and;
        return this;
    }

    public Update<T> or() {
        this.setOr();
        this.accepter = this::or;
        return this;
    }

    public TermTypeConditionalSupport.Accepter getAccepter() {
        return this.accepter;
    }

    public NestConditional<Update<T>> nest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.updateParam.nest());
    }

    public NestConditional<Update<T>> nest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.updateParam.nest(column, value));
    }

    public NestConditional<Update<T>> orNest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.updateParam.orNest());
    }

    public NestConditional<Update<T>> orNest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.updateParam.orNest(column, value));
    }

    public Update<T> setParam(UpdateParam param) {
        this.updateParam = param;
        return this;
    }

    public int exec() throws SQLException {
        boolean supportBefore = !this.triggerSkip && this.table.getMeta().triggerIsSupport("update.before");
        boolean supportDone = !this.triggerSkip && this.table.getMeta().triggerIsSupport("update.done");
        Map<String, Object> context = null;
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", this.updateParam);
        }
        if (supportBefore) {
            this.table.getMeta().on("update.before", context);
        }
        SqlRender render = this.table.getMeta().getDatabaseMetaData().getRenderer(SqlRender.TYPE.UPDATE);
        SQL sql = render.render(this.table.getMeta(), this.updateParam);
        this.tryValidate(this.updateParam.getData(), Validator.Operation.UPDATE);
        int total = this.sqlExecutor.update(sql);
        if (supportDone) {
            context.put("total", total);
            this.table.getMeta().on("update.done", context);
        }
        return total;
    }

    @Override
    RDBTableMetaData getTableMeta() {
        return this.table.getMeta();
    }
}

