/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.oauth2.model.AuthorizationCodeModel;
import org.hswebframework.web.authorization.oauth2.model.ImplicitAccessTokenModel;
import org.hswebframework.web.authorization.oauth2.server.OAuth2AccessToken;
import org.hswebframework.web.authorization.oauth2.server.TokenRequest;
import org.hswebframework.web.authorization.oauth2.server.event.OAuth2GrantEvent;
import org.hswebframework.web.authorization.oauth2.server.support.OAuth2Granter;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeRequest;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeService;
import org.hswebframework.web.authorization.oauth2.server.support.code.HttpAuthorizationCodeRequest;
import org.hswebframework.web.authorization.oauth2.server.support.implicit.HttpImplicitRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"OAuth2.0-\u670d\u52a1-\u6388\u6743"}, value="OAuth2.0-\u670d\u52a1-\u6388\u6743")
@RequestMapping(value={"${hsweb.web.mappings.authorize-oauth2:oauth2/authorize}"})
public class OAuth2AuthorizeController {
    @Resource
    private AuthorizationCodeService authorizationCodeService;
    @Resource
    private OAuth2Granter oAuth2Granter;
    @Autowired
    private ApplicationEventPublisher publisher;

    @GetMapping(params={"response_type=code"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237OAuth2.0\u6388\u6743\u7801")
    @Authorize
    @ApiImplicitParam(paramType="query", name="client_id", required=true)
    public AuthorizationCodeModel requestCode(@RequestParam(value="redirect_uri") String redirectUri, @RequestParam(value="state", required=false) String state, HttpServletRequest request) {
        Authentication authentication = (Authentication)Authentication.current().orElseThrow(UnAuthorizedException::new);
        HttpAuthorizationCodeRequest codeRequest = new HttpAuthorizationCodeRequest(authentication.getUser().getId(), request);
        String code = this.authorizationCodeService.createAuthorizationCode((AuthorizationCodeRequest)codeRequest);
        AuthorizationCodeModel model = new AuthorizationCodeModel();
        model.setCode(code);
        model.setRedirectUri(redirectUri);
        model.setState(state);
        return model;
    }

    @GetMapping(params={"response_type=token"})
    @ApiOperation(value="implicit\u65b9\u5f0f\u7533\u8bf7token", tags={"OAuth2.0-\u670d\u52a1-\u7533\u8bf7token"})
    @ApiImplicitParam(paramType="query", name="client_id", required=true)
    public ImplicitAccessTokenModel authorizeByImplicit(@RequestParam(value="redirect_uri") String redirect_uri, @RequestParam(value="state") String state, HttpServletRequest request) {
        HttpImplicitRequest implicitRequest = new HttpImplicitRequest(request);
        OAuth2AccessToken accessToken = this.oAuth2Granter.grant("implicit", (TokenRequest)implicitRequest);
        this.publisher.publishEvent((Object)new OAuth2GrantEvent(accessToken));
        ImplicitAccessTokenModel model = new ImplicitAccessTokenModel();
        model.setState(state);
        model.setToken_type("example");
        model.setAccess_token(accessToken.getAccessToken());
        model.setExpires_in(accessToken.getExpiresIn());
        model.setRedirect_uri(redirect_uri);
        return model;
    }
}

