/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.authorization.oauth2.model.AccessTokenModel;
import org.hswebframework.web.authorization.oauth2.server.OAuth2AccessToken;
import org.hswebframework.web.authorization.oauth2.server.TokenRequest;
import org.hswebframework.web.authorization.oauth2.server.event.OAuth2GrantEvent;
import org.hswebframework.web.authorization.oauth2.server.exception.GrantTokenException;
import org.hswebframework.web.authorization.oauth2.server.support.OAuth2Granter;
import org.hswebframework.web.authorization.oauth2.server.support.client.HttpClientCredentialRequest;
import org.hswebframework.web.authorization.oauth2.server.support.code.HttpAuthorizationCodeTokenRequest;
import org.hswebframework.web.authorization.oauth2.server.support.implicit.HttpImplicitRequest;
import org.hswebframework.web.authorization.oauth2.server.support.password.HttpPasswordRequest;
import org.hswebframework.web.authorization.oauth2.server.support.refresh.HttpRefreshTokenRequest;
import org.hswebframework.web.oauth2.core.ErrorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"OAuth2.0-\u670d\u52a1-\u7533\u8bf7token"}, value="OAuth2.0-\u670d\u52a1-\u7533\u8bf7token")
@RequestMapping(value={"${hsweb.web.mappings.authorize-oauth2:oauth2/token}"})
public class OAuth2TokenController {
    @Resource
    private OAuth2Granter oAuth2Granter;
    @Autowired
    private ApplicationEventPublisher publisher;

    @PostMapping
    @ApiOperation(value="\u7533\u8bf7token", notes="\u5177\u4f53\u8bf7\u6c42\u65b9\u5f0f\u8bf7\u53c2\u7167: http://www.ruanyifeng.com/blog/2014/05/oauth_2_0.html")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", name="client_id", required=true), @ApiImplicitParam(paramType="query", name="client_secret"), @ApiImplicitParam(paramType="query", name="refresh_token"), @ApiImplicitParam(paramType="query", name="redirect_uri"), @ApiImplicitParam(paramType="query", name="code"), @ApiImplicitParam(paramType="query", name="scope", example="user-info:get,share:add"), @ApiImplicitParam(paramType="header", name="Authorization", example="Basic czZCaGRSa3F0MzpnWDFmQmF0M2JW")})
    public AccessTokenModel requestToken(@RequestParam(value="grant_type") @ApiParam(allowableValues="authorization_code,client_credentials,password,refresh_token,implicit") String grant_type, HttpServletRequest request) {
        OAuth2AccessToken accessToken = null;
        switch (grant_type) {
            case "authorization_code": {
                accessToken = this.oAuth2Granter.grant("authorization_code", (TokenRequest)new HttpAuthorizationCodeTokenRequest(request));
                break;
            }
            case "client_credentials": {
                accessToken = this.oAuth2Granter.grant("client_credentials", (TokenRequest)new HttpClientCredentialRequest(request));
                break;
            }
            case "implicit": {
                accessToken = this.oAuth2Granter.grant("implicit", (TokenRequest)new HttpImplicitRequest(request));
                break;
            }
            case "password": {
                accessToken = this.oAuth2Granter.grant("password", (TokenRequest)new HttpPasswordRequest(request));
                break;
            }
            case "refresh_token": {
                accessToken = this.oAuth2Granter.grant("refresh_token", (TokenRequest)new HttpRefreshTokenRequest(request));
                break;
            }
            default: {
                ErrorType.UNSUPPORTED_GRANT_TYPE.throwThis(GrantTokenException::new);
            }
        }
        this.publisher.publishEvent((Object)new OAuth2GrantEvent(accessToken));
        return this.entityToModel(accessToken);
    }

    protected AccessTokenModel entityToModel(OAuth2AccessToken token) {
        AccessTokenModel model = new AccessTokenModel();
        model.setAccess_token(token.getAccessToken());
        model.setRefresh_token(token.getRefreshToken());
        model.setExpires_in(token.getExpiresIn());
        if (token.getScope() != null) {
            model.setScope(token.getScope().stream().reduce((t1, t2) -> t1.concat(",").concat((String)t2)).orElse(""));
        } else {
            model.setScope("public");
        }
        model.setToken_type("bearer");
        return model;
    }
}

