/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationHolder;
import org.hswebframework.web.authorization.oauth2.server.OAuth2AccessToken;
import org.hswebframework.web.authorization.oauth2.server.exception.GrantTokenException;
import org.hswebframework.web.authorization.oauth2.server.token.AccessTokenService;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.oauth2.core.ErrorType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"OAuth2.0-\u670d\u52a1-\u83b7\u53d6\u7528\u6237\u4fe1\u606f"}, value="OAuth2.0-\u670d\u52a1-\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
@RequestMapping(value={"${hsweb.web.mappings.oauth2-auth-info:oauth2/user-auth-info}"})
public class OAuth2UserInfoController {
    @Resource
    private AccessTokenService accessTokenService;

    @GetMapping
    @ApiOperation(value="\u6839\u636eaccessToken\u83b7\u53d6\u5bf9\u5e94\u7528\u6237\u4fe1\u606f")
    public ResponseMessage<Authentication> getLoginUser(@RequestParam(value="access_token") String access_token) {
        OAuth2AccessToken auth2AccessEntity = this.accessTokenService.getTokenByAccessToken(access_token);
        if (null == auth2AccessEntity) {
            throw new GrantTokenException(ErrorType.EXPIRED_TOKEN);
        }
        return ResponseMessage.ok((Object)AuthenticationHolder.get((String)auth2AccessEntity.getOwnerId()));
    }

    @GetMapping(value={"/{userId}"})
    @ApiOperation(value="\u6839\u636eaccessToken\u83b7\u53d6\u7279\u5b9a\u7684\u7528\u6237\u4fe1\u606f")
    public ResponseMessage<Authentication> getUserById(@PathVariable(value="userId") String userId, @RequestParam(value="access_token") String access_token) {
        OAuth2AccessToken auth2AccessEntity = this.accessTokenService.getTokenByAccessToken(access_token);
        if (null == auth2AccessEntity) {
            throw new GrantTokenException(ErrorType.EXPIRED_TOKEN);
        }
        if (auth2AccessEntity.getScope() == null || !auth2AccessEntity.getScope().contains("*") && !auth2AccessEntity.getScope().contains("user:get")) {
            throw new GrantTokenException(ErrorType.UNAUTHORIZED_CLIENT);
        }
        Authentication info = AuthenticationHolder.get((String)userId);
        if (info == null) {
            throw new NotFoundException("user:" + userId + " not found");
        }
        return ResponseMessage.ok((Object)info);
    }
}

