/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.ppg.generator.Action;
import org.infinispan.ppg.generator.Branch;
import org.infinispan.ppg.generator.ByteLiteral;
import org.infinispan.ppg.generator.Constant;
import org.infinispan.ppg.generator.Element;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Intrinsic;
import org.infinispan.ppg.generator.Loop;
import org.infinispan.ppg.generator.ParserException;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.RuleDefinition;
import org.infinispan.ppg.generator.Sequence;

public class Parser {
    private final List<File> sourceDirectories;
    private final Consumer<String> debug;
    private Set<File> processedFiles = new HashSet<File>();
    private Grammar grammar = new Grammar();

    public Parser(Consumer<String> debug, List<File> sourceDirectories) {
        this.debug = debug;
        this.sourceDirectories = sourceDirectories;
    }

    public Grammar load(File file) throws IOException {
        this.parse(file, false);
        this.grammar.checkReferences();
        return this.grammar;
    }

    private void parse(File file, boolean fromInclude) throws IOException {
        if (!this.processedFiles.add(file)) {
            return;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new FileReader(file));
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(64, 64);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
        tokenizer.quoteChar(34);
        boolean isRoot = false;
        ParseContext ctx = new ParseContext(tokenizer, file.getName());
        block26: while (ctx.hasNext()) {
            String t;
            switch (t = ctx.next()) {
                case "namespace": {
                    String ns = ctx.next("namespace");
                    if (!this.validateIdentifier(ns)) {
                        throw ctx.fail("Invalid identifier '" + ns + "'!");
                    }
                    ctx.ns = ns;
                    this.expectSemicolon(ctx);
                    break;
                }
                case "class": {
                    String fqcn = ctx.next("class name");
                    this.grammar.setClassName(fqcn);
                    this.validateClassname(ctx, fqcn);
                    t = ctx.next("'extends' or ';'");
                    if ("extends".equals(t)) {
                        t = ctx.next("base class name");
                        this.validateClassname(ctx, t);
                        this.grammar.setBaseClassName(t);
                        this.expectSemicolon(ctx);
                        break;
                    }
                    if (";".equals(t)) break;
                    throw ctx.fail("Expected 'extends' or ';', found '" + t + "'");
                }
                case "constants": {
                    String className = this.processClassName(ctx);
                    this.addConstants(ctx, className, this.loadClass(ctx, className));
                    break;
                }
                case "intrinsics": {
                    String className = this.processClassName(ctx);
                    this.addIntrinsics(ctx, className, this.loadClass(ctx, className));
                    break;
                }
                case "import": {
                    this.grammar.imports.add(this.processClassName(ctx));
                    break;
                }
                case "include": {
                    String f = ctx.next("filename");
                    this.parse(new File(file.getParentFile(), f), true);
                    this.expectSemicolon(ctx);
                    break;
                }
                case "init": {
                    ctx.next("{");
                    this.grammar.initAction = new Action(ctx.ns, this.processCode(ctx), ctx.file, ctx.line);
                    break;
                }
                case "exceptionally": {
                    ctx.next("{");
                    this.grammar.exceptionally = new Action(ctx.ns, this.processCode(ctx), ctx.file, ctx.line);
                    break;
                }
                case "deadend": {
                    ctx.next("{");
                    this.grammar.deadEnd = new Action(ctx.ns, this.processCode(ctx), ctx.file, ctx.line);
                    break;
                }
                case "root": {
                    isRoot = true;
                    break;
                }
                case "|": {
                    throw ctx.fail("Unexpected '|': extra semicolon before this?");
                }
                default: {
                    RuleDefinition rule = this.processRule(ctx, t);
                    this.grammar.addRule(rule);
                    if (!isRoot || fromInclude) continue block26;
                    if (this.grammar.root != null) {
                        throw ctx.fail("Second root rule '" + rule.qualifiedName + "', already has defined root '" + this.grammar.root.qualifiedName + "'");
                    }
                    this.grammar.root = rule;
                    isRoot = false;
                }
            }
        }
    }

    private void addConstants(ParseContext ctx, String className, ClassOrInterfaceDeclaration clazz) {
        for (FieldDeclaration f : clazz.getFields()) {
            for (VariableDeclarator v : f.getVariables()) {
                if (ctx.ns == null) {
                    throw ctx.fail("Namespace for intrinsics from '" + className + " has not been defined.");
                }
                String qualifiedName = ctx.ns + "." + v.getName();
                String sourceName = className + "." + v.getName();
                this.grammar.addConstant(new Constant(qualifiedName, sourceName, f.getCommonType().asString(), ctx.file, ctx.line));
            }
        }
    }

    private void addIntrinsics(ParseContext ctx, String className, ClassOrInterfaceDeclaration clazz) {
        for (MethodDeclaration m : clazz.getMethods()) {
            NodeList parameterTypes;
            if (!m.getModifiers().contains(Modifier.STATIC) || (parameterTypes = m.getParameters()).size() < 1 || !"ByteBuf".equals(((Parameter)parameterTypes.get(0)).getTypeAsString())) continue;
            if (ctx.ns == null) {
                throw ctx.fail("Namespace for intrinsics from '" + className + " has not been defined.");
            }
            String name = m.getNameAsString();
            if (name.endsWith("_")) {
                name = name.substring(0, name.length() - 1);
            }
            String qualifiedName = ctx.ns + "." + name;
            this.grammar.addIntrinsic(new Intrinsic(qualifiedName, className + "." + m.getNameAsString(), m.getType().asString(), ctx.file, ctx.line));
        }
    }

    private ClassOrInterfaceDeclaration loadClass(ParseContext ctx, String className) {
        Optional<File> classFile = this.sourceDirectories.stream().map(dir -> new File((File)dir, className.replaceAll("\\.", File.separator) + ".java")).filter(file -> {
            this.debug.accept("Looking up file " + file);
            return file.exists() && file.isFile();
        }).findFirst();
        if (!classFile.isPresent()) {
            throw ctx.fail("Cannot find " + className + " in any of " + this.sourceDirectories);
        }
        try {
            CompilationUnit compilationUnit = JavaParser.parse((File)classFile.get());
            int dotIndex = className.lastIndexOf(46);
            String simpleName = dotIndex < 0 ? className : className.substring(dotIndex + 1);
            Optional classByName = compilationUnit.getClassByName(simpleName);
            if (!classByName.isPresent()) {
                classByName = compilationUnit.getInterfaceByName(simpleName);
            }
            return (ClassOrInterfaceDeclaration)classByName.orElseThrow(() -> ctx.fail("Cannot find class " + className + " in " + classFile.get()));
        }
        catch (FileNotFoundException e) {
            throw ctx.fail("Cannot parse file " + classFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private RuleDefinition processRule(ParseContext ctx, String ruleName) throws IOException {
        RuleDefinition rule;
        int dotIndex = ruleName.lastIndexOf(46);
        if (!this.validateIdentifier(ruleName)) {
            throw ctx.fail("Invalid identifier '" + ruleName + "'");
        }
        if (dotIndex >= 0) {
            if (dotIndex == ruleName.length() - 1) {
                throw ctx.fail("Rule name cannot be empty!");
            }
            rule = new RuleDefinition(ruleName.substring(0, dotIndex), ruleName.substring(dotIndex + 1), ctx.file, ctx.line);
        } else {
            this.checkNamespace(ctx, ruleName);
            rule = new RuleDefinition(ctx.ns, ruleName, ctx.file, ctx.line);
        }
        block23: while (true) {
            switch (ctx.next("':', 'returns' or 'switch'")) {
                case ":": {
                    break block23;
                }
                case "returns": {
                    if (rule.explicitType != null) {
                        throw ctx.fail("Explicit type for rule " + ruleName + " already defined!");
                    }
                    rule.explicitType = this.processType(ctx);
                    break;
                }
                case "switch": {
                    if (rule.switchOn != null) {
                        throw ctx.fail("Switch variable for rule " + ruleName + " already defined!");
                    }
                    rule.switchOn = this.processReference(ctx, ctx.next("reference"));
                }
            }
        }
        Branch branch = new Branch(rule, ctx.file, ctx.line);
        block24: while (true) {
            String token;
            if (!ctx.hasNext()) {
                throw ctx.fail("Unfinished rule " + rule.qualifiedName + " starting on line " + rule.line);
            }
            switch (token = ctx.next()) {
                case "{": {
                    List<String> tokens = this.processCode(ctx);
                    if (ctx.hasNext() && "?".equals(ctx.next())) {
                        branch.sentinel = new Action(ctx.ns, tokens, ctx.file, ctx.line);
                        continue block24;
                    }
                    branch.elements.add(new Action(ctx.ns, tokens, ctx.file, ctx.line));
                    ctx.pushBack();
                    continue block24;
                }
                case "#": {
                    token = ctx.next("reference to repetition element");
                    Reference counter = this.processReference(ctx, token);
                    branch.elements.add(new Loop(counter, this.processElement(ctx, ctx.next("element"))));
                    continue block24;
                }
                case "|": 
                case ";": {
                    if (branch.elements.isEmpty()) {
                        throw ctx.fail("Empty branch for rule " + rule.qualifiedName);
                    }
                    rule.branches.add(branch);
                    if (";".equals(token)) {
                        return rule;
                    }
                    branch = new Branch(rule, ctx.file, ctx.line);
                    continue block24;
                }
                case ":": {
                    throw ctx.fail("Unexpected colon; forgot to terminate previous rule?");
                }
            }
            branch.elements.add(this.processElement(ctx, token));
        }
    }

    private String processType(ParseContext ctx) throws IOException {
        String type = ctx.next("type");
        if (!ctx.hasNext()) {
            return type;
        }
        switch (ctx.next()) {
            case "<": {
                return this.consumeUntil(ctx, "<", ">", new StringBuilder(type).append("<"));
            }
            case "[": {
                return this.consumeUntil(ctx, "[", "]", new StringBuilder(type).append("["));
            }
        }
        ctx.pushBack();
        return type;
    }

    private String consumeUntil(ParseContext ctx, String open, String close, StringBuilder sb) throws IOException {
        int level = 1;
        while (true) {
            String token;
            if (open.equals(token = ctx.next(close))) {
                ++level;
                sb.append(token);
                continue;
            }
            if (close.equals(token) && --level == 0) {
                return sb.append(token).toString();
            }
            if (Character.isLetter(token.charAt(0))) {
                sb.append(' ');
            }
            sb.append(token);
        }
    }

    private List<String> processCode(ParseContext ctx) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        int level = 1;
        block8: while (true) {
            String token;
            switch (token = ctx.next("'}'")) {
                case "}": {
                    if (--level == 0) {
                        return tokens;
                    }
                    tokens.add("}");
                    continue block8;
                }
                case "{": {
                    ++level;
                }
            }
            tokens.add(token);
        }
    }

    private Element processElement(ParseContext ctx, String token) throws IOException {
        if ("(".equals(token)) {
            return this.processSequence(ctx, ctx.line);
        }
        try {
            if (token.startsWith("0x")) {
                int value = Integer.parseInt(token.substring(2), 16);
                if (value > 255) {
                    throw ctx.fail("Expected value in range 0 .. 255, found " + value);
                }
                return new ByteLiteral(value);
            }
            if (token.matches("[0-9]*")) {
                int value = Integer.parseInt(token);
                if (value > 255) {
                    throw ctx.fail("Expected value in range 0 .. 255, found " + value);
                }
                return new ByteLiteral(value);
            }
        }
        catch (NumberFormatException e) {
            throw ctx.fail("Cannot parse hexadecimal literal '" + token + "'!");
        }
        return this.processReference(ctx, token);
    }

    private void checkNamespace(ParseContext ctx, String ruleName) {
        if (ctx.ns == null) {
            throw ctx.fail("Default namespace has not been defined but the rule '" + ruleName + "' does not have explicit namespace!");
        }
    }

    private Sequence processSequence(ParseContext ctx, int startLine) throws IOException {
        Sequence sequence = new Sequence();
        block10: while (ctx.hasNext()) {
            String token;
            switch (token = ctx.next()) {
                case ")": {
                    if (sequence.elements.isEmpty()) {
                        throw ctx.fail("Sequence cannot be empty");
                    }
                    return sequence;
                }
                case "{": {
                    sequence.elements.add(new Action(ctx.ns, this.processCode(ctx), ctx.file, ctx.line));
                    continue block10;
                }
                case "#": {
                    token = ctx.next("reference to repetition element");
                    Reference counter = this.processReference(ctx, token);
                    sequence.elements.add(new Loop(counter, this.processElement(ctx, ctx.next("element"))));
                    continue block10;
                }
            }
            sequence.elements.add(this.processElement(ctx, token));
        }
        throw ctx.fail("Did not found the end of sequence starting on line " + startLine);
    }

    private Reference processReference(ParseContext ctx, String token) throws IOException {
        Reference r;
        if (!this.validateIdentifier(token)) {
            throw ctx.fail("Expected identifier, found '" + token + "'!");
        }
        int dotIndex = token.lastIndexOf(46);
        if (dotIndex >= 0) {
            r = new Reference(token, ctx.file, ctx.line);
        } else {
            this.checkNamespace(ctx, token);
            r = new Reference(ctx.ns + "." + token, ctx.file, ctx.line);
        }
        if (!ctx.hasNext()) {
            return r;
        }
        token = ctx.next();
        if ("[".equals(token)) {
            ArrayList<Action> params = new ArrayList<Action>();
            ArrayList<String> tokens = new ArrayList<String>();
            int level = 1;
            block10: while (true) {
                switch (token = ctx.next("']'")) {
                    case "]": {
                        if (--level == 0) break block10;
                        tokens.add("]");
                        continue block10;
                    }
                    case ",": {
                        if (level == 0) {
                            params.add(new Action(ctx.ns, tokens, ctx.file, ctx.line));
                            tokens = new ArrayList();
                        } else {
                            tokens.add(token);
                        }
                    }
                    case "[": {
                        ++level;
                    }
                    default: {
                        tokens.add(token);
                        continue block10;
                    }
                }
                break;
            }
            params.add(new Action(ctx.ns, tokens, ctx.file, ctx.line));
            r.params = params;
        } else {
            ctx.pushBack();
        }
        return r;
    }

    private String processClassName(ParseContext ctx) throws IOException {
        String className = ctx.next("class name");
        this.validateClassname(ctx, className);
        this.expectSemicolon(ctx);
        return className;
    }

    private void expectSemicolon(ParseContext ctx) throws IOException {
        String found = ctx.next(";");
        if (!";".equals(found)) {
            throw ctx.fail("Expected ';', found '" + found + "'!");
        }
    }

    private boolean validateIdentifier(String value) {
        return value.matches("[0-9a-zA-Z_][0-9a-zA-Z_.]*");
    }

    private void validateClassname(ParseContext ctx, String value) {
        if (!value.matches("[a-zA-Z_][0-9a-zA-Z_.$]*")) {
            throw ctx.fail("Invalid class name '" + value + "'");
        }
    }

    private static ParserException fail(String message, String file, int line) {
        return new ParserException(file + ":" + line + ": " + message);
    }

    private static class ParseContext {
        final StreamTokenizer tokenizer;
        final String file;
        String value;
        String prev;
        boolean hasNext = true;
        int line;
        String ns;

        ParseContext(StreamTokenizer tokenizer, String file) throws IOException {
            this.tokenizer = tokenizer;
            this.file = file;
            this.loadNext(tokenizer);
        }

        void loadNext(StreamTokenizer tokenizer) throws IOException {
            block7: while (true) {
                switch (tokenizer.nextToken()) {
                    case -1: {
                        this.hasNext = false;
                        return;
                    }
                    case -3: {
                        this.value = tokenizer.sval;
                        return;
                    }
                    case -2: {
                        throw new ParserException("Numbers should be parsed as words!");
                    }
                    case 10: {
                        continue block7;
                    }
                    case 34: {
                        this.value = '\"' + tokenizer.sval + '\"';
                        return;
                    }
                }
                break;
            }
            this.value = String.valueOf((char)tokenizer.ttype);
        }

        boolean hasNext() {
            return this.hasNext;
        }

        String next() throws IOException {
            this.prev = this.value;
            this.line = this.tokenizer.lineno();
            this.loadNext(this.tokenizer);
            return this.prev;
        }

        String next(String token) throws IOException {
            if (!this.hasNext) {
                throw Parser.fail("Expected " + token + ", found EOF!", this.file, this.line);
            }
            return this.next();
        }

        ParserException fail(String message) {
            return Parser.fail(message, this.file, this.line);
        }

        void pushBack() {
            this.value = this.prev;
            this.hasNext = true;
            this.tokenizer.pushBack();
        }
    }
}

