/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnmodifiableCollectionTestSupport<T> {
    protected Collection<T> items;
    private T containedItem;

    @Before
    public final void initializeHarness() {
        this.items = this.newCollection();
        this.containedItem = this.containedItem();
        Assert.assertFalse((String)"need a non-empty collection", (boolean)this.items.isEmpty());
        Assert.assertTrue((String)"need an item that is in the collection", (boolean)this.items.contains(this.containedItem));
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventAdd() {
        this.items.add(this.newItem());
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventAddAll() {
        this.items.addAll(Arrays.asList(this.newItem()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventClear() {
        this.items.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventRemove() {
        this.items.remove(this.containedItem);
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventRemoveAll() {
        this.items.removeAll(Arrays.asList(this.containedItem));
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventRetainAll() {
        this.items.retainAll(Collections.emptyList());
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventRemoveViaIterator() {
        Iterator<T> iter = this.items.iterator();
        iter.next();
        iter.remove();
    }

    protected abstract Collection<T> newCollection();

    protected abstract T newItem();

    protected abstract T containedItem();
}

