/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.filter;

import java.util.List;
import java.util.Properties;
import org.infinitest.toolkit.filter.TestType;
import org.infinitest.toolkit.filter.TestTypeFilter;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.NoTestsRemainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilteringRunnerHelper {
    static final String TEST_TYPE_PROPERTY_KEY = "org.infinitest.filter.types";
    static boolean hasPrintedMessage;

    private FilteringRunnerHelper() {
    }

    static TestTypeFilter buildFilter(Class<?> clazz, Properties properties) {
        List<String> testTypes = TestType.testTypesFrom(properties);
        FilteringRunnerHelper.printMessage(testTypes);
        return new TestTypeFilter(clazz, testTypes);
    }

    static void filterRunner(Runner runner, Class<?> clazz, Properties properties) {
        try {
            FilteringRunnerHelper.buildFilter(clazz, properties).apply(runner);
        }
        catch (NoTestsRemainException ex) {
            System.out.println("No tests to run.");
        }
    }

    private static void printMessage(List<String> testType) {
        if (!hasPrintedMessage) {
            System.out.println("Filtering for test types: " + testType.toString() + "");
            hasPrintedMessage = true;
        }
    }

    static {
        new FilteringRunnerHelper();
    }
}

