/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.javacc.mojo.ToolFacade;

class JJTree
extends ToolFacade {
    private File inputFile;
    private File outputDirectory;
    private String grammarEncoding;
    private String jdkVersion;
    private Boolean isStatic;
    private Boolean buildNodeFiles;
    private Boolean multi;
    private File nodeDirectory;
    private Boolean nodeDefaultVoid;
    private String nodeClass;
    private String nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean trackTokens;
    private Boolean visitor;
    private String visitorDataType;
    private String visitorReturnType;
    private String visitorException;
    private String codeGenerator;
    private String ouputLanguage;

    JJTree() {
    }

    public void setInputFile(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.inputFile = value;
    }

    public void setOutputDirectory(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.outputDirectory = value;
    }

    public File getOutputFile() {
        File outputFile = null;
        if (this.outputDirectory != null && this.inputFile != null) {
            String fileName = FileUtils.removeExtension((String)this.inputFile.getName()) + ".jj";
            outputFile = new File(this.outputDirectory, fileName);
        }
        return outputFile;
    }

    public void setGrammarEncoding(String value) {
        this.grammarEncoding = value;
    }

    public void setJdkVersion(String value) {
        this.jdkVersion = value;
    }

    public void setStatic(Boolean value) {
        this.isStatic = value;
    }

    public void setBuildNodeFiles(Boolean value) {
        this.buildNodeFiles = value;
    }

    public void setNodeDirectory(File value) {
        this.nodeDirectory = value;
    }

    public void setMulti(Boolean value) {
        this.multi = value;
    }

    public void setNodeDefaultVoid(Boolean value) {
        this.nodeDefaultVoid = value;
    }

    public void setNodeClass(String value) {
        this.nodeClass = value;
    }

    public void setNodeFactory(String value) {
        this.nodeFactory = value;
    }

    public void setNodePackage(String value) {
        this.nodePackage = value;
    }

    public void setNodePrefix(String value) {
        this.nodePrefix = value;
    }

    public void setNodeScopeHook(Boolean value) {
        this.nodeScopeHook = value;
    }

    public void setNodeUsesParser(Boolean value) {
        this.nodeUsesParser = value;
    }

    public void setTrackTokens(Boolean value) {
        this.trackTokens = value;
    }

    public void setVisitor(Boolean value) {
        this.visitor = value;
    }

    public void setVisitorDataType(String value) {
        this.visitorDataType = value;
    }

    public void setVisitorReturnType(String value) {
        this.visitorReturnType = value;
    }

    public void setVisitorException(String value) {
        this.visitorException = value;
    }

    public void setCodeGenerator(String value) {
        this.codeGenerator = value;
    }

    public void setOutputLanguage(String value) {
        this.ouputLanguage = value;
    }

    @Override
    protected int execute() throws Exception {
        String[] args = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        org.javacc.jjtree.JJTree jjtree = new org.javacc.jjtree.JJTree();
        return jjtree.main(args);
    }

    private String[] generateArguments() {
        ArrayList<String> argsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            argsList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.jdkVersion)) {
            argsList.add("-JDK_VERSION=" + this.jdkVersion);
        }
        if (this.buildNodeFiles != null) {
            argsList.add("-BUILD_NODE_FILES=" + this.buildNodeFiles);
        }
        if (this.nodeDirectory != null) {
            argsList.add("-NODE_DIRECTORY=" + this.nodeDirectory.getPath());
        }
        if (this.multi != null) {
            argsList.add("-MULTI=" + this.multi);
        }
        if (this.nodeDefaultVoid != null) {
            argsList.add("-NODE_DEFAULT_VOID=" + this.nodeDefaultVoid);
        }
        if (StringUtils.isNotEmpty((String)this.nodeClass)) {
            argsList.add("-NODE_CLASS=" + this.nodeClass);
        }
        if (StringUtils.isNotEmpty((String)this.nodeFactory)) {
            argsList.add("-NODE_FACTORY=" + this.nodeFactory);
        }
        if (StringUtils.isNotEmpty((String)this.nodePackage)) {
            argsList.add("-NODE_PACKAGE=" + this.nodePackage);
        }
        if (StringUtils.isNotEmpty((String)this.nodePrefix)) {
            argsList.add("-NODE_PREFIX=" + this.nodePrefix);
        }
        if (this.nodeScopeHook != null) {
            argsList.add("-NODE_SCOPE_HOOK=" + this.nodeScopeHook);
        }
        if (this.nodeUsesParser != null) {
            argsList.add("-NODE_USES_PARSER=" + this.nodeUsesParser);
        }
        if (this.isStatic != null) {
            argsList.add("-STATIC=" + this.isStatic);
        }
        if (this.trackTokens != null) {
            argsList.add("-TRACK_TOKENS=" + this.trackTokens);
        }
        if (this.visitor != null) {
            argsList.add("-VISITOR=" + this.visitor);
        }
        if (StringUtils.isNotEmpty((String)this.visitorDataType)) {
            argsList.add("-VISITOR_DATA_TYPE=" + this.visitorDataType);
        }
        if (StringUtils.isNotEmpty((String)this.visitorReturnType)) {
            argsList.add("-VISITOR_RETURN_TYPE=" + this.visitorReturnType);
        }
        if (StringUtils.isNotEmpty((String)this.visitorException)) {
            argsList.add("-VISITOR_EXCEPTION=" + this.visitorException);
        }
        if (StringUtils.isNotEmpty((String)this.codeGenerator)) {
            argsList.add("-CODE_GENERATOR=" + this.codeGenerator);
        }
        if (StringUtils.isNotEmpty((String)this.ouputLanguage)) {
            argsList.add("-OUTPUT_LANGUAGE=" + this.ouputLanguage);
        }
        if (this.outputDirectory != null) {
            argsList.add("-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath());
        }
        if (this.inputFile != null) {
            argsList.add(this.inputFile.getAbsolutePath());
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }
}

