/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.InternalException;
import org.javalite.activejdbc.LogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionsAccess.class);
    private static final ThreadLocal<HashMap<String, Connection>> connectionsTL = new ThreadLocal();

    private ConnectionsAccess() {
    }

    static Map<String, Connection> getConnectionMap() {
        if (connectionsTL.get() == null) {
            connectionsTL.set(new HashMap());
        }
        return connectionsTL.get();
    }

    static Connection getConnection(String dbName) {
        return ConnectionsAccess.getConnectionMap().get(dbName);
    }

    static void attach(String dbName, Connection connection, String extraInfo) {
        if (ConnectionsAccess.getConnectionMap().get(dbName) != null) {
            throw new InternalException("You are opening a connection " + dbName + " without closing a previous one. Check your logic. Connection still remains on thread: " + ConnectionsAccess.getConnectionMap().get(dbName));
        }
        ConnectionsAccess.getConnectionMap().put(dbName, connection);
        LogFilter.log(LOGGER, "Attached connection: {} named: {} to current thread. Extra info: {}", connection, dbName, extraInfo);
    }

    static void detach(String dbName) {
        LogFilter.log(LOGGER, "Detached connection: {} from current thread", (Object)dbName);
        ConnectionsAccess.getConnectionMap().remove(dbName);
    }

    static List<Connection> getAllConnections() {
        return new ArrayList<Connection>(ConnectionsAccess.getConnectionMap().values());
    }
}

