/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.CallbackSupport;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.CaseInsensitiveSet;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.Errors;
import org.javalite.activejdbc.Formatter;
import org.javalite.activejdbc.FrozenException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.ModelListener;
import org.javalite.activejdbc.ModelRegistry;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.SimpleFormatter;
import org.javalite.activejdbc.StaleModelException;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.NotAssociatedException;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.conversion.Converter;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.activejdbc.validation.NumericValidationBuilder;
import org.javalite.activejdbc.validation.ValidationBuilder;
import org.javalite.activejdbc.validation.ValidationException;
import org.javalite.activejdbc.validation.Validator;
import org.javalite.common.Convert;
import org.javalite.common.Escape;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Model
extends CallbackSupport
implements Externalizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Model.class);
    private Map<String, Object> attributes = new CaseInsensitiveMap<Object>();
    private final Set<String> dirtyAttributeNames = new CaseInsensitiveSet();
    private boolean frozen;
    private MetaModel metaModelLocal;
    private ModelRegistry modelRegistryLocal;
    private final Map<Class, Model> cachedParents = new HashMap<Class, Model>();
    private final Map<Class, List<Model>> cachedChildren = new HashMap<Class, List<Model>>();
    private boolean manageTime = true;
    private boolean compositeKeyPersisted;
    private Errors errors = new Errors();

    protected Model() {
        this.metaModelLocal = ModelDelegate.metaModelOf(this.getClass());
    }

    private void fireAfterLoad() {
        this.afterLoad();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterLoad(this);
        }
    }

    private void fireBeforeSave() {
        this.beforeSave();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.beforeSave(this);
        }
    }

    private void fireAfterSave() {
        this.afterSave();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterSave(this);
        }
    }

    private void fireBeforeCreate() {
        this.beforeCreate();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.beforeCreate(this);
        }
    }

    private void fireAfterCreate() {
        this.afterCreate();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterCreate(this);
        }
    }

    private void fireBeforeUpdate() {
        this.beforeUpdate();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.beforeUpdate(this);
        }
    }

    private void fireAfterUpdate() {
        this.afterUpdate();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterUpdate(this);
        }
    }

    private void fireBeforeDelete() {
        this.beforeDelete();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.beforeDelete(this);
        }
    }

    private void fireAfterDelete() {
        this.afterDelete();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterDelete(this);
        }
    }

    private void fireBeforeValidation() {
        this.beforeValidation();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.beforeValidation(this);
        }
    }

    private void fireAfterValidation() {
        this.afterValidation();
        for (CallbackListener callback : this.modelRegistryLocal().callbacks()) {
            callback.afterValidation(this);
        }
    }

    public static MetaModel getMetaModel() {
        return ModelDelegate.metaModelOf(Model.modelClass());
    }

    public static MetaModel metaModel() {
        return ModelDelegate.metaModelOf(Model.modelClass());
    }

    protected Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    protected Set<String> dirtyAttributeNames() {
        return Collections.unmodifiableSet(this.dirtyAttributeNames);
    }

    public <T extends Model> T fromMap(Map input) {
        this.hydrate(input, false);
        this.dirtyAttributeNames.addAll(input.keySet());
        return (T)this;
    }

    protected void hydrate(Map<String, Object> attributesMap, boolean fireAfterLoad) {
        Set<String> attributeNames = this.metaModelLocal.getAttributeNames();
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            if (!attributeNames.contains(entry.getKey())) continue;
            if (entry.getValue() instanceof Clob && this.metaModelLocal.cached()) {
                this.attributes.put(entry.getKey(), Convert.toString((Object)entry.getValue()));
                continue;
            }
            this.attributes.put(entry.getKey(), this.metaModelLocal.getDialect().overrideDriverTypeConversion(this.metaModelLocal, entry.getKey(), entry.getValue()));
        }
        if (this.getCompositeKeys() != null) {
            this.compositeKeyPersisted = true;
        }
        if (fireAfterLoad) {
            this.fireAfterLoad();
        }
    }

    public <T extends Model> T setId(Object id) {
        return this.set(this.getIdName(), id);
    }

    public <T extends Model> T setDate(String attributeName, Object value) {
        Converter<Object, Date> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Date.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toSqlDate((Object)value));
    }

    public Date getDate(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Date> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Date.class);
        return converter != null ? converter.convert(value) : Convert.toSqlDate((Object)value);
    }

    @Deprecated
    public void setTS(String name, java.util.Date date) {
        if (date == null) {
            this.set(name, null);
        } else {
            this.set(name, (Object)new Timestamp(date.getTime()));
        }
    }

    public void set(String[] attributeNames, Object[] values) {
        if (attributeNames == null || values == null || attributeNames.length != values.length) {
            throw new IllegalArgumentException("must pass non-null arrays of equal length");
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            this.set(attributeNames[i], values[i]);
        }
    }

    public <T extends Model> T set(String attributeName, Object value) {
        Converter<Object, Object> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Object.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : value);
    }

    private <T extends Model> T setRaw(String attributeName, Object value) {
        if (this.manageTime && attributeName.equalsIgnoreCase("created_at")) {
            throw new IllegalArgumentException("cannot set 'created_at'");
        }
        this.metaModelLocal.checkAttribute(attributeName);
        this.attributes.put(attributeName, value);
        this.dirtyAttributeNames.add(attributeName);
        return (T)this;
    }

    public boolean isModified() {
        return !this.dirtyAttributeNames.isEmpty();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean modified() {
        return this.isModified();
    }

    @Deprecated
    public static List<String> attributes() {
        return ModelDelegate.attributes(Model.modelClass());
    }

    public static Set<String> attributeNames() {
        return ModelDelegate.attributeNames(Model.modelClass());
    }

    public static List<Association> associations() {
        return ModelDelegate.associations(Model.modelClass());
    }

    public boolean isNew() {
        return this.getId() == null && !this.compositeKeyPersisted;
    }

    public boolean frozen() {
        return this.isFrozen();
    }

    public boolean delete() {
        int result;
        this.fireBeforeDelete();
        if (this.getCompositeKeys() != null) {
            String[] compositeKeys = this.getCompositeKeys();
            StringBuilder query = new StringBuilder();
            Object[] values = new Object[compositeKeys.length];
            for (int i = 0; i < compositeKeys.length; ++i) {
                query.append(i == 0 ? "DELETE FROM " + this.metaModelLocal.getTableName() + " WHERE " : " AND ").append(compositeKeys[i]).append(" = ?");
                values[i] = this.get(compositeKeys[i]);
            }
            result = new DB(this.metaModelLocal.getDbName()).exec(query.toString(), values);
        } else {
            result = new DB(this.metaModelLocal.getDbName()).exec("DELETE FROM " + this.metaModelLocal.getTableName() + " WHERE " + this.getIdName() + "= ?", this.getId());
        }
        if (1 == result) {
            this.frozen = true;
            if (ModelDelegate.metaModelOf(this.getClass()).cached()) {
                Registry.cacheManager().purgeTableCache(this.metaModelLocal);
            }
            ModelDelegate.purgeEdges(this.metaModelLocal);
            this.fireAfterDelete();
            return true;
        }
        this.fireAfterDelete();
        return false;
    }

    public void delete(boolean cascade) {
        if (cascade) {
            this.deleteCascade();
        } else {
            this.delete();
        }
    }

    public void deleteCascade() {
        this.deleteCascadeExcept(new Association[0]);
    }

    public void deleteCascadeExcept(Association ... excludedAssociations) {
        List<Association> excludedAssociationsList = Arrays.asList(excludedAssociations);
        this.deleteMany2ManyDeep(this.metaModelLocal.getManyToManyAssociations(excludedAssociationsList));
        this.deleteChildrenDeep(this.metaModelLocal.getOneToManyAssociations(excludedAssociationsList));
        this.deleteChildrenDeep(this.metaModelLocal.getPolymorphicAssociations(excludedAssociationsList));
        this.delete();
    }

    private void deleteMany2ManyDeep(List<Many2ManyAssociation> many2ManyAssociations) {
        ArrayList<? extends Model> allMany2ManyChildren = new ArrayList<Model>();
        for (Association association : many2ManyAssociations) {
            Class<? extends Model> targetModelClass = association.getTargetClass();
            allMany2ManyChildren.addAll(this.getAll(targetModelClass));
        }
        this.deleteJoinsForManyToMany();
        for (Model model : allMany2ManyChildren) {
            model.deleteCascade();
        }
    }

    public void deleteCascadeShallow() {
        this.deleteJoinsForManyToMany();
        this.deleteOne2ManyChildrenShallow();
        this.deletePolymorphicChildrenShallow();
        this.delete();
    }

    private void deleteJoinsForManyToMany() {
        List<Many2ManyAssociation> associations = this.metaModelLocal.getManyToManyAssociations(Collections.emptyList());
        for (Many2ManyAssociation association : associations) {
            this.deleteManyToManyLinks(association);
        }
    }

    private void deleteManyToManyLinks(Many2ManyAssociation association) {
        String join = association.getJoin();
        String sourceFK = association.getSourceFkName();
        new DB(this.metaModelLocal.getDbName()).exec("DELETE FROM " + join + " WHERE " + sourceFK + " = ?", this.getId());
    }

    private void deleteOne2ManyChildrenShallow() {
        List<OneToManyAssociation> childAssociations = this.metaModelLocal.getOneToManyAssociations(Collections.emptyList());
        for (OneToManyAssociation association : childAssociations) {
            this.deleteOne2ManyChildrenShallow(association);
        }
    }

    private void deleteOne2ManyChildrenShallow(OneToManyAssociation association) {
        String targetTable = ModelDelegate.metaModelOf(association.getTargetClass()).getTableName();
        new DB(this.metaModelLocal.getDbName()).exec("DELETE FROM " + targetTable + " WHERE " + association.getFkName() + " = ?", this.getId());
    }

    private void deletePolymorphicChildrenShallow() {
        List<OneToManyPolymorphicAssociation> polymorphics = this.metaModelLocal.getPolymorphicAssociations(new ArrayList<Association>());
        for (OneToManyPolymorphicAssociation association : polymorphics) {
            this.deletePolymorphicChildrenShallow(association);
        }
    }

    private void deletePolymorphicChildrenShallow(OneToManyPolymorphicAssociation association) {
        String targetTable = ModelDelegate.metaModelOf(association.getTargetClass()).getTableName();
        String parentType = association.getTypeLabel();
        new DB(this.metaModelLocal.getDbName()).exec("DELETE FROM " + targetTable + " WHERE parent_id = ? AND parent_type = ?", this.getId(), parentType);
    }

    private void deleteChildrenDeep(List<? extends Association> childAssociations) {
        for (Association association : childAssociations) {
            String targetTableName = ModelDelegate.metaModelOf(association.getTargetClass()).getTableName();
            Class<? extends Model> c = Registry.instance().getModelClass(targetTableName, false);
            if (c == null) {
                LOGGER.error("ActiveJDBC WARNING: failed to find a model class for: {}, maybe model is not defined for this table? There might be a risk of running into integrity constrain violation if this model is not defined.", (Object)targetTableName);
                continue;
            }
            LazyList<? extends Model> dependencies = this.getAll(c);
            for (Model model : dependencies) {
                model.deleteCascade();
            }
        }
    }

    public <T extends Model> void deleteChildrenShallow(Class<T> clazz) {
        List<Association> associations = this.metaModelLocal.getAssociationsForTarget(clazz);
        for (Association association : associations) {
            if (association instanceof OneToManyAssociation) {
                this.deleteOne2ManyChildrenShallow((OneToManyAssociation)association);
                continue;
            }
            if (association instanceof Many2ManyAssociation) {
                this.deleteManyToManyLinks((Many2ManyAssociation)association);
                continue;
            }
            if (!(association instanceof OneToManyPolymorphicAssociation)) continue;
            this.deletePolymorphicChildrenShallow((OneToManyPolymorphicAssociation)association);
        }
    }

    public static int delete(String query, Object ... params) {
        return ModelDelegate.delete(Model.modelClass(), query, params);
    }

    public static boolean exists(Object id) {
        return ModelDelegate.exists(Model.modelClass(), id);
    }

    public boolean exists() {
        return null != new DB(this.metaModelLocal.getDbName()).firstCell(this.metaModelLocal.getDialect().selectExists(this.metaModelLocal), this.getId());
    }

    public static int deleteAll() {
        return ModelDelegate.deleteAll(Model.modelClass());
    }

    public static int update(String updates, String conditions, Object ... params) {
        return ModelDelegate.update(Model.modelClass(), updates, conditions, params);
    }

    public static int updateAll(String updates, Object ... params) {
        return ModelDelegate.updateAll(Model.modelClass(), updates, params);
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> retVal = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            if (v instanceof Clob) {
                retVal.put(entry.getKey().toLowerCase(), Convert.toString((Object)v));
                continue;
            }
            retVal.put(entry.getKey().toLowerCase(), v);
        }
        for (Map.Entry<Object, Object> entry : this.cachedParents.entrySet()) {
            retVal.put(Inflector.underscore((String)((Class)entry.getKey()).getSimpleName()), ((Model)entry.getValue()).toMap());
        }
        for (Map.Entry<Object, Object> entry : this.cachedChildren.entrySet()) {
            List children = (List)entry.getValue();
            ArrayList<Map<String, Object>> childMaps = new ArrayList<Map<String, Object>>(children.size());
            for (Model child : children) {
                childMaps.add(child.toMap());
            }
            retVal.put(Inflector.tableize((String)((Class)entry.getKey()).getSimpleName()), childMaps);
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Model: ").append(this.getClass().getName()).append(", table: '").append(this.metaModelLocal.getTableName()).append("', attributes: ").append(this.attributes);
        if (this.cachedParents.size() > 0) {
            sb.append(", parent: ").append(this.cachedParents);
        }
        if (this.cachedChildren.size() > 0) {
            sb.append(", children: ").append(this.cachedChildren);
        }
        return sb.toString();
    }

    public void fromXml(String xml) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(xml.getBytes()));
            String attr = null;
            String chars = null;
            HashMap<String, String> res = new HashMap<String, String>();
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        attr = reader.getLocalName();
                        break;
                    }
                    case 4: {
                        chars = reader.getText().trim();
                        break;
                    }
                    case 2: {
                        if (attr != null && !Util.blank((Object)chars)) {
                            res.put(attr, chars);
                        }
                        chars = null;
                        attr = null;
                    }
                }
            }
            this.fromMap(res);
        }
        catch (XMLStreamException e) {
            throw new InitException(e);
        }
    }

    public String toXml(boolean pretty, boolean declaration, String ... attributeNames) {
        StringBuilder sb = new StringBuilder();
        if (declaration) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (pretty) {
                sb.append('\n');
            }
        }
        this.toXmlP(sb, pretty, "", attributeNames);
        return sb.toString();
    }

    protected void toXmlP(StringBuilder sb, boolean pretty, String indent, String ... attributeNames) {
        String[] names;
        String topTag = Inflector.underscore((String)this.getClass().getSimpleName());
        if (pretty) {
            sb.append(indent);
        }
        sb.append('<').append(topTag).append('>');
        if (pretty) {
            sb.append('\n');
        }
        for (String name : names = !Util.empty((Object[])attributeNames) ? attributeNames : this.attributeNamesLowerCased()) {
            if (pretty) {
                sb.append("  ").append(indent);
            }
            sb.append('<').append(name).append('>');
            Object v = this.attributes.get(name);
            if (v != null) {
                Escape.xml((StringBuilder)sb, (String)Convert.toString((Object)v));
            }
            sb.append("</").append(name).append('>');
            if (!pretty) continue;
            sb.append('\n');
        }
        for (Map.Entry<Class, List<Model>> cachedChild : this.cachedChildren.entrySet()) {
            if (pretty) {
                sb.append("  ").append(indent);
            }
            String tag = Inflector.pluralize((String)Inflector.underscore((String)cachedChild.getKey().getSimpleName()));
            sb.append('<').append(tag).append('>');
            if (pretty) {
                sb.append('\n');
            }
            for (Model child : cachedChild.getValue()) {
                child.toXmlP(sb, pretty, "    " + indent, new String[0]);
            }
            if (pretty) {
                sb.append("  ").append(indent);
            }
            sb.append("</").append(tag).append('>');
            if (!pretty) continue;
            sb.append('\n');
        }
        this.beforeClosingTag(sb, pretty, pretty ? "  " + indent : "", attributeNames);
        if (pretty) {
            sb.append(indent);
        }
        sb.append("</").append(topTag).append('>');
        if (pretty) {
            sb.append('\n');
        }
    }

    @Deprecated
    public String toXml(int spaces, boolean declaration, String ... attributeNames) {
        return this.toXml(spaces > 0, declaration, attributeNames);
    }

    public void beforeClosingTag(StringBuilder sb, boolean pretty, String indent, String ... attributeNames) {
        StringWriter writer = new StringWriter();
        this.beforeClosingTag(indent.length(), writer, attributeNames);
        sb.append(writer.toString());
    }

    @Deprecated
    public void beforeClosingTag(int spaces, StringWriter writer, String ... attributeNames) {
    }

    public String toJson(boolean pretty, String ... attributeNames) {
        StringBuilder sb = new StringBuilder();
        this.toJsonP(sb, pretty, "", attributeNames);
        return sb.toString();
    }

    protected void toJsonP(StringBuilder sb, boolean pretty, String indent, String ... attributeNames) {
        String name;
        if (pretty) {
            sb.append(indent);
        }
        sb.append('{');
        String[] names = !Util.empty((Object[])attributeNames) ? attributeNames : this.attributeNamesLowerCased();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (pretty) {
                sb.append("\n  ").append(indent);
            }
            String name2 = names[i];
            sb.append('\"').append(name2).append("\":");
            Object v = this.attributes.get(name2);
            if (v == null) {
                sb.append("null");
                continue;
            }
            if (v instanceof Number || v instanceof Boolean) {
                sb.append(v);
                continue;
            }
            if (v instanceof java.util.Date) {
                sb.append('\"').append(Convert.toIsoString((java.util.Date)((java.util.Date)v))).append('\"');
                continue;
            }
            sb.append('\"');
            Escape.json((StringBuilder)sb, (String)Convert.toString((Object)v));
            sb.append('\"');
        }
        if (this.cachedParents.size() > 0) {
            sb.append(',');
            if (pretty) {
                sb.append("\n  ").append(indent);
            }
            sb.append("\"parents\":{");
            ArrayList<Class> parentClasses = new ArrayList<Class>();
            parentClasses.addAll(this.cachedParents.keySet());
            for (int i = 0; i < parentClasses.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Class parentClass = (Class)parentClasses.get(i);
                name = Inflector.pluralize((String)((Class)parentClasses.get(i)).getSimpleName()).toLowerCase();
                if (pretty) {
                    sb.append("\n    ").append(indent);
                }
                sb.append('\"').append(name).append("\":[");
                Model parent = this.cachedParents.get(parentClass);
                if (pretty) {
                    sb.append('\n');
                }
                parent.toJsonP(sb, pretty, pretty ? "      " + indent : "", new String[0]);
                if (pretty) {
                    sb.append("\n    ").append(indent);
                }
                sb.append(']');
            }
            if (pretty) {
                sb.append("\n  ").append(indent);
            }
            sb.append('}');
        }
        if (this.cachedChildren.size() > 0) {
            sb.append(',');
            if (pretty) {
                sb.append("\n  ").append(indent);
            }
            sb.append("\"children\":{");
            ArrayList<Class> childClasses = new ArrayList<Class>();
            childClasses.addAll(this.cachedChildren.keySet());
            for (int i = 0; i < childClasses.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Class childClass = (Class)childClasses.get(i);
                name = Inflector.pluralize((String)childClass.getSimpleName()).toLowerCase();
                if (pretty) {
                    sb.append("\n    ").append(indent);
                }
                sb.append('\"').append(name).append("\":[");
                List<Model> child = this.cachedChildren.get(childClass);
                for (int j = 0; j < child.size(); ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    if (pretty) {
                        sb.append('\n');
                    }
                    child.get(j).toJsonP(sb, pretty, pretty ? "      " + indent : "", new String[0]);
                }
                if (pretty) {
                    sb.append("\n    ").append(indent);
                }
                sb.append(']');
            }
            if (pretty) {
                sb.append("\n  ").append(indent);
            }
            sb.append('}');
        }
        this.beforeClosingBrace(sb, pretty, pretty ? "  " + indent : "", attributeNames);
        if (pretty) {
            sb.append('\n').append(indent);
        }
        sb.append('}');
    }

    public void beforeClosingBrace(StringBuilder sb, boolean pretty, String indent, String ... attributeNames) {
        StringWriter writer = new StringWriter();
        this.beforeClosingBrace(pretty, indent, writer);
        sb.append(writer.toString());
    }

    @Deprecated
    public void beforeClosingBrace(boolean pretty, String indent, StringWriter writer) {
    }

    private String[] attributeNamesLowerCased() {
        return ModelDelegate.lowerCased(this.attributes.keySet());
    }

    public <P extends Model> P parent(Class<P> parentClass) {
        return this.parent(parentClass, false);
    }

    public <P extends Model> P parent(Class<P> parentClass, boolean cache) {
        Model parent;
        String fkName;
        Object fkValue;
        Model cachedParent = (Model)parentClass.cast(this.cachedParents.get(parentClass));
        if (cachedParent != null) {
            return (P)cachedParent;
        }
        BelongsToAssociation ass = this.metaModelLocal.getAssociationForTarget(parentClass, BelongsToAssociation.class);
        BelongsToPolymorphicAssociation assP = this.metaModelLocal.getAssociationForTarget(parentClass, BelongsToPolymorphicAssociation.class);
        if (ass != null) {
            fkValue = this.get(ass.getFkName());
            fkName = ass.getFkName();
        } else if (assP != null) {
            fkValue = this.get("parent_id");
            fkName = "parent_id";
            if (!assP.getTypeLabel().equals(this.getString("parent_type"))) {
                throw new IllegalArgumentException("Wrong parent: '" + parentClass + "'. Actual parent type label of this record is: '" + this.getString("parent_type") + "'");
            }
        } else {
            throw new IllegalArgumentException("there is no association with model: " + parentClass);
        }
        if (fkValue == null) {
            LOGGER.debug("Attribute: {} is null, cannot determine parent. Child record: {}", (Object)fkName, (Object)this);
            return null;
        }
        MetaModel parentMM = ModelDelegate.metaModelOf(parentClass);
        String parentTable = parentMM.getTableName();
        String parentIdName = parentMM.getIdName();
        String query = this.metaModelLocal.getDialect().selectStarParametrized(parentTable, parentIdName);
        if (parentMM.cached() && (parent = (Model)parentClass.cast(QueryCache.instance().getItem(parentTable, query, new Object[]{fkValue}))) != null) {
            return (P)parent;
        }
        List<Map> results = new DB(this.metaModelLocal.getDbName()).findAll(query, fkValue);
        if (results.isEmpty()) {
            return null;
        }
        try {
            Model parent2 = (Model)parentClass.newInstance();
            parent2.hydrate(results.get(0), true);
            if (parentMM.cached()) {
                QueryCache.instance().addItem(parentTable, query, new Object[]{fkValue}, parent2);
            }
            if (cache) {
                this.setCachedParent(parent2);
            }
            return (P)parent2;
        }
        catch (Exception e) {
            throw new InitException(e.getMessage(), e);
        }
    }

    protected void setCachedParent(Model parent) {
        if (parent != null) {
            this.cachedParents.put(parent.getClass(), parent);
        }
    }

    public void setParents(Model ... parents) {
        for (Model parent : parents) {
            this.setParent(parent);
        }
    }

    public void setParent(Model parent) {
        if (parent == null || parent.getId() == null) {
            throw new IllegalArgumentException("parent cannot ne null and parent ID cannot be null");
        }
        List<Association> associations = this.metaModelLocal.getAssociations();
        for (Association association : associations) {
            if (association instanceof BelongsToAssociation && association.getTargetClass().equals(parent.metaModelLocal.getModelClass())) {
                this.set(((BelongsToAssociation)association).getFkName(), parent.getId());
                return;
            }
            if (!(association instanceof BelongsToPolymorphicAssociation) || !association.getTargetClass().equals(parent.metaModelLocal.getModelClass())) continue;
            this.set("parent_id", parent.getId());
            this.set("parent_type", (Object)((BelongsToPolymorphicAssociation)association).getTypeLabel());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Class: ").append(parent.getClass()).append(" is not associated with ").append(this.getClass()).append(", list of existing associations:\n");
        Util.join((StringBuilder)sb, this.metaModelLocal.getAssociations(), (String)"\n");
        throw new IllegalArgumentException(sb.toString());
    }

    public void copyTo(Model other) {
        other.copyFrom(this);
    }

    public void copyFrom(Model other) {
        if (!this.metaModelLocal.getTableName().equals(other.metaModelLocal.getTableName())) {
            throw new IllegalArgumentException("can only copy between the same types");
        }
        Map<String, Object> otherAttributes = other.getAttributes();
        for (String name : this.metaModelLocal.getAttributeNamesSkipId()) {
            this.attributes.put(name, otherAttributes.get(name));
            this.dirtyAttributeNames.add(name);
        }
    }

    ModelRegistry modelRegistryLocal() {
        if (this.modelRegistryLocal == null) {
            this.modelRegistryLocal = Registry.instance().modelRegistryOf(this.getClass());
        }
        return this.modelRegistryLocal;
    }

    public void refresh() {
        Object fresh = ModelDelegate.findById(this.getClass(), this.getId());
        if (fresh == null) {
            throw new StaleModelException("Failed to refresh self because probably record with this ID does not exist anymore. Stale model: " + this);
        }
        ((Model)fresh).copyTo(this);
        this.dirtyAttributeNames.clear();
    }

    public Object get(String attributeName) {
        if (this.frozen) {
            throw new FrozenException(this);
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null");
        }
        if (attributeName.equalsIgnoreCase("id") && !this.attributes.containsKey("id")) {
            return this.attributes.get(this.getIdName());
        }
        if (this.metaModelLocal.hasAttribute(attributeName)) {
            Object value = this.attributes.get(attributeName);
            Converter<Object, Object> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Object.class);
            return converter != null ? converter.convert(value) : value;
        }
        String getInferenceProperty = System.getProperty("activejdbc.get.inference");
        if (getInferenceProperty == null || getInferenceProperty.equals("true")) {
            Object returnValue = this.tryParent(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryPolymorphicParent(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryChildren(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryPolymorphicChildren(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryOther(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            this.metaModelLocal.checkAttribute(attributeName);
            return null;
        }
        return null;
    }

    private Object getRaw(String attributeName) {
        if (this.frozen) {
            throw new FrozenException(this);
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null");
        }
        return this.attributes.get(attributeName);
    }

    private Object tryPolymorphicParent(String parentTable) {
        MetaModel parentMM = this.inferTargetMetaModel(parentTable);
        if (parentMM == null) {
            return null;
        }
        return this.metaModelLocal.hasAssociation(parentMM.getModelClass(), BelongsToPolymorphicAssociation.class) ? this.parent(parentMM.getModelClass()) : null;
    }

    private Object tryParent(String parentTable) {
        MetaModel parentMM = this.inferTargetMetaModel(parentTable);
        if (parentMM == null) {
            return null;
        }
        return this.metaModelLocal.hasAssociation(parentMM.getModelClass(), BelongsToAssociation.class) ? this.parent(parentMM.getModelClass()) : null;
    }

    private Object tryPolymorphicChildren(String childTable) {
        MetaModel childMM = this.inferTargetMetaModel(childTable);
        if (childMM == null) {
            return null;
        }
        return this.metaModelLocal.hasAssociation(childMM.getModelClass(), OneToManyPolymorphicAssociation.class) ? this.getAll(childMM.getModelClass()) : null;
    }

    private Object tryChildren(String childTable) {
        MetaModel childMM = this.inferTargetMetaModel(childTable);
        if (childMM == null) {
            return null;
        }
        return this.metaModelLocal.hasAssociation(childMM.getModelClass(), OneToManyAssociation.class) ? this.getAll(childMM.getModelClass()) : null;
    }

    private Object tryOther(String otherTable) {
        MetaModel otherMM = this.inferTargetMetaModel(otherTable);
        if (otherMM == null) {
            return null;
        }
        return this.metaModelLocal.hasAssociation(otherMM.getModelClass(), Many2ManyAssociation.class) ? this.getAll(otherMM.getModelClass()) : null;
    }

    private MetaModel inferTargetMetaModel(String targetTableName) {
        String targetTable = Inflector.singularize((String)targetTableName);
        MetaModel targetMM = ModelDelegate.metaModelFor(targetTable);
        if (targetMM == null) {
            targetTable = Inflector.pluralize((String)targetTableName);
            targetMM = ModelDelegate.metaModelFor(targetTable);
        }
        return targetMM != null ? targetMM : null;
    }

    public String getString(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, String> converter = this.modelRegistryLocal().converterForValue(attributeName, value, String.class);
        return converter != null ? converter.convert(value) : Convert.toString((Object)value);
    }

    public byte[] getBytes(String attributeName) {
        Object value = this.get(attributeName);
        return Convert.toBytes((Object)value);
    }

    public BigDecimal getBigDecimal(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, BigDecimal> converter = this.modelRegistryLocal().converterForValue(attributeName, value, BigDecimal.class);
        return converter != null ? converter.convert(value) : Convert.toBigDecimal((Object)value);
    }

    public Integer getInteger(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Integer> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Integer.class);
        return converter != null ? converter.convert(value) : Convert.toInteger((Object)value);
    }

    public Long getLong(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Long> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Long.class);
        return converter != null ? converter.convert(value) : Convert.toLong((Object)value);
    }

    public Short getShort(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Short> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Short.class);
        return converter != null ? converter.convert(value) : Convert.toShort((Object)value);
    }

    public Float getFloat(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Float> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Float.class);
        return converter != null ? converter.convert(value) : Convert.toFloat((Object)value);
    }

    public Time getTime(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Time> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Time.class);
        return converter != null ? converter.convert(value) : Convert.toTime((Object)value);
    }

    public Timestamp getTimestamp(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Timestamp> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Timestamp.class);
        return converter != null ? converter.convert(value) : Convert.toTimestamp((Object)value);
    }

    public Double getDouble(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Double> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Double.class);
        return converter != null ? converter.convert(value) : Convert.toDouble((Object)value);
    }

    public Boolean getBoolean(String attributeName) {
        Object value = this.getRaw(attributeName);
        Converter<Object, Boolean> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Boolean.class);
        return converter != null ? converter.convert(value) : Convert.toBoolean((Object)value);
    }

    public <T extends Model> T setString(String attributeName, Object value) {
        Converter<Object, String> converter = this.modelRegistryLocal().converterForValue(attributeName, value, String.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toString((Object)value));
    }

    public <T extends Model> T setBigDecimal(String attributeName, Object value) {
        Converter<Object, BigDecimal> converter = this.modelRegistryLocal().converterForValue(attributeName, value, BigDecimal.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toBigDecimal((Object)value));
    }

    public <T extends Model> T setShort(String attributeName, Object value) {
        Converter<Object, Short> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Short.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toShort((Object)value));
    }

    public <T extends Model> T setInteger(String attributeName, Object value) {
        Converter<Object, Integer> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Integer.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toInteger((Object)value));
    }

    public <T extends Model> T setLong(String attributeName, Object value) {
        Converter<Object, Long> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Long.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toLong((Object)value));
    }

    public <T extends Model> T setFloat(String attributeName, Object value) {
        Converter<Object, Float> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Float.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toFloat((Object)value));
    }

    public <T extends Model> T setTime(String attributeName, Object value) {
        Converter<Object, Time> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Time.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toTime((Object)value));
    }

    public <T extends Model> T setTimestamp(String attributeName, Object value) {
        Converter<Object, Timestamp> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Timestamp.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toTimestamp((Object)value));
    }

    public <T extends Model> T setDouble(String attributeName, Object value) {
        Converter<Object, Double> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Double.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toDouble((Object)value));
    }

    public <T extends Model> T setBoolean(String attributeName, Object value) {
        Converter<Object, Boolean> converter = this.modelRegistryLocal().converterForValue(attributeName, value, Boolean.class);
        return this.setRaw(attributeName, converter != null ? converter.convert(value) : Convert.toBoolean((Object)value));
    }

    public <C extends Model> LazyList<C> getAll(Class<C> clazz) {
        List<Model> children = this.cachedChildren.get(clazz);
        if (children != null) {
            return (LazyList)children;
        }
        return this.get(clazz, null, new Object[0]);
    }

    public <C extends Model> LazyList<C> get(Class<C> targetModelClass, String criteria, Object ... params) {
        String subQuery;
        OneToManyAssociation oneToManyAssociation = this.metaModelLocal.getAssociationForTarget(targetModelClass, OneToManyAssociation.class);
        MetaModel mm = this.metaModelLocal;
        Many2ManyAssociation manyToManyAssociation = this.metaModelLocal.getAssociationForTarget(targetModelClass, Many2ManyAssociation.class);
        OneToManyPolymorphicAssociation oneToManyPolymorphicAssociation = this.metaModelLocal.getAssociationForTarget(targetModelClass, OneToManyPolymorphicAssociation.class);
        String additionalCriteria = criteria != null ? " AND ( " + criteria + " ) " : "";
        String targetId = ModelDelegate.metaModelOf(targetModelClass).getIdName();
        MetaModel targetMM = ModelDelegate.metaModelOf(targetModelClass);
        String targetTable = targetMM.getTableName();
        if (oneToManyAssociation != null) {
            subQuery = oneToManyAssociation.getFkName() + " = ? " + additionalCriteria;
        } else {
            if (manyToManyAssociation != null) {
                String joinTable = manyToManyAssociation.getJoin();
                String query = "SELECT " + targetTable + ".* FROM " + targetTable + ", " + joinTable + " WHERE " + targetTable + "." + targetId + " = " + joinTable + "." + manyToManyAssociation.getTargetFkName() + " AND " + joinTable + "." + manyToManyAssociation.getSourceFkName() + " = ? " + additionalCriteria;
                Object[] allParams = new Object[params.length + 1];
                allParams[0] = this.getId();
                System.arraycopy(params, 0, allParams, 1, params.length);
                return new LazyList(true, ModelDelegate.metaModelOf(manyToManyAssociation.getTargetClass()), query, allParams);
            }
            if (oneToManyPolymorphicAssociation != null) {
                subQuery = "parent_id = ? AND  parent_type = '" + oneToManyPolymorphicAssociation.getTypeLabel() + "'" + additionalCriteria;
            } else {
                throw new NotAssociatedException(this.metaModelLocal.getModelClass(), targetModelClass);
            }
        }
        Object[] allParams = new Object[params.length + 1];
        allParams[0] = this.getId();
        System.arraycopy(params, 0, allParams, 1, params.length);
        return new LazyList(subQuery, targetMM, allParams);
    }

    protected static NumericValidationBuilder validateNumericalityOf(String ... attributeNames) {
        return ModelDelegate.validateNumericalityOf(Model.modelClass(), attributeNames);
    }

    public static ValidationBuilder addValidator(Validator validator) {
        return ModelDelegate.validateWith(Model.modelClass(), validator);
    }

    public void addError(String key, String value) {
        this.errors.put(key, value);
    }

    public static void removeValidator(Validator validator) {
        ModelDelegate.removeValidator(Model.modelClass(), validator);
    }

    public static List<Validator> getValidators(Class<? extends Model> clazz) {
        return ModelDelegate.validatorsOf(clazz);
    }

    protected static ValidationBuilder validateRegexpOf(String attributeName, String pattern) {
        return ModelDelegate.validateRegexpOf(Model.modelClass(), attributeName, pattern);
    }

    protected static ValidationBuilder validateEmailOf(String attributeName) {
        return ModelDelegate.validateEmailOf(Model.modelClass(), attributeName);
    }

    protected static ValidationBuilder validateRange(String attributeName, Number min, Number max) {
        return ModelDelegate.validateRange(Model.modelClass(), attributeName, min, max);
    }

    protected static ValidationBuilder validatePresenceOf(String ... attributeNames) {
        return ModelDelegate.validatePresenceOf(Model.modelClass(), attributeNames);
    }

    protected static ValidationBuilder validateWith(Validator validator) {
        return ModelDelegate.validateWith(Model.modelClass(), validator);
    }

    @Deprecated
    protected static ValidationBuilder convertWith(org.javalite.activejdbc.validation.Converter converter) {
        return ModelDelegate.convertWith(Model.modelClass(), converter);
    }

    protected static void convertWith(Converter converter, String ... attributeNames) {
        ModelDelegate.convertWith(Model.modelClass(), converter, attributeNames);
    }

    @Deprecated
    protected static ValidationBuilder convertDate(String attributeName, String format) {
        return ModelDelegate.convertDate(Model.modelClass(), attributeName, format);
    }

    @Deprecated
    protected static ValidationBuilder convertTimestamp(String attributeName, String format) {
        return ModelDelegate.convertTimestamp(Model.modelClass(), attributeName, format);
    }

    protected static void dateFormat(String pattern, String ... attributeNames) {
        ModelDelegate.dateFormat(Model.modelClass(), pattern, attributeNames);
    }

    protected static void dateFormat(DateFormat format, String ... attributeNames) {
        ModelDelegate.dateFormat(Model.modelClass(), format, attributeNames);
    }

    protected static void timestampFormat(String pattern, String ... attributeNames) {
        ModelDelegate.timestampFormat(Model.modelClass(), pattern, attributeNames);
    }

    protected static void timestampFormat(DateFormat format, String ... attributeNames) {
        ModelDelegate.timestampFormat(Model.modelClass(), format, attributeNames);
    }

    protected static void blankToNull(String ... attributeNames) {
        ModelDelegate.blankToNull(Model.modelClass(), attributeNames);
    }

    protected static void zeroToNull(String ... attributeNames) {
        ModelDelegate.zeroToNull(Model.modelClass(), attributeNames);
    }

    public static boolean belongsTo(Class<? extends Model> targetClass) {
        return ModelDelegate.belongsTo(Model.modelClass(), targetClass);
    }

    @Deprecated
    public static void addCallbacks(CallbackListener ... listeners) {
        ModelDelegate.callbackWith(Model.modelClass(), listeners);
    }

    public static void callbackWith(CallbackListener ... listeners) {
        ModelDelegate.callbackWith(Model.modelClass(), listeners);
    }

    public boolean isValid() {
        this.validate();
        return !this.hasErrors();
    }

    public void validate() {
        this.fireBeforeValidation();
        this.errors = new Errors();
        List<Validator> validators = this.modelRegistryLocal().validators();
        if (validators != null) {
            for (Validator validator : validators) {
                validator.validate(this);
            }
        }
        this.fireAfterValidation();
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public void addValidator(Validator validator, String errorKey) {
        if (!this.errors.containsKey(errorKey)) {
            this.errors.addValidator(errorKey, validator);
        }
    }

    public Errors errors() {
        return this.errors;
    }

    public Errors errors(Locale locale) {
        this.errors.setLocale(locale);
        return this.errors;
    }

    public static <T extends Model> T create(Object ... namesAndValues) {
        return ModelDelegate.create(Model.modelClass(), namesAndValues);
    }

    public <T extends Model> T set(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        int i = 0;
        while (i < namesAndValues.length) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("attribute names cannot be null");
            }
            this.set(namesAndValues[i++].toString(), namesAndValues[i++]);
        }
        return (T)this;
    }

    public static <T extends Model> T createIt(Object ... namesAndValues) {
        return ModelDelegate.createIt(Model.modelClass(), namesAndValues);
    }

    public static <T extends Model> T findById(Object id) {
        return ModelDelegate.findById(Model.modelClass(), id);
    }

    public static <T extends Model> T findByCompositeKeys(Object ... values) {
        return ModelDelegate.findByCompositeKeys(Model.modelClass(), values);
    }

    public static <T extends Model> LazyList<T> where(String subquery, Object ... params) {
        return ModelDelegate.where(Model.modelClass(), subquery, params);
    }

    public static <T extends Model> LazyList<T> find(String subquery, Object ... params) {
        return ModelDelegate.where(Model.modelClass(), subquery, params);
    }

    public static <T extends Model> T findFirst(String subQuery, Object ... params) {
        return ModelDelegate.findFirst(Model.modelClass(), subQuery, params);
    }

    public static <T extends Model> T first(String subQuery, Object ... params) {
        return ModelDelegate.findFirst(Model.modelClass(), subQuery, params);
    }

    @Deprecated
    public static void find(String query, ModelListener listener) {
        ModelDelegate.findWith(Model.modelClass(), listener, query, new Object[0]);
    }

    public static void findWith(ModelListener listener, String query, Object ... params) {
        ModelDelegate.findWith(Model.modelClass(), listener, query, params);
    }

    public static <T extends Model> LazyList<T> findBySQL(String fullQuery, Object ... params) {
        return ModelDelegate.findBySql(Model.modelClass(), fullQuery, params);
    }

    public static <T extends Model> LazyList<T> findAll() {
        return ModelDelegate.findAll(Model.modelClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Model child) {
        if (child == null) {
            throw new IllegalArgumentException("cannot add what is null");
        }
        MetaModel childMetaModel = ModelDelegate.metaModelOf(child.getClass());
        MetaModel metaModel = this.metaModelLocal;
        if (this.getId() == null) throw new IllegalArgumentException("You can only add associated model to an instance that exists in DB. Save this instance first, then you will be able to add dependencies to it.");
        if (metaModel.hasAssociation(child.getClass(), OneToManyAssociation.class)) {
            OneToManyAssociation ass = metaModel.getAssociationForTarget(child.getClass(), OneToManyAssociation.class);
            String fkName = ass.getFkName();
            child.set(fkName, this.getId());
            child.saveIt();
            return;
        } else if (metaModel.hasAssociation(child.getClass(), Many2ManyAssociation.class)) {
            MetaModel joinMetaModel;
            Many2ManyAssociation ass = metaModel.getAssociationForTarget(child.getClass(), Many2ManyAssociation.class);
            if (child.getId() == null) {
                child.saveIt();
            }
            if ((joinMetaModel = ModelDelegate.metaModelFor(ass.getJoin())) == null) {
                new DB(metaModel.getDbName()).exec(metaModel.getDialect().insertManyToManyAssociation(ass), this.getId(), child.getId());
                return;
            } else {
                try {
                    Model joinModel = joinMetaModel.getModelClass().newInstance();
                    joinModel.set(ass.getSourceFkName(), this.getId());
                    joinModel.set(ass.getTargetFkName(), child.getId());
                    joinModel.saveIt();
                    return;
                }
                catch (InstantiationException e) {
                    throw new InitException("failed to create a new instance of class: " + joinMetaModel.getClass() + ", are you sure this class has a default constructor?", e);
                }
                catch (IllegalAccessException e) {
                    throw new InitException(e);
                }
                finally {
                    Registry.cacheManager().purgeTableCache(ass.getJoin());
                    Registry.cacheManager().purgeTableCache(metaModel);
                    Registry.cacheManager().purgeTableCache(childMetaModel);
                }
            }
        } else {
            if (!metaModel.hasAssociation(child.getClass(), OneToManyPolymorphicAssociation.class)) throw new NotAssociatedException(this.getClass(), child.getClass());
            OneToManyPolymorphicAssociation ass = metaModel.getAssociationForTarget(child.getClass(), OneToManyPolymorphicAssociation.class);
            child.set("parent_id", this.getId());
            child.set("parent_type", (Object)ass.getTypeLabel());
            child.saveIt();
        }
    }

    public <T extends Model> void addModels(List<T> models) {
        for (Model model : models) {
            this.add(model);
        }
    }

    public int remove(Model child) {
        if (child == null) {
            throw new IllegalArgumentException("cannot remove what is null");
        }
        if (child.frozen() || child.getId() == null) {
            throw new IllegalArgumentException("Cannot remove a child that does not exist in DB (either frozen, or ID not set)");
        }
        if (this.getId() != null) {
            MetaModel metaModel = this.metaModelLocal;
            if (metaModel.hasAssociation(child.getClass(), OneToManyAssociation.class) || metaModel.hasAssociation(child.getClass(), OneToManyPolymorphicAssociation.class)) {
                child.delete();
                return 1;
            }
            if (metaModel.hasAssociation(child.getClass(), Many2ManyAssociation.class)) {
                return new DB(metaModel.getDbName()).exec(metaModel.getDialect().deleteManyToManyAssociation(metaModel.getAssociationForTarget(child.getClass(), Many2ManyAssociation.class)), this.getId(), child.getId());
            }
            throw new NotAssociatedException(this.getClass(), child.getClass());
        }
        throw new IllegalArgumentException("You can only add associated model to an instance that exists in DB. Save this instance first, then you will be able to add dependencies to it.");
    }

    public boolean saveIt() {
        boolean result = this.save();
        ModelDelegate.purgeEdges(this.metaModelLocal);
        if (!this.errors.isEmpty()) {
            throw new ValidationException(this);
        }
        return result;
    }

    public void reset() {
        this.attributes = new CaseInsensitiveMap<Object>();
    }

    public void thaw() {
        this.attributes.put(this.getIdName(), null);
        this.compositeKeyPersisted = false;
        this.dirtyAttributeNames.addAll(this.attributes.keySet());
        this.frozen = false;
    }

    public void defrost() {
        this.thaw();
    }

    public boolean save() {
        if (this.frozen) {
            throw new FrozenException(this);
        }
        this.fireBeforeSave();
        this.validate();
        if (this.hasErrors()) {
            return false;
        }
        boolean result = this.getId() == null && !this.compositeKeyPersisted ? this.insert() : this.update();
        this.fireAfterSave();
        return result;
    }

    public static Long count() {
        return ModelDelegate.count(Model.modelClass());
    }

    public static Long count(String query, Object ... params) {
        return ModelDelegate.count(Model.modelClass(), query, params);
    }

    public boolean insert() {
        this.fireBeforeCreate();
        this.doCreatedAt();
        this.doUpdatedAt();
        MetaModel metaModel = this.metaModelLocal;
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (entry.getValue() == null || metaModel.getVersionColumn().equals(entry.getKey())) continue;
            columns.add(entry.getKey());
            values.add(entry.getValue());
        }
        if (metaModel.isVersioned()) {
            columns.add(metaModel.getVersionColumn());
            values.add(1);
        }
        try {
            boolean done;
            boolean containsId = this.attributes.get(metaModel.getIdName()) != null;
            String query = metaModel.getDialect().insertParametrized(metaModel, columns, containsId);
            if (containsId || this.getCompositeKeys() != null) {
                done = 1 == new DB(metaModel.getDbName()).exec(query, values.toArray());
                this.compositeKeyPersisted = done;
            } else {
                Object id = new DB(metaModel.getDbName()).execInsert(query, metaModel.getIdName(), values.toArray());
                this.attributes.put(metaModel.getIdName(), id);
                boolean bl = done = id != null;
            }
            if (metaModel.cached()) {
                Registry.cacheManager().purgeTableCache(metaModel);
            }
            if (metaModel.isVersioned()) {
                this.attributes.put(metaModel.getVersionColumn(), 1);
            }
            this.dirtyAttributeNames.clear();
            this.fireAfterCreate();
            return done;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    private void doCreatedAt() {
        if (this.manageTime && this.metaModelLocal.hasAttribute("created_at")) {
            this.attributes.put("created_at", new Timestamp(System.currentTimeMillis()));
        }
    }

    private void doUpdatedAt() {
        if (this.manageTime && this.metaModelLocal.hasAttribute("updated_at")) {
            this.attributes.put("updated_at", new Timestamp(System.currentTimeMillis()));
        }
    }

    private boolean update() {
        this.fireBeforeUpdate();
        this.doUpdatedAt();
        MetaModel metaModel = this.metaModelLocal;
        StringBuilder query = new StringBuilder().append("UPDATE ").append(metaModel.getTableName()).append(" SET ");
        Set<String> attributeNames = metaModel.getAttributeNamesSkipGenerated(this.manageTime);
        attributeNames.retainAll(this.dirtyAttributeNames);
        if (attributeNames.size() > 0) {
            Util.join((StringBuilder)query, attributeNames, (String)" = ?, ");
            query.append(" = ?");
        }
        List<Object> values = this.getAttributeValues(attributeNames);
        if (this.manageTime && metaModel.hasAttribute("updated_at")) {
            if (values.size() > 0) {
                query.append(", ");
            }
            query.append("updated_at = ?");
            values.add(this.get("updated_at"));
        }
        if (metaModel.isVersioned()) {
            if (values.size() > 0) {
                query.append(", ");
            }
            query.append(this.metaModelLocal.getVersionColumn()).append(" = ?");
            values.add(this.getLong(this.metaModelLocal.getVersionColumn()) + 1L);
        }
        if (values.isEmpty()) {
            return false;
        }
        if (this.getCompositeKeys() != null) {
            String[] compositeKeys = this.getCompositeKeys();
            for (int i = 0; i < compositeKeys.length; ++i) {
                query.append(i == 0 ? " WHERE " : " AND ").append(compositeKeys[i]).append(" = ?");
                values.add(this.get(compositeKeys[i]));
            }
        } else {
            query.append(" WHERE ").append(metaModel.getIdName()).append(" = ?");
            values.add(this.getId());
        }
        if (metaModel.isVersioned()) {
            query.append(" AND ").append(this.metaModelLocal.getVersionColumn()).append(" = ?");
            values.add(this.get(this.metaModelLocal.getVersionColumn()));
        }
        int updated = new DB(metaModel.getDbName()).exec(query.toString(), values.toArray());
        if (metaModel.isVersioned() && updated == 0) {
            throw new StaleModelException("Failed to update record for model '" + this.getClass() + "', with " + this.getIdName() + " = " + this.getId() + " and " + this.metaModelLocal.getVersionColumn() + " = " + this.get(this.metaModelLocal.getVersionColumn()) + ". Either this record does not exist anymore, or has been updated to have another " + this.metaModelLocal.getVersionColumn() + '.');
        }
        if (metaModel.isVersioned()) {
            this.set(this.metaModelLocal.getVersionColumn(), (Object)(this.getLong(this.metaModelLocal.getVersionColumn()) + 1L));
        }
        if (metaModel.cached()) {
            Registry.cacheManager().purgeTableCache(metaModel);
        }
        this.dirtyAttributeNames.clear();
        this.fireAfterUpdate();
        return updated > 0;
    }

    private List<Object> getAttributeValues(Set<String> attributeNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String attribute : attributeNames) {
            values.add(this.get(attribute));
        }
        return values;
    }

    private static <T extends Model> Class<T> modelClass() {
        throw new InitException("failed to determine Model class name, are you sure models have been instrumented?");
    }

    public static String getTableName() {
        return ModelDelegate.tableNameOf(Model.modelClass());
    }

    public Object getId() {
        return this.get(this.getIdName());
    }

    public String getIdName() {
        return this.metaModelLocal.getIdName();
    }

    public String[] getCompositeKeys() {
        return this.metaModelLocal.getCompositeKeys();
    }

    protected void setChildren(Class childClass, List<Model> children) {
        this.cachedChildren.put(childClass, children);
    }

    public void manageTime(boolean manage) {
        this.manageTime = manage;
    }

    public String toInsert() {
        return this.toInsert(this.metaModelLocal.getDialect());
    }

    public String toInsert(Dialect dialect) {
        return dialect.insert(this.metaModelLocal, this.attributes);
    }

    public String toUpdate() {
        return this.toUpdate(this.metaModelLocal.getDialect());
    }

    public String toUpdate(Dialect dialect) {
        return dialect.update(this.metaModelLocal, this.attributes);
    }

    @Deprecated
    public String toInsert(String leftStringQuote, String rightStringQuote) {
        return this.toInsert(new SimpleFormatter(Date.class, "'", "'"), new SimpleFormatter(Timestamp.class, "'", "'"), new SimpleFormatter(String.class, leftStringQuote, rightStringQuote));
    }

    @Deprecated
    public String toInsert(Formatter ... formatters) {
        HashMap<Class, Formatter> formatterMap = new HashMap<Class, Formatter>();
        for (Formatter f : formatters) {
            formatterMap.put(f.getValueClass(), f);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.metaModelLocal.getTableName()).append(" (");
        Util.join((StringBuilder)sb, this.attributes.keySet(), (String)", ");
        sb.append(") VALUES (");
        Iterator<Object> it = this.attributes.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value == null) {
                sb.append("NULL");
            } else if (value instanceof String && !formatterMap.containsKey(String.class)) {
                sb.append('\'').append(value).append('\'');
            } else if (formatterMap.containsKey(value.getClass())) {
                sb.append(((Formatter)formatterMap.get(value.getClass())).format(value));
            } else {
                sb.append(value);
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static void purgeCache() {
        ModelDelegate.purgeCache(Model.modelClass());
    }

    public Long getLongId() {
        Object id = this.getId();
        if (id == null) {
            throw new NullPointerException(this.getIdName() + " is null, cannot convert to Long");
        }
        return Convert.toLong((Object)id);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.attributes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.attributes = new CaseInsensitiveMap<Object>();
        this.attributes.putAll((Map)in.readObject());
    }
}

