/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.rest.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassModifier {
    private static final LongHolder COUNTER = new LongHolder();

    private ClassModifier() {
    }

    private static void addNewAnnotations(Annotation[] add, CtMethod method, ConstPool constpool, ClassPool classPool, AnnotationsAttribute attr) throws IllegalAccessException, NotFoundException, InvocationTargetException {
        if (null == attr) {
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            method.getMethodInfo().addAttribute((AttributeInfo)attr);
        }
        for (Annotation toAdd : add) {
            attr.addAnnotation(ClassModifier.toJavassist(toAdd, constpool, classPool));
        }
    }

    private static AnnotationsAttribute filterExistingAnnotations(Annotation[] remove, CtMethod method) {
        AnnotationsAttribute attr = null;
        List attributes = method.getMethodInfo().getAttributes();
        for (Object attribute : attributes) {
            if (!(attribute instanceof AnnotationsAttribute)) continue;
            attr = (AnnotationsAttribute)attribute;
            ArrayList<javassist.bytecode.annotation.Annotation> annotations = new ArrayList<javassist.bytecode.annotation.Annotation>();
            for (javassist.bytecode.annotation.Annotation annotation : attr.getAnnotations()) {
                boolean shouldRemove = false;
                for (Annotation annotationToRemove : remove) {
                    if (!annotationToRemove.annotationType().getCanonicalName().equals(annotation.getTypeName())) continue;
                    shouldRemove = true;
                }
                if (shouldRemove) continue;
                annotations.add(annotation);
            }
            attr.setAnnotations(annotations.toArray(new javassist.bytecode.annotation.Annotation[annotations.size()]));
        }
        return attr;
    }

    public static <T> Class<T> getModifiedClass(Class<T> clazz, Annotation[] add) throws NotFoundException, CannotCompileException, InvocationTargetException, IllegalAccessException {
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.get(clazz.getCanonicalName());
        for (CtMethod method : cc.getDeclaredMethods()) {
            ClassFile ccFile = cc.getClassFile();
            ConstPool constpool = ccFile.getConstPool();
            AnnotationsAttribute attr = ClassModifier.filterExistingAnnotations(add, method);
            ClassModifier.addNewAnnotations(add, method, constpool, pool, attr);
        }
        cc.setName(cc.getName() + "$ClassModifier$" + ClassModifier.COUNTER.increment());
        cc.setSuperclass(pool.get(clazz.getCanonicalName()));
        return cc.toClass();
    }

    private static CtClass getType(Object value, Class<?> valueType, ClassPool classPool) throws NotFoundException {
        if (value instanceof Boolean) {
            return CtClass.booleanType;
        }
        if (value instanceof Byte) {
            return CtClass.byteType;
        }
        if (value instanceof Character) {
            return CtClass.charType;
        }
        if (value instanceof Short) {
            return CtClass.shortType;
        }
        if (value instanceof Integer) {
            return CtClass.intType;
        }
        if (value instanceof Long) {
            return CtClass.longType;
        }
        if (value instanceof Float) {
            return CtClass.floatType;
        }
        if (value instanceof Double) {
            return CtClass.doubleType;
        }
        try {
            return classPool.get(value.getClass().getCanonicalName());
        }
        catch (NotFoundException e) {
            return classPool.get(valueType.getCanonicalName());
        }
    }

    private static javassist.bytecode.annotation.Annotation toJavassist(Annotation annotation, ConstPool constpool, ClassPool classPool) throws NotFoundException, InvocationTargetException, IllegalAccessException {
        javassist.bytecode.annotation.Annotation newAnnotation = new javassist.bytecode.annotation.Annotation(annotation.annotationType().getCanonicalName(), constpool);
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            Object value = method.invoke((Object)annotation, new Object[0]);
            Class<?> componentType = null;
            if (method.getReturnType().isArray()) {
                componentType = method.getReturnType().getComponentType();
            }
            newAnnotation.addMemberValue(method.getName(), ClassModifier.toMemberValue(value, componentType, constpool, classPool));
        }
        return newAnnotation;
    }

    private static MemberValue toMemberValue(Object value, Class<?> componentType, ConstPool constpool, ClassPool classPool) throws NotFoundException {
        CtClass type = ClassModifier.getType(value, componentType, classPool);
        MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)constpool, (CtClass)type);
        if (memberValue instanceof BooleanMemberValue) {
            ((BooleanMemberValue)memberValue).setValue(((Boolean)value).booleanValue());
        } else if (memberValue instanceof ByteMemberValue) {
            ((ByteMemberValue)memberValue).setValue(((Byte)value).byteValue());
        } else if (memberValue instanceof CharMemberValue) {
            ((CharMemberValue)memberValue).setValue(((Character)value).charValue());
        } else if (memberValue instanceof ShortMemberValue) {
            ((ShortMemberValue)memberValue).setValue(((Short)value).shortValue());
        } else if (memberValue instanceof IntegerMemberValue) {
            ((IntegerMemberValue)memberValue).setValue(((Integer)value).intValue());
        } else if (memberValue instanceof LongMemberValue) {
            ((LongMemberValue)memberValue).setValue(((Long)value).longValue());
        } else if (memberValue instanceof FloatMemberValue) {
            ((FloatMemberValue)memberValue).setValue(((Float)value).floatValue());
        } else if (memberValue instanceof DoubleMemberValue) {
            ((DoubleMemberValue)memberValue).setValue(((Double)value).doubleValue());
        } else if (memberValue instanceof ClassMemberValue) {
            ((ClassMemberValue)memberValue).setValue(((Class)value).getCanonicalName());
        } else if (memberValue instanceof StringMemberValue) {
            ((StringMemberValue)memberValue).setValue((String)value);
        } else if (type.isArray()) {
            ((ArrayMemberValue)memberValue).setValue(ClassModifier.toMemberValue((Object[])value, componentType, constpool, classPool));
        } else if (type.isInterface()) {
            javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(type.getName(), constpool);
            for (Method method : componentType.getDeclaredMethods()) {
                try {
                    annotation.addMemberValue(method.getName(), ClassModifier.toMemberValue(method.invoke(value, new Object[0]), null, constpool, classPool));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ((AnnotationMemberValue)memberValue).setValue(annotation);
        } else {
            ((EnumMemberValue)memberValue).setValue((String)value);
        }
        return memberValue;
    }

    private static MemberValue[] toMemberValue(Object[] value, Class<?> valueType, ConstPool constpool, ClassPool classPool) throws NotFoundException {
        MemberValue[] memberValues = new MemberValue[value.length];
        for (int i = 0; i < value.length; ++i) {
            memberValues[i] = ClassModifier.toMemberValue(value[i], valueType, constpool, classPool);
        }
        return memberValues;
    }

    private static class LongHolder {
        private Long value = 1L;

        private LongHolder() {
        }

        private synchronized long increment() {
            Long l = this.value;
            Long l2 = this.value = Long.valueOf(this.value + 1L);
            return l;
        }
    }
}

