/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.InterceptionModelImpl;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class InterceptionModelBuilder {
    private boolean isModelBuilt = false;
    private boolean hasExternalNonConstructorInterceptors;
    private final Set<Method> methodsIgnoringGlobalInterceptors = new HashSet<Method>();
    private final Set<InterceptorClassMetadata<?>> allInterceptors = new LinkedHashSet();
    private final Map<InterceptionType, List<InterceptorClassMetadata<?>>> globalInterceptors = new EnumMap(InterceptionType.class);
    private final Map<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> methodBoundInterceptors = new EnumMap(InterceptionType.class);
    private TargetClassInterceptorMetadata targetClassInterceptorMetadata;
    private final Map<Member, Set<Annotation>> memberInterceptorBindings = new HashMap<Member, Set<Annotation>>();
    private Set<Annotation> classInterceptorBindings;

    public InterceptionModel build() {
        this.checkModelNotBuilt();
        this.isModelBuilt = true;
        return new InterceptionModelImpl(this);
    }

    public void interceptMethod(javax.enterprise.inject.spi.InterceptionType interceptionType, Method method, Collection<InterceptorClassMetadata<?>> interceptors, Set<Annotation> interceptorBindings) {
        List<InterceptorClassMetadata<?>> interceptorsList;
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        if (weldInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Illegal interception type: " + (Object)((Object)interceptionType));
        }
        if (null == this.methodBoundInterceptors.get((Object)weldInterceptionType)) {
            this.methodBoundInterceptors.put(weldInterceptionType, new HashMap());
        }
        if ((interceptorsList = this.methodBoundInterceptors.get((Object)weldInterceptionType).get(method)) == null) {
            interceptorsList = new ArrayList();
            this.methodBoundInterceptors.get((Object)weldInterceptionType).put(method, interceptorsList);
        }
        interceptorsList.addAll(interceptors);
        this.intercept(weldInterceptionType, interceptorsList);
        if (interceptorBindings != null) {
            this.memberInterceptorBindings.put(method, interceptorBindings);
        }
    }

    public void interceptGlobal(javax.enterprise.inject.spi.InterceptionType interceptionType, Constructor<?> constructor, Collection<InterceptorClassMetadata<?>> interceptors, Set<Annotation> interceptorBindings) {
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        List<InterceptorClassMetadata<?>> interceptorsList = this.globalInterceptors.get((Object)weldInterceptionType);
        if (interceptorsList == null) {
            interceptorsList = new ArrayList();
            this.globalInterceptors.put(weldInterceptionType, interceptorsList);
        }
        interceptorsList.addAll(interceptors);
        this.intercept(weldInterceptionType, interceptorsList);
        if (interceptorBindings != null) {
            this.memberInterceptorBindings.put(constructor, interceptorBindings);
        }
    }

    private void intercept(InterceptionType interceptionType, Collection<InterceptorClassMetadata<?>> interceptors) {
        if (interceptionType != InterceptionType.AROUND_CONSTRUCT) {
            this.hasExternalNonConstructorInterceptors = true;
        }
        this.allInterceptors.addAll(interceptors);
    }

    public void addMethodIgnoringGlobalInterceptors(Method method) {
        this.checkModelNotBuilt();
        this.methodsIgnoringGlobalInterceptors.add(method);
    }

    boolean isHasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    Set<Method> getMethodsIgnoringGlobalInterceptors() {
        return this.methodsIgnoringGlobalInterceptors;
    }

    Set<InterceptorClassMetadata<?>> getAllInterceptors() {
        return this.allInterceptors;
    }

    Map<InterceptionType, List<InterceptorClassMetadata<?>>> getGlobalInterceptors() {
        return this.globalInterceptors;
    }

    Map<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> getMethodBoundInterceptors() {
        return this.methodBoundInterceptors;
    }

    private void checkModelNotBuilt() {
        if (this.isModelBuilt) {
            throw new IllegalStateException("InterceptionModelBuilder cannot be reused");
        }
    }

    TargetClassInterceptorMetadata getTargetClassInterceptorMetadata() {
        return this.targetClassInterceptorMetadata;
    }

    public void setTargetClassInterceptorMetadata(TargetClassInterceptorMetadata targetClassInterceptorMetadata) {
        this.targetClassInterceptorMetadata = targetClassInterceptorMetadata;
    }

    Collection<Annotation> getClassInterceptorBindings() {
        return this.classInterceptorBindings;
    }

    public void setClassInterceptorBindings(Set<Annotation> classInterceptorBindings) {
        this.classInterceptorBindings = classInterceptorBindings;
    }

    Map<Member, Set<Annotation>> getMemberInterceptorBindings() {
        return this.memberInterceptorBindings;
    }
}

