/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.console.security.nacos.roles.NacosRoleServiceImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/roles"})
public class RoleController {
    @Autowired
    private NacosRoleServiceImpl roleService;

    @GetMapping
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public Object getRoles(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username) {
        return this.roleService.getRolesFromDatabase(username, pageNo, pageSize);
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public List<String> searchRoles(@RequestParam String role) {
        return this.roleService.findRolesLikeRoleName(role);
    }

    @PostMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Object addRole(@RequestParam String role, @RequestParam String username) {
        this.roleService.addRole(role, username);
        return new RestResult(200, "add role ok!");
    }

    @DeleteMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Object deleteRole(@RequestParam String role, @RequestParam(name="username", defaultValue="") String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            this.roleService.deleteRole(role);
        } else {
            this.roleService.deleteRole(role, username);
        }
        return new RestResult(200, "delete role of user " + username + " ok!");
    }
}

