/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jexl.util.introspection.MethodMap;
import org.apache.commons.logging.Log;

public class ClassMap {
    private final Class clazz;
    private final Log rlog;
    private final MethodCache methodCache;
    private static final int ACC_BRIDGE = 64;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public ClassMap(Class aClass, Log rlog) {
        this.clazz = aClass;
        this.rlog = rlog;
        this.methodCache = new MethodCache();
        this.populateMethodCache();
    }

    Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        return this.methodCache.get(name, params);
    }

    private void populateMethodCache() {
        ArrayList classesToReflect = new ArrayList();
        for (Class classToReflect = this.getCachedClass(); classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                classesToReflect.add(classToReflect);
            }
            Class<?>[] interfaces = classToReflect.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                classesToReflect.add(interfaces[i]);
            }
        }
        Iterator it = classesToReflect.iterator();
        while (it.hasNext()) {
            Class classToReflect = (Class)it.next();
            try {
                Method[] methods = classToReflect.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    int modifiers = methods[i].getModifiers();
                    if (!Modifier.isPublic(modifiers) || (modifiers & 0x40) != 0) continue;
                    this.methodCache.put(methods[i]);
                }
            }
            catch (SecurityException se) {
                if (!this.rlog.isDebugEnabled()) continue;
                this.rlog.debug((Object)("While accessing methods of " + classToReflect + ": "), (Throwable)se);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class MethodCache {
        private static final CacheMiss CACHE_MISS = new CacheMiss();
        private static final Object OBJECT = new Object();
        private static final Map convertPrimitives = new HashMap();
        private final Map cache = new HashMap();
        private final MethodMap methodMap = new MethodMap();

        private MethodCache() {
        }

        public synchronized Method get(String name, Object[] params) throws MethodMap.AmbiguousException {
            String methodKey = this.makeMethodKey(name, params);
            Object cacheEntry = this.cache.get(methodKey);
            if (cacheEntry == CACHE_MISS) {
                return null;
            }
            if (cacheEntry == null) {
                try {
                    cacheEntry = this.methodMap.find(name, params);
                }
                catch (MethodMap.AmbiguousException ae) {
                    this.cache.put(methodKey, CACHE_MISS);
                    throw ae;
                }
                this.cache.put(methodKey, cacheEntry != null ? cacheEntry : CACHE_MISS);
            }
            return (Method)cacheEntry;
        }

        public synchronized void put(Method method) {
            String methodKey = this.makeMethodKey(method);
            if (this.cache.get(methodKey) == null) {
                this.cache.put(methodKey, method);
                this.methodMap.add(method);
            }
        }

        private String makeMethodKey(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            StringBuffer methodKey = new StringBuffer(method.getName());
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (parameterTypes[j].isPrimitive()) {
                    methodKey.append((String)convertPrimitives.get(parameterTypes[j]));
                    continue;
                }
                methodKey.append(parameterTypes[j].getName());
            }
            return methodKey.toString();
        }

        private String makeMethodKey(String method, Object[] params) {
            StringBuffer methodKey = new StringBuffer().append(method);
            for (int j = 0; j < params.length; ++j) {
                Object arg = params[j];
                if (arg == null) {
                    arg = OBJECT;
                }
                methodKey.append(arg.getClass().getName());
            }
            return methodKey.toString();
        }

        static {
            convertPrimitives.put(Boolean.TYPE, (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassMap.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
            convertPrimitives.put(Byte.TYPE, (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassMap.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
            convertPrimitives.put(Character.TYPE, (class$java$lang$Character == null ? (class$java$lang$Character = ClassMap.class$("java.lang.Character")) : class$java$lang$Character).getName());
            convertPrimitives.put(Double.TYPE, (class$java$lang$Double == null ? (class$java$lang$Double = ClassMap.class$("java.lang.Double")) : class$java$lang$Double).getName());
            convertPrimitives.put(Float.TYPE, (class$java$lang$Float == null ? (class$java$lang$Float = ClassMap.class$("java.lang.Float")) : class$java$lang$Float).getName());
            convertPrimitives.put(Integer.TYPE, (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassMap.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
            convertPrimitives.put(Long.TYPE, (class$java$lang$Long == null ? (class$java$lang$Long = ClassMap.class$("java.lang.Long")) : class$java$lang$Long).getName());
            convertPrimitives.put(Short.TYPE, (class$java$lang$Short == null ? (class$java$lang$Short = ClassMap.class$("java.lang.Short")) : class$java$lang$Short).getName());
        }

        private static final class CacheMiss {
            private CacheMiss() {
            }
        }
    }
}

