/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.android.parcel.IgnoredOnParcel;
import kotlinx.android.parcel.TypeParceler;
import kotlinx.android.parcel.WriteWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableResolveExtensionKt;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0012\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIgnoredOnParcelUsage", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "checkTypeParcelerUsage", "checkWriteWithUsage", "checkIfTheContainingClassIsParcelize", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Companion", "android-extensions-compiler"})
@SourceDebugExtension(value={"SMAP\nParcelableAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParcelableAnnotationChecker.kt\norg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ParcelableAnnotationChecker.kt\norg/jetbrains/kotlin/android/parcel/ParcelableAnnotationCheckerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1#2:193\n175#3:178\n171#3:179\n171#3:200\n171#3:204\n774#4:180\n865#4,2:181\n1611#4,9:183\n1863#4:192\n1864#4:194\n1620#4:195\n1782#4,4:196\n1755#4,3:201\n295#4,2:205\n*S KotlinDebug\n*F\n+ 1 ParcelableAnnotationChecker.kt\norg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker\n*L\n90#1:193\n53#1:178\n54#1:179\n107#1:200\n136#1:204\n89#1:180\n89#1:181,2\n90#1:183,9\n90#1:192\n90#1:194\n90#1:195\n91#1:196,4\n113#1:201,3\n147#1:205,2\n*E\n"})
public final class ParcelableAnnotationChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName TYPE_PARCELER_FQNAME = new FqName(TypeParceler.class.getName());
    @NotNull
    private static final FqName WRITE_WITH_FQNAME = new FqName(WriteWith.class.getName());
    @NotNull
    private static final FqName IGNORED_ON_PARCEL_FQNAME = new FqName(IgnoredOnParcel.class.getName());

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        ClassConstructorDescriptor classConstructorDescriptor = callableDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)callableDescriptor : null;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        ClassDescriptor it = classDescriptor = constructorDescriptor.getConstructedClass();
        boolean bl = false;
        Object object = it.getKind() == ClassKind.ANNOTATION_CLASS ? classDescriptor : null;
        if (object == null) {
            return;
        }
        ClassDescriptor annotationClass = object;
        KtElement ktElement = resolvedCall.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)ktElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)annotationEntry;
        boolean $i$f$getStrictParentOfType = false;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtModifierListOwner.class, (boolean)true);
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner annotationOwner = ktModifierListOwner;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)TYPE_PARCELER_FQNAME)) {
            this.checkTypeParcelerUsage(resolvedCall, annotationEntry, context, annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)WRITE_WITH_FQNAME)) {
            this.checkWriteWithUsage(resolvedCall, annotationEntry, context, annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)IGNORED_ON_PARCEL_FQNAME)) {
            this.checkIgnoredOnParcelUsage(annotationEntry, context, annotationOwner);
        }
    }

    private final void checkIgnoredOnParcelUsage(KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        if (element instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtPrimaryConstructor) {
            context.getTrace().report((Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY.on((PsiElement)annotationEntry));
        } else if (!(element instanceof KtProperty) || !(PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtClass)) {
            context.getTrace().report((Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL.on((PsiElement)annotationEntry));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        int duplicatingAnnotationCount;
        int n;
        void $this$count$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor descriptor = declarationDescriptor;
        KotlinType it2 = object = resolvedCall.getTypeArguments().values();
        boolean $i$a$-takeIf-ParcelableAnnotationChecker$checkTypeParcelerUsage$thisMappedType$22 = false;
        Object object2 = it2.size() == 2 ? object : null;
        if (object2 == null || (object2 = (KotlinType)CollectionsKt.first((Iterable)((Iterable)object2))) == null) {
            return;
        }
        KotlinType thisMappedType = object2;
        object = (Iterable)descriptor.getAnnotations();
        boolean $i$f$filter = false;
        void $i$a$-takeIf-ParcelableAnnotationChecker$checkTypeParcelerUsage$thisMappedType$22 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)TYPE_PARCELER_FQNAME)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            KotlinType it$iv$iv;
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            AnnotationDescriptor it3 = (AnnotationDescriptor)element$iv$iv;
            boolean bl2 = false;
            List args = list = it3.getType().getArguments();
            boolean bl3 = false;
            List list2 = args.size() == 2 ? list : null;
            if ((list2 != null && (list2 = (TypeProjection)CollectionsKt.first((List)list2)) != null ? list2.getType() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KotlinType it4 = (KotlinType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it4, (Object)thisMappedType) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = duplicatingAnnotationCount = count$iv;
        }
        if (duplicatingAnnotationCount > 1) {
            List list = annotationEntry.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeArguments(...)");
            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.firstOrNull((List)list);
            KtElementImplStub reportElement = ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)annotationEntry;
            context.getTrace().report((Diagnostic)ErrorsAndroid.DUPLICATING_TYPE_PARCELERS.on((PsiElement)reportElement));
            return;
        }
        KtModifierListOwner $i$f$count22 = element;
        KtClassOrObject containingClass = $i$f$count22 instanceof KtClassOrObject ? (KtClassOrObject)element : ($i$f$count22 instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element)) : null);
        this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context);
        if (element instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true) instanceof KtPrimaryConstructor) {
                ClassDescriptor containingClassDescriptor = (ClassDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass);
                AnnotationDescriptor thisAnnotationDescriptor = (AnnotationDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry);
                if (containingClass != null && containingClassDescriptor != null && thisAnnotationDescriptor != null) {
                    boolean bl;
                    block15: {
                        Iterable $this$any$iv = (Iterable)containingClassDescriptor.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (AnnotationDescriptor)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)thisAnnotationDescriptor.getType())) continue;
                                bl = true;
                                break block15;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
                        Object object3 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                        KtUserType ktUserType = object3 instanceof KtUserType ? (KtUserType)object3 : null;
                        KtElement reportElement = ktUserType != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
                        context.getTrace().report((Diagnostic)ErrorsAndroid.REDUNDANT_TYPE_PARCELER.on((PsiElement)reportElement, (Object)containingClass));
                    }
                }
            }
        }
    }

    private final void checkWriteWithUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        Object v4;
        KotlinType actualType;
        block9: {
            if ((element instanceof KtTypeReference ? (KtTypeReference)element : null) == null) {
                return;
            }
            KotlinType kotlinType = (KotlinType)context.getTrace().get((ReadOnlySlice)BindingContext.TYPE, (Object)element);
            if (kotlinType == null || (kotlinType = TypeUtilsKt.replaceAnnotations((KotlinType)kotlinType, (Annotations)Annotations.Companion.getEMPTY())) == null) {
                return;
            }
            actualType = kotlinType;
            KotlinType kotlinType2 = (KotlinType)CollectionsKt.singleOrNull((Iterable)resolvedCall.getTypeArguments().values());
            if (kotlinType2 == null) {
                return;
            }
            KotlinType parcelerType = kotlinType2;
            ClassifierDescriptor classifierDescriptor = parcelerType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor parcelerClass = classDescriptor;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context);
            if (parcelerClass.getKind() != ClassKind.OBJECT) {
                context.getTrace().report((Diagnostic)ErrorsAndroid.PARCELER_SHOULD_BE_OBJECT.on((PsiElement)ParcelableAnnotationChecker.checkWriteWithUsage$reportElement(annotationEntry)));
                return;
            }
            SimpleType simpleType = parcelerClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            Iterable $this$firstOrNull$iv = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ParcelableAnnotationChecker.checkWriteWithUsage$fqName(it), (Object)ParcelableResolveExtensionKt.getPARCELER_FQNAME())) continue;
                v4 = element$iv;
                break block9;
            }
            v4 = null;
        }
        KotlinType kotlinType = v4;
        if (kotlinType == null) {
            return;
        }
        KotlinType parcelerSuperType = kotlinType;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)parcelerSuperType.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return;
        }
        TypeProjection expectedType = typeProjection;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)actualType, (KotlinType)expectedType)) {
            context.getTrace().report((Diagnostic)ErrorsAndroid.PARCELER_TYPE_INCOMPATIBLE.on((PsiElement)ParcelableAnnotationChecker.checkWriteWithUsage$reportElement(annotationEntry), (Object)expectedType, (Object)actualType));
        }
    }

    private final void checkIfTheContainingClassIsParcelize(KtClassOrObject containingClass, KtAnnotationEntry annotationEntry, CallCheckerContext context) {
        ClassDescriptor containingClassDescriptor;
        if (containingClass != null && (containingClassDescriptor = (ClassDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass)) != null && !ParcelableResolveExtensionKt.isParcelize(containingClassDescriptor)) {
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            KtUserType ktUserType = object instanceof KtUserType ? (KtUserType)object : null;
            KtElement reportElement = ktUserType != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
            context.getTrace().report((Diagnostic)ErrorsAndroid.CLASS_SHOULD_BE_PARCELIZE.on((PsiElement)reportElement, (Object)containingClass));
        }
    }

    private static final KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>> checkWriteWithUsage$reportElement(KtAnnotationEntry $annotationEntry) {
        List list = $annotationEntry.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeArguments(...)");
        KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
        return ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)$annotationEntry;
    }

    private static final FqName checkWriteWithUsage$fqName(KotlinType $this$checkWriteWithUsage_u24fqName) {
        ClassifierDescriptor classifierDescriptor = $this$checkWriteWithUsage_u24fqName.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker$Companion;", "", "<init>", "()V", "TYPE_PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "getTYPE_PARCELER_FQNAME", "()Lorg/jetbrains/kotlin/name/FqName;", "WRITE_WITH_FQNAME", "getWRITE_WITH_FQNAME", "IGNORED_ON_PARCEL_FQNAME", "getIGNORED_ON_PARCEL_FQNAME", "android-extensions-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getTYPE_PARCELER_FQNAME() {
            return TYPE_PARCELER_FQNAME;
        }

        @NotNull
        public final FqName getWRITE_WITH_FQNAME() {
            return WRITE_WITH_FQNAME;
        }

        @NotNull
        public final FqName getIGNORED_ON_PARCEL_FQNAME() {
            return IGNORED_ON_PARCEL_FQNAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

