/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\f2\u001a\u0010\u0018\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J7\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001d\"\u0014\b\u0002\u0010\u001b*\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\t2\u0006\u0010\u001e\u001a\u0002H\u001bH\u0004\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R.\u0010\u0007\u001a\"\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\bj\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\u0003*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "", "cachesDir", "Ljava/io/File;", "(Ljava/io/File;)V", "getCachesDir", "()Ljava/io/File;", "maps", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "Lkotlin/collections/ArrayList;", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "clean", "", "close", "dump", "flush", "memoryCachesOnly", "", "forEachMapSafe", "actionName", "action", "Lkotlin/Function1;", "registerMap", "M", "K", "V", "map", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMap;)Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "Companion", "kotlin-build-common"})
public class BasicMapsOwner {
    private final ArrayList<BasicMap<?, ?>> maps;
    @NotNull
    private final File cachesDir;
    @NotNull
    private static final String CACHE_EXTENSION;
    public static final Companion Companion;

    @NotNull
    protected final File getStorageFile(@NotNull String $this$storageFile) {
        Intrinsics.checkNotNullParameter((Object)$this$storageFile, (String)"$this$storageFile");
        return new File(this.cachesDir, $this$storageFile + "." + CACHE_EXTENSION);
    }

    @NotNull
    protected final <K, V, M extends BasicMap<K, V>> M registerMap(@NotNull M map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.maps.add(map);
        return map;
    }

    public void clean() {
        this.forEachMapSafe("clean", clean.1.INSTANCE);
    }

    public void close() {
        this.forEachMapSafe("close", close.1.INSTANCE);
    }

    public void flush(boolean memoryCachesOnly) {
        this.forEachMapSafe("flush", (Function1)new Function1<BasicMap<?, ?>, Unit>(memoryCachesOnly){
            final /* synthetic */ boolean $memoryCachesOnly;

            public final void invoke(@NotNull BasicMap<?, ?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.flush(this.$memoryCachesOnly);
            }
            {
                this.$memoryCachesOnly = bl;
                super(1);
            }
        });
    }

    private final void forEachMapSafe(String actionName, Function1<? super BasicMap<?, ?>, Unit> action) {
        Object it;
        LinkedHashMap actionExceptions = new LinkedHashMap();
        Object $this$forEach$iv = this.maps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            it = (BasicMap)element$iv;
            boolean bl = false;
            try {
                action.invoke(it);
            }
            catch (Exception e) {
                Map map = actionExceptions;
                String string = ((BasicMap)it).getStorageFile$kotlin_build_common().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.storageFile.name");
                map.put(string, e);
            }
        }
        $this$forEach$iv = actionExceptions;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            boolean bl;
            String desc;
            block8: {
                StringBuilder stringBuilder = new StringBuilder().append("Could not ").append(actionName).append(" incremental caches in ").append(this.cachesDir).append(": ");
                Set set = actionExceptions.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"actionExceptions.keys");
                desc = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString();
                Map $this$all$iv = actionExceptions;
                boolean $i$f$all = false;
                if ($this$all$iv.isEmpty()) {
                    bl = true;
                } else {
                    it = $this$all$iv;
                    boolean bl2 = false;
                    Iterator iterator2 = it.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it2 = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (it2 instanceof IOException) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            boolean allIOExceptions = bl;
            Exception ex = allIOExceptions ? (Exception)new IOException(desc) : new Exception(desc);
            Map $this$forEach$iv2 = actionExceptions;
            boolean $i$f$forEach2 = false;
            Map map = $this$forEach$iv2;
            boolean bl4 = false;
            Iterator iterator3 = map.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$e = element$iv = iterator3.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$_u24__u24$e;
                boolean bl6 = false;
                Exception e = (Exception)entry.getValue();
                ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
            }
            throw (Throwable)ex;
        }
    }

    @NotNull
    public final String dump() {
        return CollectionsKt.joinToString$default((Iterable)this.maps, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final File getCachesDir() {
        return this.cachesDir;
    }

    public BasicMapsOwner(@NotNull File cachesDir) {
        Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
        this.cachesDir = cachesDir;
        boolean bl = false;
        this.maps = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        CACHE_EXTENSION = "tab";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner$Companion;", "", "()V", "CACHE_EXTENSION", "", "getCACHE_EXTENSION", "()Ljava/lang/String;", "kotlin-build-common"})
    public static final class Companion {
        @NotNull
        public final String getCACHE_EXTENSION() {
            return CACHE_EXTENSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

