/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SequentialTaskExecutor;

public class LowMemoryWatcherManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcherManager");
    @NotNull
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final Future<?> myMemoryPoolMXBeansFuture;
    private final AtomicBoolean myProcessing;
    private final Consumer<Boolean> myJanitor;
    private final NotificationListener myLowMemoryListener;

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.myProcessing = new AtomicBoolean();
        this.myJanitor = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager$1", "consume"));
            }
        };
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    boolean afterGc = memoryCollectionThreshold;
                    if (Registry.is("low.memory.watcher.sync", true)) {
                        LowMemoryWatcherManager.this.handleEventImmediately(afterGc);
                        return;
                    }
                    Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.consume(afterGc));
                        }
                    }
                }
            }
        };
        this.myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.myMemoryPoolMXBeansFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        Future<?> future = backendExecutorService.submit(() -> {
            try {
                for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                    long max;
                    long threshold;
                    if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((float)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                    bean.setUsageThreshold(threshold);
                    bean.setCollectionUsageThreshold(threshold);
                }
                ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
            }
            catch (Throwable e) {
                LOG.info("Errors initializing LowMemoryWatcher: ", e);
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        return future;
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    private void handleEventImmediately(boolean afterGc) {
        if (this.myProcessing.compareAndSet(false, true)) {
            try {
                this.myJanitor.consume(afterGc);
            }
            finally {
                this.myProcessing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.myMemoryPoolMXBeansFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

