/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSetInterner;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.AttributeType;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Text;

final class LoadDescriptorsContext
implements AutoCloseable {
    @NotNull
    private final ExecutorService myExecutorService;
    private final Collection<Interner<String>> myInterners;
    private final ThreadLocal<SafeJdomFactory> myThreadLocalXmlFactory;
    private final int myMaxThreads;

    LoadDescriptorsContext(boolean isParallel) {
        int n = this.myMaxThreads = isParallel ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.myMaxThreads > 1) {
            this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("PluginManager Loader", this.myMaxThreads, false);
            this.myInterners = Collections.newSetFromMap(ContainerUtil.newConcurrentMap(this.myMaxThreads));
        } else {
            this.myExecutorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.myInterners = new SmartList<Interner<String>>();
        }
        this.myThreadLocalXmlFactory = ThreadLocal.withInitial(() -> {
            PluginXmlFactory factory2 = new PluginXmlFactory();
            this.myInterners.add(factory2.stringInterner);
            return factory2;
        });
    }

    @NotNull
    ExecutorService getExecutorService() {
        ExecutorService executorService = this.myExecutorService;
        if (executorService == null) {
            LoadDescriptorsContext.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    @Nullable
    public SafeJdomFactory getXmlFactory() {
        return this.myThreadLocalXmlFactory.get();
    }

    @Override
    public void close() {
        if (this.myMaxThreads <= 1) {
            this.myThreadLocalXmlFactory.remove();
            return;
        }
        this.myExecutorService.execute(() -> {
            for (Interner<String> interner : this.myInterners) {
                interner.clear();
            }
        });
        this.myExecutorService.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext", "getExecutorService"));
    }

    private static final class PluginXmlFactory
    extends SafeJdomFactory.BaseSafeJdomFactory {
        private static final List<String> CLASS_NAME_LIST = Arrays.asList("implementation-class", "implementation", "serviceImplementation", "class", "className", "beanClass", "serviceInterface", "interface", "interfaceClass", "instance", "qualifiedName");
        private static final Set<String> CLASS_NAMES = ContainerUtil.newIdentityTroveSet(CLASS_NAME_LIST);
        private final Interner<String> stringInterner = new HashSetInterner<String>(ContainerUtil.concat(CLASS_NAME_LIST, IdeaPluginDescriptorImpl.SERVICE_QUALIFIED_ELEMENT_NAMES)){

            @Override
            @NotNull
            public String intern(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string2 = name.length() < 64 ? super.intern(name) : name;
                if (string2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "intern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "intern";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private PluginXmlFactory() {
        }

        @Override
        @NotNull
        public Interner<String> stringInterner() {
            Interner<String> interner = this.stringInterner;
            if (interner == null) {
                PluginXmlFactory.$$$reportNull$$$0(0);
            }
            return interner;
        }

        @Override
        @NotNull
        public Element element(@NotNull String name, @Nullable Namespace namespace) {
            if (name == null) {
                PluginXmlFactory.$$$reportNull$$$0(1);
            }
            Element element = super.element(this.stringInterner.intern(name), namespace);
            if (element == null) {
                PluginXmlFactory.$$$reportNull$$$0(2);
            }
            return element;
        }

        @Override
        @NotNull
        public Attribute attribute(@NotNull String name, @NotNull String value2, @Nullable AttributeType type2, @Nullable Namespace namespace) {
            String internedName;
            if (name == null) {
                PluginXmlFactory.$$$reportNull$$$0(3);
            }
            if (value2 == null) {
                PluginXmlFactory.$$$reportNull$$$0(4);
            }
            if (CLASS_NAMES.contains(internedName = this.stringInterner.intern(name))) {
                Attribute attribute = super.attribute(internedName, value2, type2, namespace);
                if (attribute == null) {
                    PluginXmlFactory.$$$reportNull$$$0(5);
                }
                return attribute;
            }
            Attribute attribute = super.attribute(internedName, this.stringInterner.intern(value2), type2, namespace);
            if (attribute == null) {
                PluginXmlFactory.$$$reportNull$$$0(6);
            }
            return attribute;
        }

        @Override
        @NotNull
        public Text text(@NotNull String text2, @NotNull Element parentElement) {
            if (text2 == null) {
                PluginXmlFactory.$$$reportNull$$$0(7);
            }
            if (parentElement == null) {
                PluginXmlFactory.$$$reportNull$$$0(8);
            }
            if (CLASS_NAMES.contains(parentElement.getName())) {
                Text text3 = super.text(text2, parentElement);
                if (text3 == null) {
                    PluginXmlFactory.$$$reportNull$$$0(9);
                }
                return text3;
            }
            Text text4 = super.text(this.stringInterner.intern(text2), parentElement);
            if (text4 == null) {
                PluginXmlFactory.$$$reportNull$$$0(10);
            }
            return text4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stringInterner";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "element";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "attribute";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "element";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attribute";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "text";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

