/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0096\u0001J\u0013\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020#H\u0096\u0001J\u0011\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0096\u0001J\u0011\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0096\u0001J\u0011\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0011\u0010.\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0096\u0001J\u0011\u0010/\u001a\u00020\u00192\u0006\u0010,\u001a\u000200H\u0096\u0001J\u0011\u00101\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\u0016H\u0096\u0001J\b\u00103\u001a\u00020\u0010H\u0002J\u0012\u00104\u001a\u00020\u00002\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;)V", "continuation", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getContinuation", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "checkIfJsCode", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getAssociatedObjectKey", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isCoroutineDoResume", "newDeclaration", "func", "backend.js"})
public final class JsGenerationContext
implements IrNamer {
    @Nullable
    private final IrFunction currentFunction;
    @NotNull
    private final JsStaticContext staticContext;

    @NotNull
    public final JsGenerationContext newDeclaration(@Nullable IrFunction func) {
        return new JsGenerationContext(func, this.staticContext);
    }

    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, IrFunction irFunction, int n, Object object) {
        if ((n & 1) != 0) {
            irFunction = null;
        }
        return jsGenerationContext.newDeclaration(irFunction);
    }

    @NotNull
    public final JsExpression getContinuation() {
        JsExpression jsExpression;
        if (this.isCoroutineDoResume()) {
            jsExpression = new JsThisRef();
        } else {
            JsNameRef jsNameRef;
            IrFunction irFunction = this.currentFunction;
            Intrinsics.checkNotNull((Object)irFunction);
            if (AdditionalIrUtilsKt.isSuspend(irFunction)) {
                jsNameRef = new JsNameRef(Namer.INSTANCE.getCONTINUATION());
            } else {
                JsNameRef jsNameRef2 = this.getNameForValueDeclaration((IrValueDeclaration)CollectionsKt.last(this.currentFunction.getValueParameters())).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"getNameForValueDeclarati\u2026ameters.last()).makeRef()");
            }
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private final boolean isCoroutineDoResume() {
        Object object;
        IrFunction irFunction = this.currentFunction;
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        if ((object = (IrSimpleFunction)irFunction) == null || (object = object.getOverriddenSymbols()) == null) {
            return false;
        }
        Object overriddenSymbols2 = object;
        return overriddenSymbols2.contains(this.staticContext.getDoResumeFunctionSymbol());
    }

    public final boolean checkIfJsCode(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol2, (Object)this.staticContext.getBackendContext().getIntrinsics().getJsCode());
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    public JsGenerationContext(@Nullable IrFunction currentFunction, @NotNull JsStaticContext staticContext) {
        Intrinsics.checkNotNullParameter((Object)staticContext, (String)"staticContext");
        this.currentFunction = currentFunction;
        this.staticContext = staticContext;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.staticContext.getAssociatedObjectKey(irClass2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return this.staticContext.getNameForConstructor(constructor);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForField(field);
    }

    @Override
    @Nullable
    public JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        return this.staticContext.getNameForLoop(loop2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return this.staticContext.getNameForProperty(property2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.staticContext.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForValueDeclaration(@NotNull IrValueDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.staticContext.getNameForValueDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getRefForExternalClass(klass);
    }
}

