/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.gradle.internal.CompilerArgumentAware;
import org.jetbrains.kotlin.gradle.internal.CompilerArgumentAwareKt;
import org.jetbrains.kotlin.gradle.internal.CompilerArgumentAwareWithInput;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.internal.SubpluginUtilsKt;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.GradleMessageCollector;
import org.jetbrains.kotlin.gradle.tasks.TasksUtilsKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8AX\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0004\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u00020\u00108\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/KaptWithKotlincTask;", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "Lorg/jetbrains/kotlin/gradle/internal/CompilerArgumentAwareWithInput;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "isAtLeastJava9", "", "()Z", "kotlinTaskPluginClasspaths", "Lorg/gradle/api/file/FileCollection;", "kotlinTaskPluginClasspaths$annotations", "getKotlinTaskPluginClasspaths$kotlin_gradle_plugin", "()Lorg/gradle/api/file/FileCollection;", "pluginClasspath", "getPluginClasspath", "pluginOptions", "Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "getPluginOptions$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "compile", "", "createCompilerArgs", "getJavaRuntimeVersion", "", "setupCompilerArgs", "args", "defaultsOnly", "kotlin-gradle-plugin"})
public class KaptWithKotlincTask
extends KaptTask
implements CompilerArgumentAwareWithInput<K2JVMCompilerArguments> {
    @NotNull
    private final CompilerPluginOptions pluginOptions = new CompilerPluginOptions();

    @Internal
    @NotNull
    public final CompilerPluginOptions getPluginOptions$kotlin_gradle_plugin() {
        return this.pluginOptions;
    }

    public static /* synthetic */ void kotlinTaskPluginClasspaths$annotations() {
    }

    @Classpath
    @InputFiles
    @NotNull
    public final FileCollection getKotlinTaskPluginClasspaths$kotlin_gradle_plugin() {
        return this.getKotlinCompileTask$kotlin_gradle_plugin().getPluginClasspath();
    }

    @Classpath
    @InputFiles
    @NotNull
    public final FileCollection getPluginClasspath() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Configuration configuration = project.getConfigurations().getByName("kotlinCompilerPluginClasspath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.configurations.g\u2026SPATH_CONFIGURATION_NAME)");
        return (FileCollection)configuration;
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createCompilerArgs() {
        return new K2JVMCompilerArguments();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setupCompilerArgs(@NotNull K2JVMCompilerArguments args, boolean defaultsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerArgumentAware.DefaultImpls.setupCompilerArgs$default(this.getKotlinCompileTask$kotlin_gradle_plugin(), (CommonToolArguments)args, false, 2, null);
        args.setPluginClasspaths(FileUtilsKt.toSortedPathsArray((Iterable)this.getPluginClasspath()));
        pluginOptionsWithKapt = SubpluginUtilsKt.withWrappedKaptOptions(this.pluginOptions, (Iterable)this.getKaptClasspath());
        v0 = pluginOptionsWithKapt.getArguments();
        v1 = args.getPluginOptions();
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        var4_4 = CollectionsKt.plus((Collection)v0, (Object[])v1);
        var7_5 = args;
        v2 = $receiver$iv;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv = v2;
        v3 = thisCollection$iv.toArray(new String[0]);
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        var8_7 = v3;
        var7_5.setPluginOptions(var8_7);
        v4 = args;
        if (!this.getProject().hasProperty("kapt.verbose")) ** GOTO lbl-1000
        var4_4 = String.valueOf(this.getProject().property("kapt.verbose"));
        var7_5 = v4;
        var8_8 = Boolean.parseBoolean((String)var4_4);
        v4 = var7_5;
        if (var8_8) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        v4.setVerbose(v5);
    }

    @TaskAction
    public final void compile() {
        this.getLogger().debug("Running kapt annotation processing using the Kotlin compiler");
        TasksUtilsKt.clearOutputDirectories$default((Task)this, null, 1, null);
        K2JVMCompilerArguments args = CompilerArgumentAwareKt.prepareCompilerArguments(this);
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        GradleMessageCollector messageCollector = new GradleMessageCollector(logger);
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        GradleCompilerEnvironment environment = new GradleCompilerEnvironment(this.getCompilerClasspath(), messageCollector, (OutputItemsCollector)outputItemCollector, (CommonCompilerArguments)args);
        if (environment.getToolsJar() == null && !this.isAtLeastJava9()) {
            throw (Throwable)new GradleException("Could not find tools.jar in system classpath, which is required for kapt to work");
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        GradleCompilerRunner compilerRunner = new GradleCompilerRunner(project);
        ExitCode exitCode = compilerRunner.runJvmCompiler(CollectionsKt.emptyList(), (Iterable<? extends File>)this.getJavaSourceRoots(), this.getKotlinCompileTask$kotlin_gradle_plugin().getJavaPackagePrefix(), args, environment);
        TasksUtilsKt.throwGradleExceptionIfError(exitCode);
    }

    private final boolean isAtLeastJava9() {
        return StringUtil.compareVersionNumbers((String)this.getJavaRuntimeVersion(), (String)"9") >= 0;
    }

    private final String getJavaRuntimeVersion() {
        String string;
        String rtVersion = System.getProperty("java.runtime.version");
        if (Character.isDigit(rtVersion.charAt(0))) {
            String string2 = rtVersion;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rtVersion");
        } else {
            String string3 = System.getProperty("java.version");
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"System.getProperty(\"java.version\")");
        }
        return string;
    }

    @Override
    @Internal
    @NotNull
    public List<String> getSerializedCompilerArguments() {
        return CompilerArgumentAwareWithInput.DefaultImpls.getSerializedCompilerArguments(this);
    }

    @Override
    @Internal
    @NotNull
    public List<String> getDefaultSerializedCompilerArguments() {
        return CompilerArgumentAwareWithInput.DefaultImpls.getDefaultSerializedCompilerArguments(this);
    }

    @Override
    @Input
    @NotNull
    public Map<String, String> getFilteredArgumentsMap() {
        return CompilerArgumentAwareWithInput.DefaultImpls.getFilteredArgumentsMap(this);
    }
}

