/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinConfigurationTools;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProvider;
import org.jetbrains.kotlin.gradle.plugin.LegacyAndroidAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "kotlinSourceSetProvider", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;", "kotlinPluginVersion", "", "(Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;Ljava/lang/String;)V", "getTasksProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "apply", "", "project", "kotlin-gradle-plugin"})
public class KotlinAndroidPlugin
implements Plugin<Project> {
    @NotNull
    private final KotlinTasksProvider tasksProvider;
    private final KotlinSourceSetProvider kotlinSourceSetProvider;
    private final String kotlinPluginVersion;

    public void apply(@NotNull Project project) {
        AbstractAndroidProjectHandler abstractAndroidProjectHandler;
        String minimalVersion;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String version = KotlinPluginKt.loadAndroidPluginVersion();
        if (version != null && KotlinPluginKt.compareVersionNumbers(version, minimalVersion = "1.1.0") < 0) {
            throw (Throwable)new IllegalStateException("Kotlin: Unsupported version of com.android.tools.build:gradle plugin: version " + minimalVersion + " or higher should be used with kotlin-android plugin");
        }
        KotlinConfigurationTools kotlinTools = new KotlinConfigurationTools(this.kotlinSourceSetProvider, this.tasksProvider, this.kotlinPluginVersion);
        String legacyVersionThreshold = "2.5.0";
        if (KotlinPluginKt.compareVersionNumbers(version, legacyVersionThreshold) < 0) {
            abstractAndroidProjectHandler = new LegacyAndroidAndroidProjectHandler(kotlinTools);
        } else {
            Class<?> android25ProjectHandlerClass;
            Class<?> clazz = android25ProjectHandlerClass = Class.forName("org.jetbrains.kotlin.gradle.plugin.Android25ProjectHandler");
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"android25ProjectHandlerClass");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(constructorArray, (String)"android25ProjectHandlerClass.constructors");
            Constructor<?>[] $receiver$iv = constructorArray;
            Constructor<?> single$iv = null;
            boolean found$iv = false;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray;
                Constructor<?> element$iv;
                Constructor<?> it;
                Constructor<?> constructor = it = (element$iv = $receiver$iv[i]);
                Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull(constructor.getParameterTypes(), (String)"it.parameterTypes");
                Object[] objectArray2 = new Class[]{kotlinTools.getClass()};
                if (!Arrays.equals(objectArray, objectArray2)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Constructor<?> ctor = single$iv;
            Object t = ctor.newInstance(kotlinTools);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler<*>");
            }
            abstractAndroidProjectHandler = (AbstractAndroidProjectHandler)t;
        }
        AbstractAndroidProjectHandler variantProcessor = abstractAndroidProjectHandler;
        variantProcessor.handleProject(project);
    }

    @NotNull
    public final KotlinTasksProvider getTasksProvider() {
        return this.tasksProvider;
    }

    public KotlinAndroidPlugin(@NotNull KotlinTasksProvider tasksProvider, @NotNull KotlinSourceSetProvider kotlinSourceSetProvider, @NotNull String kotlinPluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)tasksProvider, (String)"tasksProvider");
        Intrinsics.checkParameterIsNotNull((Object)kotlinSourceSetProvider, (String)"kotlinSourceSetProvider");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.tasksProvider = tasksProvider;
        this.kotlinSourceSetProvider = kotlinSourceSetProvider;
        this.kotlinPluginVersion = kotlinPluginVersion;
    }
}

