/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.KotlinNpmResolutionManager;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectModules;
import org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00101\u001a\u00020\u0010H\u0002J\u000e\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010J\u0017\u00104\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b5J\b\u00106\u001a\u00020\u0010H\u0016J/\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00102\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100=\"\u00020\u0010\u00a2\u0006\u0002\u0010>R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0016R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "dir", "Ljava/io/File;", "getDir", "()Ljava/io/File;", "externalsDir", "getExternalsDir", "externalsDirRoot", "getExternalsDirRoot", "main", "", "getMain", "()Ljava/lang/String;", "modules", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "getModules$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "name", "getName", "nodeJs", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "getNodeJs", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "nodeModulesDir", "getNodeModulesDir", "packageJsonFile", "getPackageJsonFile", "packageJsonTask", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "getPackageJsonTask", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "packageJsonTaskName", "getPackageJsonTaskName", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "rootNodeModules", "getRootNodeModules", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "buildNpmProjectName", "require", "request", "resolve", "resolve$kotlin_gradle_plugin", "toString", "useTool", "", "exec", "Lorg/gradle/process/ExecSpec;", "tool", "args", "", "(Lorg/gradle/process/ExecSpec;Ljava/lang/String;[Ljava/lang/String;)V", "Companion", "kotlin-gradle-plugin"})
public class NpmProject {
    @NotNull
    private final NpmProjectModules modules;
    @NotNull
    private final KotlinJsCompilation compilation;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";
    @NotNull
    public static final String NODE_MODULES = "node_modules";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        return this.buildNpmProjectName();
    }

    @NotNull
    public final NodeJsRootExtension getNodeJs() {
        Project project = this.getProject().getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
        return NodeJsRootPlugin.Companion.apply(project);
    }

    @NotNull
    public final File getDir() {
        return FilesKt.resolve((File)this.getNodeJs().getProjectPackagesDir(), (String)this.getName());
    }

    @NotNull
    public final KotlinTarget getTarget() {
        return this.compilation.getTarget();
    }

    @NotNull
    public final Project getProject() {
        return this.getTarget().getProject();
    }

    @NotNull
    public final File getNodeModulesDir() {
        return FilesKt.resolve((File)this.getDir(), (String)NODE_MODULES);
    }

    @NotNull
    public final File getPackageJsonFile() {
        return FilesKt.resolve((File)this.getDir(), (String)PACKAGE_JSON);
    }

    @NotNull
    public final String getPackageJsonTaskName() {
        return KotlinCompilationsKt.disambiguateName(this.compilation, "packageJson");
    }

    @NotNull
    public final KotlinPackageJsonTask getPackageJsonTask() {
        Task task2 = this.getProject().getTasks().getByName(this.getPackageJsonTaskName());
        if (task2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask");
        }
        return (KotlinPackageJsonTask)task2;
    }

    @NotNull
    public final String getMain() {
        return "kotlin/" + this.getName() + ".js";
    }

    @NotNull
    public final File getExternalsDirRoot() {
        File file = this.getProject().getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"externals"), (String)this.getName());
    }

    @NotNull
    public final File getExternalsDir() {
        return FilesKt.resolve((File)this.getExternalsDirRoot(), (String)"src");
    }

    @NotNull
    public final NpmProjectModules getModules$kotlin_gradle_plugin() {
        return this.modules;
    }

    private final NpmProjectModules getRootNodeModules() {
        return new NpmProjectModules(this.getNodeJs().getRootPackageDir(), null, null, null, null, 30, null);
    }

    public final void useTool(@NotNull ExecSpec exec2, @NotNull String tool, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)exec2, (String)"exec");
        Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        exec2.setWorkingDir(this.getDir());
        exec2.setExecutable(this.getNodeJs().getEnvironment$kotlin_gradle_plugin().getNodeExecutable());
        exec2.setArgs(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.require(tool)), (Object[])args));
    }

    @NotNull
    public final String require(@NotNull String request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        KotlinNpmResolutionManager.requireAlreadyInstalled$kotlin_gradle_plugin$default(this.getNodeJs().getNpmResolutionManager$kotlin_gradle_plugin(), this.getProject(), null, 2, null);
        return this.modules.require(request);
    }

    @Nullable
    public final File resolve$kotlin_gradle_plugin(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return NpmProjectModules.resolve$kotlin_gradle_plugin$default(this.modules, name, null, 2, null);
    }

    private final String buildNpmProjectName() {
        Project project = this.getTarget().getProject();
        StringBuilder name = new StringBuilder();
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        name.append(project2.getName());
        if (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ^ true) {
            name.append("-");
            name.append(project.getName());
        }
        CharSequence charSequence = this.getTarget().getName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = this.getTarget().getName();
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string, (Object)"js") ^ true) {
                name.append("-").append(this.getTarget().getName());
            }
        }
        if (Intrinsics.areEqual((Object)this.compilation.getName(), (Object)"main") ^ true) {
            name.append("-").append(this.compilation.getName());
        }
        String string = name.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return "NpmProject(" + this.getName() + ')';
    }

    @NotNull
    public final KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    public NpmProject(@NotNull KotlinJsCompilation compilation) {
        Intrinsics.checkParameterIsNotNull((Object)compilation, (String)"compilation");
        this.compilation = compilation;
        this.modules = new NpmProjectModules(this, this.getDir(), this.getNodeModulesDir()){
            final /* synthetic */ NpmProject this$0;

            @Nullable
            public NpmProjectModules getParent() {
                return NpmProject.access$getRootNodeModules$p(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, null, null, null, 28, null);
            }
        };
    }

    public static final /* synthetic */ NpmProjectModules access$getRootNodeModules$p(NpmProject $this) {
        return $this.getRootNodeModules();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$Companion;", "", "()V", "NODE_MODULES", "", "PACKAGE_JSON", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

