/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.ProjectFilesForCompilation;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaTarget;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompileTaskData;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 82\u00020\u0001:\u00018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0014J2\u0010)\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020&JJ\u0010/\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0006032\b\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u0002052\u0006\u0010%\u001a\u00020&J$\u00106\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010-\u001a\u0002072\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0014\u0010\u0018\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u0014\u0010\u001c\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;)V", "buildDirProvider", "Ljava/io/File;", "getBuildDirProvider$kotlin_gradle_plugin", "()Ljava/io/File;", "incrementalModuleInfoProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getIncrementalModuleInfoProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "loggerProvider", "Lorg/gradle/api/logging/Logger;", "getLoggerProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "pathProvider", "", "getPathProvider$kotlin_gradle_plugin", "()Ljava/lang/String;", "projectDirProvider", "getProjectDirProvider$kotlin_gradle_plugin", "projectNameProvider", "getProjectNameProvider$kotlin_gradle_plugin", "projectRootDirProvider", "getProjectRootDirProvider$kotlin_gradle_plugin", "sessionDirProvider", "getSessionDirProvider$kotlin_gradle_plugin", "getTaskProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "runCompilerAsync", "", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "runJsCompilerAsync", "kotlinSources", "", "kotlinCommonSources", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompilerAsync", "sourcesToCompile", "commonSources", "javaSourceRoots", "", "javaPackagePrefix", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "runMetadataCompilerAsync", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public class GradleCompilerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCompileTaskProvider taskProvider;
    @NotNull
    private final String pathProvider;
    @NotNull
    private final Logger loggerProvider;
    @NotNull
    private final File buildDirProvider;
    @NotNull
    private final File projectDirProvider;
    @NotNull
    private final File projectRootDirProvider;
    @NotNull
    private final File sessionDirProvider;
    @NotNull
    private final String projectNameProvider;
    @NotNull
    private final Provider<? extends IncrementalModuleInfoProvider> incrementalModuleInfoProvider;
    @NotNull
    private static volatile WeakReference<Gradle> cachedGradle = new WeakReference<Object>(null);
    @Nullable
    private static volatile IncrementalModuleInfo cachedModulesInfo;
    @Nullable
    private static volatile File clientIsAliveFlagFile;
    @Nullable
    private static volatile File sessionFlagFile;

    public GradleCompilerRunner(@NotNull GradleCompileTaskProvider taskProvider) {
        Intrinsics.checkParameterIsNotNull((Object)taskProvider, (String)"taskProvider");
        this.taskProvider = taskProvider;
        this.pathProvider = this.taskProvider.getPath();
        this.loggerProvider = this.taskProvider.getLogger();
        this.buildDirProvider = this.taskProvider.getBuildDir();
        this.projectDirProvider = this.taskProvider.getProjectDir();
        this.projectRootDirProvider = this.taskProvider.getRootDir();
        this.sessionDirProvider = this.taskProvider.getSessionsDir();
        this.projectNameProvider = this.taskProvider.getProjectName();
        this.incrementalModuleInfoProvider = this.taskProvider.getBuildModulesInfo();
    }

    @NotNull
    protected final GradleCompileTaskProvider getTaskProvider() {
        return this.taskProvider;
    }

    @NotNull
    public final String getPathProvider$kotlin_gradle_plugin() {
        return this.pathProvider;
    }

    @NotNull
    public final Logger getLoggerProvider$kotlin_gradle_plugin() {
        return this.loggerProvider;
    }

    @NotNull
    public final File getBuildDirProvider$kotlin_gradle_plugin() {
        return this.buildDirProvider;
    }

    @NotNull
    public final File getProjectDirProvider$kotlin_gradle_plugin() {
        return this.projectDirProvider;
    }

    @NotNull
    public final File getProjectRootDirProvider$kotlin_gradle_plugin() {
        return this.projectRootDirProvider;
    }

    @NotNull
    public final File getSessionDirProvider$kotlin_gradle_plugin() {
        return this.sessionDirProvider;
    }

    @NotNull
    public final String getProjectNameProvider$kotlin_gradle_plugin() {
        return this.projectNameProvider;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getIncrementalModuleInfoProvider$kotlin_gradle_plugin() {
        return this.incrementalModuleInfoProvider;
    }

    /*
     * WARNING - void declaration
     */
    public final void runJvmCompilerAsync(@NotNull List<? extends File> sourcesToCompile, @NotNull List<? extends File> commonSources, @NotNull Iterable<? extends File> javaSourceRoots, @Nullable String javaPackagePrefix2, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Iterable<? extends File> $this$toTypedArray$iv;
        File it;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkParameterIsNotNull(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(commonSources, (String)"commonSources");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Object object2 = args;
        Iterable iterable = sourcesToCompile;
        Collection collection = object2.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var10_14 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it2;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it2.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = commonSources;
        k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        Iterable<Object> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setCommonSources(stringArray);
        $this$toTypedArray$iv = javaSourceRoots;
        k2JVMCompilerArguments = args;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setJavaSourceRoots(stringArray2);
        args.setJavaPackagePrefix(javaPackagePrefix2);
        this.runCompilerAsync("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler", (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    public final void runJsCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Object object2 = args;
        Iterable iterable = kotlinSources;
        Collection collection = object2.getFreeArgs();
        K2JSCompilerArguments k2JSCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var8_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JSCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = kotlinCommonSources;
        k2JSCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JSCompilerArguments.setCommonSources(stringArray);
        this.runCompilerAsync("org.jetbrains.kotlin.cli.js.K2JSCompiler", (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    public final void runMetadataCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        K2MetadataCompilerArguments k2MetadataCompilerArguments = args;
        Iterable iterable = kotlinSources;
        Collection collection2 = k2MetadataCompilerArguments.getFreeArgs();
        K2MetadataCompilerArguments k2MetadataCompilerArguments2 = k2MetadataCompilerArguments;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2MetadataCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        this.runCompilerAsync("org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler", (CommonCompilerArguments)args, environment);
    }

    private final void runCompilerAsync(String compilerClassName, CommonCompilerArguments compilerArgs, GradleCompilerEnvironment environment) {
        IncrementalModuleInfo incrementalModuleInfo;
        if (compilerArgs.getVersion()) {
            this.loggerProvider.lifecycle("Kotlin version " + ReportUtilsKt.loadCompilerVersion(environment.getCompilerClasspath()) + " (JRE " + System.getProperty("java.runtime.version") + ')');
            compilerArgs.setVersion(false);
        }
        List list2 = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)((CommonToolArguments)compilerArgs));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"convertArgumentsToStringList(compilerArgs)");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(compilerArgs, argsArray){
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ String[] $argsArray;
            {
                this.$compilerArgs = $compilerArgs;
                this.$argsArray = $argsArray;
                super(1);
            }

            public final void invoke(@NotNull IStatisticsValuesConsumer it) {
                IStatisticsValuesConsumer iStatisticsValuesConsumer;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$compilerArgs instanceof K2JVMCompilerArguments && (iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance()) != null) {
                    IStatisticsValuesConsumer iStatisticsValuesConsumer2 = iStatisticsValuesConsumer;
                    Object[] objectArray = this.$argsArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    IStatisticsValuesConsumer $this$invoke_u24lambda_u2d0 = iStatisticsValuesConsumer2;
                    boolean bl3 = false;
                    K2JVMCompilerArguments args = new K2JVMCompilerArguments();
                    ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, BooleanMetrics.JVM_COMPILER_IR_MODE, args.getUseIR(), null, 4, null);
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.JVM_DEFAULTS, args.getJvmDefault(), null, 4, null);
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.USE_OLD_BACKEND, String.valueOf(args.getUseOldBackend()), null, 4, null);
                }
            }
        }));
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = environment.getIncrementalCompilationEnvironment();
        thisCollection$iv = incrementalCompilationEnvironment;
        if (thisCollection$iv == null) {
            incrementalModuleInfo = null;
        } else {
            Object object = thisCollection$iv;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            incrementalModuleInfo = ((IncrementalModuleInfoProvider)this.getIncrementalModuleInfoProvider$kotlin_gradle_plugin().get()).getInfo();
        }
        IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
        GradleKotlinCompilerWorkArguments workArgs = new GradleKotlinCompilerWorkArguments(new ProjectFilesForCompilation(this.loggerProvider, this.projectDirProvider, this.buildDirProvider, this.projectNameProvider, this.projectRootDirProvider, this.sessionDirProvider), environment.getCompilerFullClasspath(), compilerClassName, argsArray, compilerArgs.getVerbose(), incrementalCompilationEnvironment, modulesInfo, CollectionsKt.toList((Iterable)((Iterable)environment.getOutputFiles())), this.pathProvider, environment.getReportingSettings(), environment.getKotlinScriptExtensions(), compilerArgs.getAllWarningsAsErrors());
        TaskLoggers.INSTANCE.put(this.pathProvider, this.loggerProvider);
        this.runCompilerAsync(workArgs);
    }

    protected void runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs) {
        Intrinsics.checkParameterIsNotNull((Object)workArgs, (String)"workArgs");
        GradleKotlinCompilerWork kotlinCompilerRunnable = new GradleKotlinCompilerWork(workArgs);
        kotlinCompilerRunnable.run();
    }

    public static final /* synthetic */ File access$getClientIsAliveFlagFile$cp() {
        return clientIsAliveFlagFile;
    }

    public static final /* synthetic */ void access$setClientIsAliveFlagFile$cp(File file) {
        clientIsAliveFlagFile = file;
    }

    public static final /* synthetic */ File access$getSessionFlagFile$cp() {
        return sessionFlagFile;
    }

    public static final /* synthetic */ void access$setSessionFlagFile$cp(File file) {
        sessionFlagFile = file;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J=\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J%\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\u0011\u0010*\u001a\u00020\u001f*\u00020\u001fH\u0000\u00a2\u0006\u0002\b+R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "cachedGradle", "Ljava/lang/ref/WeakReference;", "Lorg/gradle/api/invocation/Gradle;", "cachedModulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "clientIsAliveFlagFile", "Ljava/io/File;", "sessionFlagFile", "buildModulesInfo", "gradle", "buildModulesInfo$kotlin_gradle_plugin", "clearBuildModulesInfo", "", "clearBuildModulesInfo$kotlin_gradle_plugin", "getDaemonConnectionImpl", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "sessionIsAliveFlagFile", "compilerFullClasspath", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "isDebugEnabled", "", "getDaemonConnectionImpl$kotlin_gradle_plugin", "getOrCreateClientFlagFile", "log", "Lorg/gradle/api/logging/Logger;", "projectName", "", "getOrCreateClientFlagFile$kotlin_gradle_plugin", "getOrCreateSessionFlagFile", "sessionsDir", "projectRootDir", "getOrCreateSessionFlagFile$kotlin_gradle_plugin", "jarForSourceSet", "project", "Lorg/gradle/api/Project;", "sourceSetName", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "normalizeForFlagFile$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final synchronized CompileServiceSession getDaemonConnectionImpl$kotlin_gradle_plugin(@NotNull File clientIsAliveFlagFile, @NotNull File sessionIsAliveFlagFile, @NotNull List<? extends File> compilerFullClasspath, @NotNull MessageCollector messageCollector, boolean isDebugEnabled) {
            Intrinsics.checkParameterIsNotNull((Object)clientIsAliveFlagFile, (String)"clientIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull((Object)sessionIsAliveFlagFile, (String)"sessionIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull(compilerFullClasspath, (String)"compilerFullClasspath");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)compilerFullClasspath);
            boolean bl = false;
            ArrayList additionalJvmParams = new ArrayList();
            Collection $this$toTypedArray$iv = additionalJvmParams;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (MessageCollector)messageCollector, (boolean)isDebugEnabled, null, (String[])stringArray, (int)32, null);
        }

        @NotNull
        public final synchronized IncrementalModuleInfo buildModulesInfo$kotlin_gradle_plugin(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            if (cachedGradle.get() == gradle && cachedModulesInfo != null) {
                IncrementalModuleInfo incrementalModuleInfo = cachedModulesInfo;
                if (incrementalModuleInfo == null) {
                    Intrinsics.throwNpe();
                }
                return incrementalModuleInfo;
            }
            HashMap dirToModule = new HashMap();
            HashMap nameToModules = new HashMap();
            HashMap jarToClassListFile = new HashMap();
            HashMap jarToModule = new HashMap();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                if (KotlinProjectExtensionKt.getKotlinExtensionOrNull(project) == null) continue;
                boolean isMultiplatformProject = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project) != null;
                Iterable<KotlinCompileTaskData> $this$forEach$iv = KotlinCompileTaskData.Companion.getTaskDataContainer(project);
                boolean $i$f$forEach = false;
                Iterator<KotlinCompileTaskData> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    File $this$getOrPut$iv;
                    boolean bl;
                    Map map;
                    Object it;
                    KotlinCompileTaskData element$iv;
                    KotlinCompileTaskData taskData = element$iv = iterator.next();
                    boolean bl2 = false;
                    KotlinCompilation<?> compilation2 = taskData.getCompilation();
                    KotlinTarget target2 = taskData.getCompilation().getTarget();
                    Object object2 = project.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.path");
                    String string = object2;
                    String string2 = KotlinCompilationsKt.getOwnModuleName(compilation2);
                    object2 = project.getBuildDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.buildDir");
                    IncrementalModuleEntry module = new IncrementalModuleEntry(string, string2, (File)object2, taskData.getBuildHistoryFile());
                    object2 = dirToModule;
                    Object object3 = taskData.getDestinationDir().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"taskData.destinationDir.get()");
                    boolean bl3 = false;
                    object2.put(object3, module);
                    object2 = taskData.getJavaOutputDir();
                    if (object2 != null) {
                        object3 = object2;
                        bl3 = false;
                        boolean bl4 = false;
                        it = object3;
                        boolean bl5 = false;
                        map = dirToModule;
                        bl = false;
                        map.put(it, module);
                    }
                    object2 = nameToModules;
                    String key$iv = module.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        HashSet answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((HashSet)object).add(module);
                    if (compilation2.getPlatformType() == KotlinPlatformType.js && ($this$getOrPut$iv = Companion.jarForSourceSet(project, compilation2.getName())) != null) {
                        object3 = $this$getOrPut$iv;
                        bl3 = false;
                        boolean bl7 = false;
                        it = object3;
                        boolean bl8 = false;
                        map = jarToModule;
                        bl = false;
                        map.put(it, module);
                    }
                    if (!KotlinCompilationsKt.isMain(compilation2)) continue;
                    if (isMultiplatformProject) {
                        try {
                            object3 = project.getTasks().getByName(target2.getArtifactsTaskName());
                            if (object3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.bundling.AbstractArchiveTask");
                            }
                            AbstractArchiveTask archiveTask = (AbstractArchiveTask)object3;
                            object3 = jarToModule;
                            File file = CompatibiltiyKt.getArchivePathCompatible(archiveTask).getCanonicalFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archiveTask.archivePathCompatible.canonicalFile");
                            boolean bl9 = false;
                            object3.put(file, module);
                        }
                        catch (UnknownTaskException archiveTask) {}
                        continue;
                    }
                    if (!(target2 instanceof KotlinWithJavaTarget)) continue;
                    object3 = project.getTasks().getByName(target2.getArtifactsTaskName());
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
                    }
                    Jar jar = (Jar)object3;
                    object3 = jarToClassListFile;
                    File file = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jar.archivePathCompatible.canonicalFile");
                    Object object4 = ((KotlinWithJavaTarget)target2).getDefaultArtifactClassesListFile$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"target.defaultArtifactClassesListFile.get()");
                    boolean bl10 = false;
                    object3.put(file, object4);
                }
            }
            Object object = gradle.getRootProject().getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gradle.rootProject.projectDir");
            Object object5 = object;
            object = gradle.getRootProject().getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gradle.rootProject.buildDir");
            object = new IncrementalModuleInfo((File)object5, (File)object, (Map)dirToModule, (Map)nameToModules, (Map)jarToClassListFile, (Map)jarToModule);
            boolean bl = false;
            boolean bl11 = false;
            Object it = object;
            boolean bl12 = false;
            cachedGradle = new WeakReference<Gradle>(gradle);
            cachedModulesInfo = (IncrementalModuleInfo)it;
            return object;
        }

        private final File jarForSourceSet(Project project, String sourceSetName) {
            Jar jarTask;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                return null;
            }
            JavaPluginConvention javaPluginConvention2 = javaPluginConvention;
            JavaPluginConvention javaConvention = javaPluginConvention2;
            Object object = (SourceSet)javaConvention.getSourceSets().findByName(sourceSetName);
            if (object == null) {
                return null;
            }
            JavaPluginConvention sourceSet = javaPluginConvention = object;
            object = project.getTasks().findByName(sourceSet.getJarTaskName());
            Jar jar = jarTask = object instanceof Jar ? (Jar)object : null;
            Provider provider = object = jar == null ? null : jar.getArchiveFile();
            return object == null ? null : ((jar = (RegularFile)object.get()) == null ? null : jar.getAsFile());
        }

        public final synchronized void clearBuildModulesInfo$kotlin_gradle_plugin() {
            cachedGradle = new WeakReference<Object>(null);
            cachedModulesInfo = null;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateClientFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            if (GradleCompilerRunner.access$getClientIsAliveFlagFile$cp() == null) ** GOTO lbl-1000
            var3_3 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (var3_3 == null) {
                Intrinsics.throwNpe();
            }
            if (!var3_3.exists()) lbl-1000:
            // 2 sources

            {
                GradleCompilerRunner.access$setClientIsAliveFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-in-" + projectName + '-', ".alive", null, false, 12, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var7_6 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$1 = false;
                    var6_10 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (var6_10 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_12 = Intrinsics.stringPlus((String)"Created client-is-alive flag file: ", (Object)var6_10.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var7_6, var8_12);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var7_7 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$2 = false;
                    var6_11 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (var6_11 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_13 = Intrinsics.stringPlus((String)"Existing client-is-alive flag file: ", (Object)var6_11.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var7_7, var8_13);
                }
            }
            var3_3 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (var3_3 == null) {
                Intrinsics.throwNpe();
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String normalizeForFlagFile$kotlin_gradle_plugin(@NotNull String $this$normalizeForFlagFile) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$this$normalizeForFlagFile, (String)"<this>");
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)"-_");
            String $this$filter$iv = $this$normalizeForFlagFile;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (validChars.contains(Character.valueOf(it))) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateSessionFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull File sessionsDir, @NotNull File projectRootDir) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)sessionsDir, (String)"sessionsDir");
            Intrinsics.checkParameterIsNotNull((Object)projectRootDir, (String)"projectRootDir");
            if (GradleCompilerRunner.access$getSessionFlagFile$cp() == null) ** GOTO lbl-1000
            var4_4 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (var4_4 == null) {
                Intrinsics.throwNpe();
            }
            if (!var4_4.exists()) lbl-1000:
            // 2 sources

            {
                var5_5 = sessionsDir;
                var6_7 = false;
                var7_9 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d8 = var5_5;
                $i$a$-apply-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$sessionFilesDir$1 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d8.mkdirs();
                sessionFilesDir = var5_5;
                GradleCompilerRunner.access$setSessionFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-", ".salive", sessionFilesDir, false, 8, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var10_13 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$1 = false;
                    var8_11 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (var8_11 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_15 = Intrinsics.stringPlus((String)"Created session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(var8_11, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var10_13, var11_15);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var10_14 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$2 = false;
                    var7_10 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (var7_10 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_16 = Intrinsics.stringPlus((String)"Existing session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(var7_10, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var10_14, var11_16);
                }
            }
            var4_4 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (var4_4 == null) {
                Intrinsics.throwNpe();
            }
            return var4_4;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return new File(new File(project.getRootProject().getBuildDir(), "kotlin"), "sessions");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

