/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal;

public final class JavaVersion {
    private static final int majorJavaVersion = JavaVersion.determineMajorJavaVersion();

    private static int determineMajorJavaVersion() {
        String javaVersion2 = System.getProperty("java.version");
        return JavaVersion.getMajorJavaVersion(javaVersion2);
    }

    static int getMajorJavaVersion(String javaVersion2) {
        int version2 = JavaVersion.parseDotted(javaVersion2);
        if (version2 == -1) {
            version2 = JavaVersion.extractBeginningInt(javaVersion2);
        }
        if (version2 == -1) {
            return 6;
        }
        return version2;
    }

    private static int parseDotted(String javaVersion2) {
        try {
            String[] parts = javaVersion2.split("[._]");
            int firstVer = Integer.parseInt(parts[0]);
            if (firstVer == 1 && parts.length > 1) {
                return Integer.parseInt(parts[1]);
            }
            return firstVer;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static int extractBeginningInt(String javaVersion2) {
        try {
            char c;
            StringBuilder num = new StringBuilder();
            for (int i = 0; i < javaVersion2.length() && Character.isDigit(c = javaVersion2.charAt(i)); ++i) {
                num.append(c);
            }
            return Integer.parseInt(num.toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int getMajorJavaVersion() {
        return majorJavaVersion;
    }

    public static boolean isJava9OrLater() {
        return majorJavaVersion >= 9;
    }

    private JavaVersion() {
    }
}

