/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.coord.CoordProviderBase;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J0\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/coord/FixedRatioCoordProvider;", "Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "ratio", "", "xLim", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "yLim", "flipped", "", "(DLjetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Z)V", "adjustGeomSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "hDomain", "vDomain", "geomSize", "with", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "Companion", "plot-builder-portable"})
public class FixedRatioCoordProvider
extends CoordProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ratio;

    public FixedRatioCoordProvider(double ratio, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, boolean flipped) {
        super(xLim, yLim, flipped);
        this.ratio = ratio;
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim, boolean flipped) {
        return new FixedRatioCoordProvider(this.ratio, xLim, yLim, flipped);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull ClosedRange<Double> hDomain, @NotNull ClosedRange<Double> vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter(hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter(vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double domainRatio = SeriesUtil.INSTANCE.span(hDomain) / SeriesUtil.INSTANCE.span(vDomain);
        double effectiveDomainRatio = domainRatio / this.ratio;
        return Companion.reshapeGeom(geomSize, effectiveDomainRatio);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/builder/coord/FixedRatioCoordProvider$Companion;", "", "()V", "reshapeGeom", "Ljetbrains/datalore/base/geometry/DoubleVector;", "geomSize", "targetWidthToHeightRatio", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector reshapeGeom(@NotNull DoubleVector geomSize, double targetWidthToHeightRatio) {
            DoubleVector doubleVector;
            Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
            double geomRatio = geomSize.getX() / geomSize.getY();
            if (targetWidthToHeightRatio > geomRatio) {
                double h = geomSize.getX() / targetWidthToHeightRatio;
                doubleVector = new DoubleVector(geomSize.getX(), h);
            } else {
                double w = geomSize.getY() * targetWidthToHeightRatio;
                double hDelta = geomSize.getX() - w;
                doubleVector = new DoubleVector(w, geomSize.getY());
            }
            DoubleVector newSize = doubleVector;
            return newSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

