/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogServiceResponseType;

public abstract class JFrogService<TResult> {
    protected final Log log;
    protected TResult result;
    protected int statusCode;
    protected JFrogServiceResponseType responseType;
    private Header[] headers;
    private ObjectMapper mapper;

    protected JFrogService(Log log) {
        this.log = log;
        this.responseType = JFrogServiceResponseType.OBJECT;
    }

    protected JFrogService(Log log, JFrogServiceResponseType responseType) {
        this.log = log;
        this.responseType = responseType;
    }

    protected static void throwException(HttpEntity entity, int statusCode) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("JFrog service failed. Received " + statusCode);
        }
        InputStream stream = entity.getContent();
        Throwable throwable = null;
        try {
            try {
                String ResponseMessage = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
                throw new IOException("JFrog service failed. Received " + statusCode + ": " + ResponseMessage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (stream != null) {
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    stream.close();
                }
            }
            throw throwable3;
        }
    }

    protected ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = BuildInfoExtractorUtils.createMapper();
            this.mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        }
        return this.mapper;
    }

    public TResult getResult() {
        return this.result;
    }

    public void setResult(TResult result) {
        this.result = result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public abstract HttpRequestBase createRequest() throws IOException;

    protected abstract void setResponse(InputStream var1) throws IOException;

    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        JFrogService.throwException(entity, this.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TResult execute(JFrogHttpClient client) throws IOException {
        this.ensureRequirements(client);
        Throwable throwable = null;
        try (CloseableHttpResponse response = client.sendRequest(this.createRequest());){
            TResult TResult;
            block22: {
                if (response == null) {
                    TResult TResult2 = null;
                    return TResult2;
                }
                HttpEntity entity = response.getEntity();
                try {
                    this.setStatusCode(response.getStatusLine().getStatusCode());
                    this.setHeaders(response.getAllHeaders());
                    if (this.getStatusCode() >= 400) {
                        this.handleUnsuccessfulResponse(entity);
                    } else {
                        this.processResponse(entity);
                    }
                    TResult = this.getResult();
                    if (entity == null) break block22;
                }
                catch (Throwable throwable2) {
                    try {
                        if (entity != null) {
                            EntityUtils.consumeQuietly((HttpEntity)entity);
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
            return TResult;
        }
    }

    private void processResponse(HttpEntity entity) throws IOException {
        if (this.responseType == JFrogServiceResponseType.EMPTY) {
            return;
        }
        if (entity == null) {
            this.handleEmptyEntity();
            return;
        }
        try (InputStream stream = entity.getContent();){
            this.setResponse(stream);
        }
    }

    protected void handleEmptyEntity() throws IOException {
    }

    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }
}

