/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.retention;

import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class Utils {
    private static BuildRetention getBuildRetention(ArtifactoryClientConfiguration clientConf) {
        String[] notToDelete;
        int minimumDays;
        String buildRetentionMinimumDays;
        BuildRetention buildRetention = new BuildRetention(clientConf.info.isDeleteBuildArtifacts());
        if (clientConf.info.getBuildRetentionCount() != null) {
            buildRetention.setCount(clientConf.info.getBuildRetentionCount());
        }
        if (StringUtils.isNotBlank((CharSequence)(buildRetentionMinimumDays = clientConf.info.getBuildRetentionMinimumDate())) && (minimumDays = Integer.parseInt(buildRetentionMinimumDays)) > -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -minimumDays);
            buildRetention.setMinimumBuildDate(calendar.getTime());
        }
        for (String notToDel : notToDelete = clientConf.info.getBuildNumbersNotToDelete()) {
            buildRetention.addBuildNotToBeDiscarded(notToDel);
        }
        return buildRetention;
    }

    private static void addRetentionIfNeeded(BuildInfo buildInfo, BuildRetention retention, ArtifactoryVersion version) {
        if (!version.isAtLeast((Version)JFrogHttpClient.STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION)) {
            buildInfo.setBuildRetention(retention);
        }
    }

    private static void sendRetentionIfNeeded(ArtifactoryManager artifactoryManager, BuildRetention retention, String buildName, String project, ArtifactoryVersion version, boolean async) throws IOException {
        if (version.isAtLeast((Version)JFrogHttpClient.STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION)) {
            artifactoryManager.sendBuildRetention(retention, buildName, project, async);
        }
    }

    public static void sendBuildAndBuildRetention(ArtifactoryManager artifactoryManager, BuildInfo buildInfo, ArtifactoryClientConfiguration clientConf, String platformUrl) throws IOException {
        BuildRetention retention = Utils.getBuildRetention(clientConf);
        Utils.sendBuildAndBuildRetention(artifactoryManager, buildInfo, retention, clientConf.info.isAsyncBuildRetention(), platformUrl);
    }

    public static void sendBuildAndBuildRetention(ArtifactoryManager artifactoryManager, BuildInfo buildInfo, ArtifactoryClientConfiguration clientConfl) throws IOException {
        Utils.sendBuildAndBuildRetention(artifactoryManager, buildInfo, clientConfl, null);
    }

    public static void sendBuildAndBuildRetention(ArtifactoryManager artifactoryManager, BuildInfo buildInfo, BuildRetention retention, boolean asyncBuildRetention, String platformUrl) throws IOException {
        if (retention == null || retention.isEmpty()) {
            artifactoryManager.publishBuildInfo(buildInfo, platformUrl);
            return;
        }
        ArtifactoryVersion version = artifactoryManager.getVersion();
        Utils.addRetentionIfNeeded(buildInfo, retention, version);
        artifactoryManager.publishBuildInfo(buildInfo, platformUrl);
        Utils.sendRetentionIfNeeded(artifactoryManager, retention, buildInfo.getName(), buildInfo.getProject(), version, asyncBuildRetention);
    }

    public static void sendBuildAndBuildRetention(ArtifactoryManager artifactoryManager, BuildInfo buildInfo, BuildRetention retention, boolean asyncBuildRetention) throws IOException {
        Utils.sendBuildAndBuildRetention(artifactoryManager, buildInfo, retention, asyncBuildRetention, null);
    }
}

