/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.process.MacProcessManager;
import org.jodconverter.process.ProcessManager;
import org.jodconverter.process.PureJavaProcessManager;
import org.jodconverter.process.UnixProcessManager;
import org.jodconverter.process.WindowsProcessManager;

public final class LocalOfficeUtils {
    private static final String EXECUTABLE_DEFAULT = "program/soffice.bin";
    private static final String EXECUTABLE_MAC = "program/soffice";
    private static final String EXECUTABLE_MAC_41 = "MacOS/soffice";
    private static final String EXECUTABLE_WINDOWS = "program/soffice.exe";

    public static ProcessManager findBestProcessManager() {
        if (SystemUtils.IS_OS_MAC) {
            return MacProcessManager.getDefault();
        }
        if (SystemUtils.IS_OS_UNIX) {
            return UnixProcessManager.getDefault();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsProcessManager windowsProcessManager = WindowsProcessManager.getDefault();
            return windowsProcessManager.isUsable() ? windowsProcessManager : PureJavaProcessManager.getDefault();
        }
        return PureJavaProcessManager.getDefault();
    }

    public static OfficeUrl[] buildOfficeUrls(int[] portNumbers, String[] pipeNames) {
        if (portNumbers == null && pipeNames == null) {
            return new OfficeUrl[]{new OfficeUrl(2002)};
        }
        ArrayList<OfficeUrl> officeUrls = new ArrayList<OfficeUrl>(ArrayUtils.getLength((Object)portNumbers) + ArrayUtils.getLength((Object)pipeNames));
        if (pipeNames != null) {
            for (String pipeName : pipeNames) {
                officeUrls.add(new OfficeUrl(pipeName));
            }
        }
        if (portNumbers != null) {
            for (int portNumber : portNumbers) {
                officeUrls.add(new OfficeUrl(portNumber));
            }
        }
        return officeUrls.toArray(new OfficeUrl[officeUrls.size()]);
    }

    public static File getDefaultOfficeHome() {
        return DefaultOfficeHomeHolder.INSTANCE;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (SystemUtils.IS_OS_MAC) {
            File executableFile = new File(officeHome, EXECUTABLE_MAC_41);
            if (!executableFile.isFile()) {
                executableFile = new File(officeHome, EXECUTABLE_MAC);
            }
            return executableFile;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(officeHome, EXECUTABLE_WINDOWS);
        }
        return new File(officeHome, EXECUTABLE_DEFAULT);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue prop = new PropertyValue();
        prop.Name = name;
        prop.Value = value;
        return prop;
    }

    public static void stopQuietly(OfficeManager manager) {
        try {
            if (manager != null) {
                manager.stop();
            }
        }
        catch (OfficeException officeException) {
            // empty catch block
        }
    }

    public static PropertyValue[] toUnoProperties(Map<String, Object> properties) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            PropertyValue[] value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = LocalOfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues.add(LocalOfficeUtils.property(entry.getKey(), value));
        }
        return propertyValues.toArray(new PropertyValue[propertyValues.size()]);
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static void validateOfficeHome(File officeHome) {
        if (officeHome == null) {
            throw new IllegalStateException("officeHome not set and could not be auto-detected");
        }
        if (!officeHome.isDirectory()) {
            throw new IllegalStateException("officeHome doesn't exist or is not a directory: " + officeHome);
        }
        if (!LocalOfficeUtils.getOfficeExecutable(officeHome).isFile()) {
            throw new IllegalStateException("Invalid officeHome: it doesn't contain soffice.bin: " + officeHome);
        }
    }

    public static void validateOfficeTemplateProfileDirectory(File templateProfileDir) {
        if (templateProfileDir == null || new File(templateProfileDir, "user").isDirectory()) {
            return;
        }
        throw new IllegalStateException("templateProfileDir doesn't appear to contain a user profile: " + templateProfileDir);
    }

    public static void validateOfficeWorkingDirectory(File workingDir) {
        if (!workingDir.isDirectory()) {
            throw new IllegalStateException("workingDir doesn't exist or is not a directory: " + workingDir);
        }
    }

    private LocalOfficeUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }

    private static class DefaultOfficeHomeHolder {
        static final File INSTANCE;

        private DefaultOfficeHomeHolder() {
        }

        private static File findOfficeHome(String executablePath, String ... homePaths) {
            for (String homePath : homePaths) {
                File homeDir = new File(homePath);
                if (!new File(homeDir, executablePath).isFile()) continue;
                return homeDir;
            }
            return null;
        }

        static {
            if (StringUtils.isNotBlank((CharSequence)System.getProperty("office.home"))) {
                INSTANCE = new File(System.getProperty("office.home"));
            } else if (SystemUtils.IS_OS_WINDOWS) {
                String programFiles64 = System.getenv("ProgramFiles");
                String programFiles32 = System.getenv("ProgramFiles(x86)");
                INSTANCE = DefaultOfficeHomeHolder.findOfficeHome(LocalOfficeUtils.EXECUTABLE_WINDOWS, programFiles64 + File.separator + "LibreOffice 5", programFiles32 + File.separator + "LibreOffice 5", programFiles32 + File.separator + "OpenOffice 4", programFiles64 + File.separator + "LibreOffice 4", programFiles32 + File.separator + "LibreOffice 4", programFiles64 + File.separator + "LibreOffice 3", programFiles32 + File.separator + "LibreOffice 3", programFiles32 + File.separator + "OpenOffice.org 3");
            } else if (SystemUtils.IS_OS_MAC) {
                File homeDir = DefaultOfficeHomeHolder.findOfficeHome(LocalOfficeUtils.EXECUTABLE_MAC_41, "/Applications/LibreOffice.app/Contents", "/Applications/OpenOffice.org.app/Contents");
                if (homeDir == null) {
                    homeDir = DefaultOfficeHomeHolder.findOfficeHome(LocalOfficeUtils.EXECUTABLE_MAC, "/Applications/LibreOffice.app/Contents", "/Applications/OpenOffice.org.app/Contents");
                }
                INSTANCE = homeDir;
            } else {
                INSTANCE = DefaultOfficeHomeHolder.findOfficeHome(LocalOfficeUtils.EXECUTABLE_DEFAULT, "/usr/lib64/libreoffice", "/usr/lib/libreoffice", "/opt/libreoffice", "/usr/lib64/openoffice", "/usr/lib64/openoffice.org3", "/usr/lib64/openoffice.org", "/usr/lib/openoffice", "/usr/lib/openoffice.org3", "/usr/lib/openoffice.org", "/opt/openoffice.org3");
            }
        }
    }
}

