/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import org.dmg.pmml.Entity;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.XPathUtil;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <E extends Entity<?>> String getId(E entity, HasEntityRegistry<E> hasEntityRegistry) {
        BiMap<String, E> entityRegistry = hasEntityRegistry.getEntityRegistry();
        return EntityUtil.getId(entity, entityRegistry);
    }

    public static <E extends Entity<?>> String getId(E entity, BiMap<String, E> entityRegistry) {
        Object id = entity.getId();
        if (id == null) {
            BiMap inversedEntityRegistry = entityRegistry.inverse();
            return (String)inversedEntityRegistry.get(entity);
        }
        return TypeUtil.format(id);
    }

    public static <E extends Entity<?>> BiMap<String, E> buildBiMap(List<E> entities) {
        HashBiMap result = HashBiMap.create((int)entities.size());
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = (Entity)entities.get(i);
            String key = String.valueOf(i + 1);
            Object id = entity.getId();
            if (id != null) {
                key = TypeUtil.format(id);
            }
            if (result.containsKey((Object)key)) {
                throw new InvalidAttributeException(InvalidAttributeException.formatMessage((String)(XPathUtil.formatElement(entity.getClass()) + "@id=" + key)), (PMMLObject)entity);
            }
            result.put((Object)key, (Object)entity);
        }
        return result;
    }
}

