/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.jffi.InvokerFactory;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.JFFIPointer;
import com.kenai.jaffl.provider.jffi.Library;
import com.kenai.jaffl.util.EnumMapper;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Type;
import java.lang.reflect.Method;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FastIntInvokerFactory
implements InvokerFactory {
    FastIntInvokerFactory() {
    }

    public static final InvokerFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Invoker createInvoker(Method method2, com.kenai.jaffl.provider.Library library2, Map<LibraryOption, ?> options2) {
        FastIntFunctionInvoker functionInvoker;
        long address2 = ((Library)library2).findSymbolAddress(method2.getName());
        Class<?> returnType = method2.getReturnType();
        Class<?>[] paramTypes = method2.getParameterTypes();
        Type[] nativeParamTypes = new Type[paramTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.getNativeParameterType(paramTypes[i]);
        }
        Function function = new Function(address2, InvokerUtil.getNativeReturnType(method2), nativeParamTypes, CallingConvention.DEFAULT, InvokerUtil.requiresErrno(method2));
        boolean noErrno = !InvokerUtil.requiresErrno(method2);
        switch (paramTypes.length) {
            case 0: {
                functionInvoker = noErrno ? NoErrnoInvokerVrI.INSTANCE : FunctionInvokerVrI.INSTANCE;
                break;
            }
            case 1: {
                functionInvoker = noErrno ? NoErrnoInvokerIrI.INSTANCE : FunctionInvokerIrI.INSTANCE;
                break;
            }
            case 2: {
                functionInvoker = noErrno ? NoErrnoInvokerIIrI.INSTANCE : FunctionInvokerIIrI.INSTANCE;
                break;
            }
            case 3: {
                functionInvoker = noErrno ? NoErrnoInvokerIIIrI.INSTANCE : FunctionInvokerIIIrI.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter limit exceeded");
            }
        }
        if (Void.class.isAssignableFrom(returnType) || Void.TYPE == returnType) {
            return new VoidInvoker(function, functionInvoker);
        }
        if (Boolean.class.isAssignableFrom(returnType) || Boolean.TYPE == returnType) {
            return new BooleanInvoker(function, functionInvoker);
        }
        if (Byte.class.isAssignableFrom(returnType) || Byte.TYPE == returnType) {
            return new ByteInvoker(function, functionInvoker);
        }
        if (Short.class.isAssignableFrom(returnType) || Short.TYPE == returnType) {
            return new ShortInvoker(function, functionInvoker);
        }
        if (Integer.class.isAssignableFrom(returnType) || Integer.TYPE == returnType) {
            return new IntInvoker(function, functionInvoker);
        }
        if (NativeLong.class.isAssignableFrom(returnType)) {
            return new NativeLongInvoker(function, functionInvoker);
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return new EnumInvoker(function, functionInvoker, returnType);
        }
        if (Pointer.class.isAssignableFrom(returnType)) {
            return new PointerInvoker(function, functionInvoker);
        }
        throw new IllegalArgumentException("Unknown return type: " + returnType);
    }

    @Override
    public final boolean isMethodSupported(Method method2) {
        try {
            if (!FastIntInvokerFactory.isFastIntResult(method2.getReturnType())) {
                return false;
            }
            Class<?>[] parameterTypes = method2.getParameterTypes();
            if (parameterTypes.length > 3) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (FastIntInvokerFactory.isFastIntParam(parameterTypes[i])) continue;
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    static final boolean isFastIntResult(Class type2) {
        return Void.class.isAssignableFrom(type2) || Void.TYPE == type2 || Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2 || Enum.class.isAssignableFrom(type2) || Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2 || Short.class.isAssignableFrom(type2) || Short.TYPE == type2 || Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2 || NativeLong.class.isAssignableFrom(type2) && Platform.getPlatform().longSize() == 32 || Pointer.class.isAssignableFrom(type2) && Platform.getPlatform().addressSize() == 32;
    }

    static final boolean isFastIntParam(Class type2) {
        return Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2 || Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2 || Short.class.isAssignableFrom(type2) || Short.TYPE == type2 || Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2 || NativeLong.class.isAssignableFrom(type2) && Platform.getPlatform().longSize() == 32;
    }

    private static final class NoErrnoInvokerIIIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new NoErrnoInvokerIIIrI();

        private NoErrnoInvokerIIIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeNoErrnoIIIrI(function, ((Number)args2[0]).intValue(), ((Number)args2[1]).intValue(), ((Number)args2[2]).intValue());
        }
    }

    private static final class NoErrnoInvokerIIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new NoErrnoInvokerIIrI();

        private NoErrnoInvokerIIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeNoErrnoIIrI(function, ((Number)args2[0]).intValue(), ((Number)args2[1]).intValue());
        }
    }

    private static final class NoErrnoInvokerIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new NoErrnoInvokerIrI();

        private NoErrnoInvokerIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeNoErrnoIrI(function, ((Number)args2[0]).intValue());
        }
    }

    private static final class NoErrnoInvokerVrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new NoErrnoInvokerVrI();

        private NoErrnoInvokerVrI() {
        }

        public int invoke(Function function, Object[] args2) {
            return ffi.invokeNoErrnoVrI(function);
        }
    }

    private static final class FunctionInvokerIIIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new FunctionInvokerIIIrI();

        private FunctionInvokerIIIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeIIIrI(function, ((Number)args2[0]).intValue(), ((Number)args2[1]).intValue(), ((Number)args2[2]).intValue());
        }
    }

    static final class FunctionInvokerIIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new FunctionInvokerIIrI();

        FunctionInvokerIIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeIIrI(function, ((Number)args2[0]).intValue(), ((Number)args2[1]).intValue());
        }
    }

    static final class FunctionInvokerIrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new FunctionInvokerIrI();

        FunctionInvokerIrI() {
        }

        public final int invoke(Function function, Object[] args2) {
            return ffi.invokeIrI(function, ((Number)args2[0]).intValue());
        }
    }

    static final class FunctionInvokerVrI
    extends FastIntFunctionInvoker {
        static final FastIntFunctionInvoker INSTANCE = new FunctionInvokerVrI();

        FunctionInvokerVrI() {
        }

        public int invoke(Function function, Object[] args2) {
            return ffi.invokeVrI(function);
        }
    }

    static final class EnumInvoker
    extends BaseInvoker {
        private final Class enumClass;

        private EnumInvoker(Function function, FastIntFunctionInvoker invoker, Class enumClass) {
            super(function, invoker);
            this.enumClass = enumClass;
        }

        public final Object invoke(Object[] parameters) {
            return EnumMapper.getInstance().valueOf(this.functionInvoker.invoke(this.function, parameters), this.enumClass);
        }
    }

    static final class PointerInvoker
    extends BaseInvoker {
        public PointerInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return new JFFIPointer((long)this.functionInvoker.invoke(this.function, parameters) & 0xFFFFFFFFL);
        }
    }

    static final class BooleanInvoker
    extends BaseInvoker {
        public BooleanInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return this.functionInvoker.invoke(this.function, parameters) != 0;
        }
    }

    static final class NativeLongInvoker
    extends BaseInvoker {
        public NativeLongInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return NativeLong.valueOf(this.functionInvoker.invoke(this.function, parameters));
        }
    }

    static final class IntInvoker
    extends BaseInvoker {
        public IntInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return this.functionInvoker.invoke(this.function, parameters);
        }
    }

    static final class ShortInvoker
    extends BaseInvoker {
        public ShortInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return (short)this.functionInvoker.invoke(this.function, parameters);
        }
    }

    static final class ByteInvoker
    extends BaseInvoker {
        public ByteInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            return (byte)this.functionInvoker.invoke(this.function, parameters);
        }
    }

    static final class VoidInvoker
    extends BaseInvoker {
        public VoidInvoker(Function function, FastIntFunctionInvoker invoker) {
            super(function, invoker);
        }

        public final Object invoke(Object[] parameters) {
            this.functionInvoker.invoke(this.function, parameters);
            return null;
        }
    }

    static abstract class BaseInvoker
    implements Invoker {
        final Function function;
        final FastIntFunctionInvoker functionInvoker;

        BaseInvoker(Function function, FastIntFunctionInvoker invoker) {
            this.function = function;
            this.functionInvoker = invoker;
        }
    }

    static interface ResultConverter {
        public Object fromNative(int var1);
    }

    static abstract class FastIntFunctionInvoker {
        static final com.kenai.jffi.Invoker ffi = com.kenai.jffi.Invoker.getInstance();

        FastIntFunctionInvoker() {
        }

        abstract int invoke(Function var1, Object[] var2);
    }

    private static final class SingletonHolder {
        static InvokerFactory INSTANCE = new FastIntInvokerFactory();

        private SingletonHolder() {
        }
    }
}

