/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.java.MiniJava;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements JumpTarget,
DataType {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private String file;
    private int line;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyProc instance = RubyProc.newProc(runtime2, Block.Type.PROC);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2) {
        super(runtime2, rubyClass);
        this.type = type2;
    }

    public static RubyClass createProcClass(Ruby runtime2) {
        RubyClass procClass = runtime2.defineClass("Proc", runtime2.getObject(), PROC_ALLOCATOR);
        runtime2.setProc(procClass);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby runtime2, Block.Type type2) {
        return new RubyProc(runtime2, runtime2.getProc(), type2);
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2) {
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2);
        proc2.callInit(NULL_ARRAY, block);
        return proc2;
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            block = context.getPreviousFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null) {
            return block.getProcObject();
        }
        IRubyObject obj = ((RubyClass)recv2).allocate();
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        if (this.type == Block.Type.THREAD) {
            StaticScope oldScope = this.block.getBody().getStaticScope();
            BlockStaticScope newScope = new BlockStaticScope(oldScope.getEnclosingScope(), oldScope.getVariables());
            newScope.setBackrefLastlineScope(true);
            newScope.setPreviousCRefScope(oldScope.getPreviousCRefScope());
            newScope.setModule(oldScope.getModule());
            this.block.getBody().setStaticScope(newScope);
        }
        this.block.type = this.type;
        this.block.setProcObject(this);
        this.file = context.getFile();
        this.line = context.getLine();
        return this;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        newProc.file = this.file;
        newProc.line = this.line;
        return newProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getProc(), this.type);
        newProc.block = this.getBlock();
        newProc.file = this.file;
        newProc.line = this.line;
        return newProc;
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof RubyProc)) {
            return this.getRuntime().getFalse();
        }
        if (this == other || this.block.equals(((RubyProc)other).block)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.file + ":" + (this.line + 1) + ">");
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.call(context, args2, null, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call(context, args2, null, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self, Block passedBlock) {
        assert (args2 != null);
        Block newBlock = this.block.cloneBlock();
        JumpTarget jumpTarget = newBlock.getBinding().getFrame().getJumpTarget();
        try {
            if (self != null) {
                newBlock.getBinding().setSelf(self);
            }
            return newBlock.call(context, args2, passedBlock);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(this.getRuntime(), newBlock, bj, jumpTarget);
        }
        catch (JumpException.ReturnJump rj) {
            return this.handleReturnJump(this.getRuntime(), rj, jumpTarget);
        }
        catch (JumpException.RetryJump rj) {
            return this.handleRetryJump(this.getRuntime(), rj);
        }
    }

    private IRubyObject handleBreakJump(Ruby runtime2, Block newBlock, JumpException.BreakJump bj, JumpTarget jumpTarget) {
        switch (newBlock.type) {
            case LAMBDA: {
                if (bj.getTarget() == jumpTarget) {
                    return (IRubyObject)bj.getValue();
                }
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            case PROC: {
                if (newBlock.isEscaped()) {
                    throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "break from proc-closure");
                }
                throw bj;
            }
        }
        throw bj;
    }

    private IRubyObject handleReturnJump(Ruby runtime2, JumpException.ReturnJump rj, JumpTarget jumpTarget) {
        JumpTarget target = rj.getTarget();
        if (target == jumpTarget && this.block.type == Block.Type.LAMBDA) {
            return (IRubyObject)rj.getValue();
        }
        if (this.type == Block.Type.THREAD) {
            throw runtime2.newThreadError("return can't jump across threads");
        }
        throw rj;
    }

    private IRubyObject handleRetryJump(Ruby runtime2, JumpException.RetryJump rj) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, (IRubyObject)rj.getValue(), "retry not supported outside rescue");
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    public IRubyObject as(Class asClass) {
        final Ruby ruby = this.getRuntime();
        if (!asClass.isInterface()) {
            throw ruby.newTypeError(asClass.getCanonicalName() + " is not an interface");
        }
        return MiniJava.javaToRuby(ruby, Proxy.newProxyInstance(Ruby.getClassLoader(), new Class[]{asClass}, new InvocationHandler(){

            public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
                IRubyObject[] rubyArgs = new IRubyObject[args2.length + 1];
                rubyArgs[0] = RubySymbol.newSymbol(ruby, method2.getName());
                for (int i = 1; i < rubyArgs.length; ++i) {
                    rubyArgs[i] = MiniJava.javaToRuby(ruby, args2[i - 1]);
                }
                return MiniJava.rubyToJava(RubyProc.this.call(ruby.getCurrentContext(), rubyArgs));
            }
        }));
    }
}

