/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.compiler.ir.dataflow.DataFlowVar;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataFlowProblem {
    public final DF_Direction _direction;
    protected CFG _cfg;
    protected List<FlowGraphNode> _fgNodes;
    private ArrayList<DataFlowVar> _dfVars;
    private BitSet _bbSet;
    private int _nextDFVarId;
    private Map<BasicBlock, FlowGraphNode> _bbTofgMap;

    public DataFlowProblem(DF_Direction d) {
        this._direction = d;
        this._dfVars = new ArrayList();
        this._nextDFVarId = -1;
    }

    public abstract FlowGraphNode buildFlowGraphNode(BasicBlock var1);

    public abstract String getProblemName();

    public boolean isEmpty() {
        return false;
    }

    public DF_Direction getFlowDirection() {
        return this._direction;
    }

    public void compute_MOP_Solution(CFG c) {
        this._cfg = c;
        if (!this.isEmpty()) {
            LinkedList<FlowGraphNode> workList = this.buildFlowGraph();
            while (!workList.isEmpty()) {
                workList.removeFirst().computeDataFlowInfo(workList, this._bbSet);
            }
        }
    }

    public int getDFVarsCount() {
        return this._dfVars.size();
    }

    public Set<CFG.CFG_Edge> incomingEdgesOf(BasicBlock bb) {
        return this._cfg.incomingEdgesOf(bb);
    }

    public Set<CFG.CFG_Edge> outgoingEdgesOf(BasicBlock bb) {
        return this._cfg.outgoingEdgesOf(bb);
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("----").append(this.getProblemName()).append("----\n");
        buf.append("---- Data Flow Vars: ----\n");
        buf.append(this.getDataFlowVarsForOutput());
        buf.append("-------------------------\n");
        for (FlowGraphNode n : this._fgNodes) {
            buf.append("DF State for BB ").append(n._bb.getID()).append(":\n").append(n.toString());
        }
        return buf.toString();
    }

    int addDataFlowVar(DataFlowVar v) {
        ++this._nextDFVarId;
        this._dfVars.add(this._nextDFVarId, v);
        return this._nextDFVarId;
    }

    FlowGraphNode getFlowGraphNode(BasicBlock b) {
        return this._bbTofgMap.get(b);
    }

    private LinkedList<FlowGraphNode> buildFlowGraph() {
        LinkedList<FlowGraphNode> workList = new LinkedList<FlowGraphNode>();
        this._bbTofgMap = new HashMap<BasicBlock, FlowGraphNode>();
        this._bbSet = new BitSet(1 + this._cfg.getMaxNodeID());
        for (BasicBlock bb : this._cfg.getNodes()) {
            FlowGraphNode fgNode = this.buildFlowGraphNode(bb);
            fgNode.buildDataFlowVars();
            workList.add(fgNode);
            this._bbTofgMap.put(bb, fgNode);
            this._bbSet.set(bb.getID());
        }
        this._fgNodes = (List)workList.clone();
        for (FlowGraphNode fg : workList) {
            fg.init();
        }
        return workList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DF_Direction {
        FORWARD,
        BACKWARD,
        BIDIRECTIONAL;

    }
}

