/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.AutoPointer;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.CallbackManager;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.IOModule;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NoImplFactory;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.StructLayoutBuilder;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.io.FileDescriptorIO;
import org.jruby.runtime.load.Library;

public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime2, RubyModule ffi2) {
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("Type") == null) {
                Type.createTypeClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AbstractMemory") == null) {
                AbstractMemory.createAbstractMemoryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Buffer") == null) {
                Buffer.createBufferClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Pointer") == null) {
                Pointer.createPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AutoPointer") == null) {
                AutoPointer.createAutoPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("MemoryPointer") == null) {
                MemoryPointer.createMemoryPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Struct") == null) {
                Struct.createStructClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("StructLayout") == null) {
                StructLayout.createStructLayoutClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("StructLayoutBuilder") == null) {
                StructLayoutBuilder.createStructLayoutBuilderClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("StructByValue") == null) {
                StructByValue.createStructByValueClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AbstractInvoker") == null) {
                AbstractInvoker.createAbstractInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("CallbackInfo") == null) {
                CallbackInfo.createCallbackInfoClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Enum") == null) {
                Enum.createEnumClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(runtime2, ffi2);
            }
            Platform.createPlatformModule(runtime2, ffi2);
            IOModule.createIOModule(runtime2, ffi2);
        }
    }

    public abstract AllocatedDirectMemoryIO allocateDirectMemory(Ruby var1, int var2, boolean var3);

    public abstract AllocatedDirectMemoryIO allocateDirectMemory(Ruby var1, int var2, int var3, boolean var4);

    public abstract DirectMemoryIO wrapDirectMemory(Ruby var1, long var2);

    public abstract CallbackManager getCallbackManager();

    public abstract AbstractInvoker newFunction(Ruby var1, Pointer var2, CallbackInfo var3);

    public abstract int sizeOf(NativeType var1);

    public abstract int alignmentOf(NativeType var1);

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            if (!RubyInstanceConfig.nativeEnabled) {
                throw runtime2.newLoadError("Native API access is disabled");
            }
            if (!Platform.getPlatform().isSupported()) {
                throw runtime2.newLoadError("Unsupported platform: " + Platform.getPlatform().getName());
            }
            RubyModule ffi2 = runtime2.defineModule("FFI");
            try {
                Factory.getInstance().init(runtime2, ffi2);
            }
            catch (Exception e) {
                throw runtime2.newLoadError("Could not load FFI Provider: " + e.getLocalizedMessage());
            }
        }
    }

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            String providerName = System.getProperty("ffi.factory");
            Factory factory = null;
            ArrayList<String> providerNames = new ArrayList<String>();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            if (providerName != null) {
                providerNames.add(providerName);
            }
            String prefix = Factory.class.getPackage().getName();
            providerNames.add(prefix + ".jffi.Factory");
            for (String className : providerNames) {
                try {
                    factory = (Factory)Class.forName(className, true, Ruby.getClassLoader()).newInstance();
                    break;
                }
                catch (Throwable ex) {
                    errors.add(ex);
                }
            }
            if (factory == null) {
                StringBuilder sb = new StringBuilder();
                for (Throwable t : errors) {
                    sb.append(t.getLocalizedMessage()).append('\n');
                }
                factory = new NoImplFactory(sb.toString());
            }
            return factory;
        }
    }
}

