/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInvoker
extends RubyToJavaInvoker {
    private Constructor[] ctors;

    public ConstructorInvoker(RubyModule host, List<Constructor> methods2) {
        super(host);
        this.ctors = methods2.toArray(new Constructor[methods2.size()]);
        if (!Ruby.isSecurityRestricted()) {
            try {
                Method.setAccessible(this.ctors, true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    synchronized void createJavaCallables(Ruby runtime2) {
        if (!this.initialized) {
            if (this.ctors != null) {
                if (this.ctors.length == 1) {
                    this.javaCallable = JavaConstructor.create(runtime2, this.ctors[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaConstructor>> methodsMap = new HashMap<Integer, ArrayList<JavaConstructor>>();
                    int maxArity = 0;
                    for (Constructor ctor : this.ctors) {
                        int arity2 = ctor.getParameterTypes().length;
                        maxArity = Math.max(arity2, maxArity);
                        ArrayList<JavaConstructor> methodsForArity = (ArrayList<JavaConstructor>)methodsMap.get(arity2);
                        if (methodsForArity == null) {
                            methodsForArity = new ArrayList<JavaConstructor>();
                            methodsMap.put(arity2, methodsForArity);
                        }
                        methodsForArity.add(JavaConstructor.create(runtime2, ctor));
                    }
                    this.javaCallables = new JavaConstructor[maxArity + 1][];
                    for (Map.Entry entry : methodsMap.entrySet()) {
                        List ctorsForArity = (List)entry.getValue();
                        JavaConstructor[] methodsArray = ctorsForArity.toArray(new JavaConstructor[ctorsForArity.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = methodsArray;
                    }
                }
                this.ctors = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        this.createJavaCallables(runtime2);
        JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
        int len = args2.length;
        Object[] convertedArgs = new Object[len];
        JavaConstructor constructor2 = (JavaConstructor)this.findCallable(self, name2, args2, len);
        for (int i = 0; i < len; ++i) {
            convertedArgs[i] = ConstructorInvoker.convertArg(context, args2[i], constructor2, i);
        }
        proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(convertedArgs)));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        this.createJavaCallables(runtime2);
        JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
        JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityZero(self, name2);
        proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect()));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        this.createJavaCallables(runtime2);
        JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
        JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityOne(self, name2, arg0);
        Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
        proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0)));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        this.createJavaCallables(runtime2);
        JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
        JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityTwo(self, name2, arg0, arg1);
        Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
        Object cArg1 = ConstructorInvoker.convertArg(context, arg1, constructor2, 1);
        proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0, cArg1)));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        this.createJavaCallables(runtime2);
        JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
        JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityThree(self, name2, arg0, arg1, arg2);
        Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
        Object cArg1 = ConstructorInvoker.convertArg(context, arg1, constructor2, 1);
        Object cArg2 = ConstructorInvoker.convertArg(context, arg2, constructor2, 2);
        proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0, cArg1, cArg2)));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            this.createJavaCallables(runtime2);
            JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
            int len = args2.length;
            Object[] convertedArgs = new Object[len + 1];
            IRubyObject[] intermediate = new IRubyObject[len + 1];
            System.arraycopy(args2, 0, intermediate, 0, len);
            intermediate[len] = RubyProc.newProc(runtime2, block, Block.Type.LAMBDA);
            JavaConstructor constructor2 = (JavaConstructor)this.findCallable(self, name2, intermediate, len + 1);
            for (int i = 0; i < len + 1; ++i) {
                convertedArgs[i] = ConstructorInvoker.convertArg(context, intermediate[i], constructor2, i);
            }
            proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(convertedArgs)));
            return self;
        }
        return this.call(context, self, clazz, name2, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            this.createJavaCallables(runtime2);
            JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityOne(self, name2, proc2);
            Object cArg0 = ConstructorInvoker.convertArg(context, proc2, constructor2, 0);
            proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0)));
            return self;
        }
        return this.call(context, self, clazz, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            this.createJavaCallables(runtime2);
            JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityTwo(self, name2, arg0, proc2);
            Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
            Object cArg1 = ConstructorInvoker.convertArg(context, proc2, constructor2, 1);
            proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0, cArg1)));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            this.createJavaCallables(runtime2);
            JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityThree(self, name2, arg0, arg1, proc2);
            Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
            Object cArg1 = ConstructorInvoker.convertArg(context, arg1, constructor2, 1);
            Object cArg2 = ConstructorInvoker.convertArg(context, proc2, constructor2, 2);
            proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0, cArg1, cArg2)));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            this.createJavaCallables(runtime2);
            JavaProxy proxy2 = ConstructorInvoker.castJavaProxy(self);
            RubyProc proc2 = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor constructor2 = (JavaConstructor)this.findCallableArityFour(self, name2, arg0, arg1, arg2, proc2);
            Object cArg0 = ConstructorInvoker.convertArg(context, arg0, constructor2, 0);
            Object cArg1 = ConstructorInvoker.convertArg(context, arg1, constructor2, 1);
            Object cArg2 = ConstructorInvoker.convertArg(context, arg2, constructor2, 2);
            Object cArg3 = ConstructorInvoker.convertArg(context, proc2, constructor2, 3);
            proxy2.dataWrapStruct(JavaObject.wrap(runtime2, constructor2.newInstanceDirect(cArg0, cArg1, cArg2, cArg3)));
            return self;
        }
        return this.call(context, self, clazz, name2, arg0, arg1, arg2);
    }
}

