/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public final class ReferenceReaper {
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Thread reaperThread;
    private final Runnable reaper = new Runnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    Reference r;
                    if (!((r = ReferenceReaper.this.referenceQueue.remove()) instanceof Runnable)) {
                        continue;
                    }
                    ((Runnable)((Object)r)).run();
                }
            }
            catch (InterruptedException ex) {}
            finally {
                return;
            }
        }
    };

    private ReferenceReaper() {
        this.reaperThread = new Thread(this.reaper);
        this.reaperThread.setDaemon(true);
        this.reaperThread.start();
    }

    public static final ReferenceReaper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Phantom<T>
    extends PhantomReference<T>
    implements Runnable {
        public Phantom(T referent) {
            super(referent, ReferenceReaper.getInstance().referenceQueue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Soft<T>
    extends SoftReference<T>
    implements Runnable {
        public Soft(T referent) {
            super(referent, ReferenceReaper.getInstance().referenceQueue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Weak<T>
    extends WeakReference<T>
    implements Runnable {
        public Weak(T referent) {
            super(referent, ReferenceReaper.getInstance().referenceQueue);
        }
    }

    private static final class SingletonHolder {
        private static final ReferenceReaper INSTANCE = new ReferenceReaper();

        private SingletonHolder() {
        }
    }
}

