/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IEqlNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FixnumNode
extends Node
implements ILiteralNode,
IEqlNode {
    private long value;
    private RubyFixnum fixnum;

    public FixnumNode(ISourcePosition position, long value2) {
        super(position);
        this.value = value2;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFixnumNode(this);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FIXNUMNODE;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value2) {
        if (this.fixnum != null) {
            this.fixnum = null;
        }
        this.value = value2;
    }

    public RubyFixnum getFixnum(Ruby runtime) {
        if (this.fixnum == null) {
            this.fixnum = RubyFixnum.newFixnum(runtime, this.value);
            return this.fixnum;
        }
        return this.fixnum;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.getFixnum(runtime);
    }

    @Override
    public boolean eql(IRubyObject otherValue, ThreadContext context, Ruby runtime, IRubyObject self2, Block aBlock) {
        if (otherValue instanceof RubyFixnum) {
            return this.value == ((RubyFixnum)otherValue).getLongValue();
        }
        return this.getFixnum(runtime).op_equal(context, otherValue).isTrue();
    }
}

