/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class UnresolvedSuperInstr
extends CallInstr {
    public UnresolvedSuperInstr(Variable result2, Operand receiver2, Operand[] args2, Operand closure) {
        super(Operation.SUPER, CallType.SUPER, result2, MethAddr.UNKNOWN_SUPER_TARGET, receiver2, args2, closure);
    }

    public UnresolvedSuperInstr(Operation op, Variable result2, Operand receiver2, Operand closure) {
        super(op, CallType.SUPER, result2, MethAddr.UNKNOWN_SUPER_TARGET, receiver2, EMPTY_OPERANDS, closure);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new UnresolvedSuperInstr(ii.getRenamedVariable(this.getResult()), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.closure == null ? null : this.closure.cloneForInlining(ii));
    }

    @Override
    public Instr discardResult() {
        return this;
    }

    @Override
    public CallBase specializeForInterpretation() {
        return this;
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block aBlock) {
        IRubyObject[] args2 = this.prepareArguments(context, self2, this.getCallArgs(), currDynScope, temp);
        Block block = this.prepareBlock(context, self2, currDynScope, temp);
        return this.interpretSuper(context, self2, args2, block);
    }

    protected Object interpretSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyClass objClass = context.runtime.getObject();
        RubyModule klazz = context.getFrameKlazz();
        String methodName = context.getCurrentFrame().getName();
        UnresolvedSuperInstr.checkSuperDisabledOrOutOfMethod(context, klazz, methodName);
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        UndefinedMethod method2 = superClass != null ? superClass.searchMethod(methodName) : UndefinedMethod.INSTANCE;
        IRubyObject rVal = method2.isUndefined() ? Helpers.callMethodMissing(context, self2, method2.getVisibility(), methodName, CallType.SUPER, args2, block) : ((DynamicMethod)method2).call(context, self2, (RubyModule)superClass, methodName, args2, block);
        return this.hasUnusedResult() ? null : rVal;
    }

    protected static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule frameClass, String methodName) {
        if (frameClass == null) {
            if (methodName == null || methodName != "") {
                throw context.runtime.newNameError("superclass method '" + methodName + "' disabled", methodName);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.runtime.getNil());
        }
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnresolvedSuperInstr(this);
    }
}

