/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.cli;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.CompositeAnnotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.cli.Arguments;
import org.jsonschema2pojo.cli.FileCodeWriterWithEncoding;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.RuleFactory;

public final class Jsonschema2Pojo {
    private Jsonschema2Pojo() {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Arguments arguments = new Arguments().parse(args);
        Jsonschema2Pojo.generate(arguments);
    }

    public static void generate(GenerationConfig config) throws FileNotFoundException, IOException {
        Annotator annotator = Jsonschema2Pojo.getAnnotator(config);
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, annotator, new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        if (config.isRemoveOldOutput()) {
            Jsonschema2Pojo.removeOldOutput(config.getTargetDirectory());
        }
        Iterator sources = config.getSource();
        while (sources.hasNext()) {
            File source = (File)sources.next();
            if (source.isDirectory()) {
                Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, StringUtils.defaultString((String)config.getTargetPackage()), Arrays.asList(source.listFiles()));
                continue;
            }
            mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(source), StringUtils.defaultString((String)config.getTargetPackage()), source.toURI().toURL());
        }
        if (!config.getTargetDirectory().exists() && !config.getTargetDirectory().mkdirs()) {
            throw new GenerationException("Could not create or access target directory " + config.getTargetDirectory().getAbsolutePath());
        }
        FileCodeWriterWithEncoding sourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
        FileCodeWriterWithEncoding resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
        codeModel.build((CodeWriter)sourcesWriter, (CodeWriter)resourcesWriter);
    }

    private static void generateRecursive(GenerationConfig config, SchemaMapper mapper, JCodeModel codeModel, String packageName, List<File> schemaFiles) throws FileNotFoundException, IOException {
        Collections.sort(schemaFiles);
        for (File child : schemaFiles) {
            if (child.isFile()) {
                mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(child), StringUtils.defaultString((String)packageName), child.toURI().toURL());
                continue;
            }
            Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, packageName + "." + child.getName(), Arrays.asList(child.listFiles()));
        }
    }

    private static void removeOldOutput(File targetDirectory) {
        if (targetDirectory.exists()) {
            for (File f : targetDirectory.listFiles()) {
                Jsonschema2Pojo.delete(f);
            }
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                Jsonschema2Pojo.delete(child);
            }
        }
        f.delete();
    }

    private static Annotator getAnnotator(GenerationConfig config) {
        Annotator coreAnnotator = new AnnotatorFactory().getAnnotator(config.getAnnotationStyle());
        Annotator customAnnotator = new AnnotatorFactory().getAnnotator(config.getCustomAnnotator());
        return new CompositeAnnotator(new Annotator[]{coreAnnotator, customAnnotator});
    }

    private static String getNodeName(File file) {
        return StringUtils.substringBeforeLast((String)file.getName(), (String)".");
    }
}

