/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public abstract class NamingEntry {
    public static final int SCOPE_CONTAINER = 0;
    public static final int SCOPE_WEBAPP = 1;
    protected String jndiName;
    protected Object objectToBind;
    protected String absoluteObjectNameString;
    protected String namingEntryNameString;
    protected String objectNameString;
    protected Context context;
    protected boolean isContainerScope;
    protected static ThreadLocal scope = new ThreadLocal();

    public static void setScope(int scopeType) {
        scope.set(new Integer(scopeType));
    }

    public static int getScope() {
        Integer val = (Integer)scope.get();
        return val == null ? 0 : val;
    }

    public static Name makeNamingEntryName(NameParser parser, String jndiName) throws NamingException {
        if (jndiName == null || parser == null) {
            return null;
        }
        Name name = parser.parse("");
        name.add(jndiName);
        String lastAtom = (String)name.remove(name.size() - 1);
        lastAtom = "__" + lastAtom;
        name.add(lastAtom);
        return name;
    }

    public NamingEntry(String jndiName, Object object) throws NamingException {
        this.jndiName = jndiName;
        this.objectToBind = object;
        this.isContainerScope = NamingEntry.getScope() == 0;
        InitialContext icontext = new InitialContext();
        this.context = this.isContainerScope ? icontext : (Context)icontext.lookup("java:comp/env");
        this.save();
    }

    public void bindToENC(String localName) throws NamingException {
        if (localName.equals(this.jndiName) && this.isLocal()) {
            Log.warn((String)("Already bound " + localName + " to java:comp/env with " + this.absoluteObjectNameString));
            return;
        }
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        Log.debug((String)("Binding java:comp/env/" + localName + " to " + this.absoluteObjectNameString));
        NamingUtil.bind((Context)env, (String)localName, (Object)new LinkRef(this.absoluteObjectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            Log.debug((String)("Unbinding java:comp/env/" + this.getJndiName()));
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public void release() {
        try {
            this.context.unbind(this.objectNameString);
            this.context.unbind(this.namingEntryNameString);
            this.absoluteObjectNameString = null;
            this.jndiName = null;
            this.namingEntryNameString = null;
            this.objectNameString = null;
            this.objectToBind = null;
            this.context = null;
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Object getObjectToBind() throws NamingException {
        return this.objectToBind;
    }

    public boolean isGlobal() {
        return this.isContainerScope;
    }

    public boolean isLocal() {
        return !this.isContainerScope;
    }

    protected void save() throws NamingException {
        NameParser parser = this.context.getNameParser("");
        Name contextName = parser.parse(this.context.getNameInNamespace());
        Name namingEntryName = NamingEntry.makeNamingEntryName(parser, this.jndiName);
        this.namingEntryNameString = namingEntryName.toString();
        NamingUtil.bind((Context)this.context, (String)this.namingEntryNameString, (Object)this);
        Log.debug((String)("Bound " + (this.isGlobal() ? "" : "java:") + namingEntryName.addAll(0, contextName)));
        Name objectName = parser.parse(this.getJndiName());
        this.objectNameString = objectName.toString();
        NamingUtil.bind((Context)this.context, (String)this.objectNameString, (Object)this.getObjectToBind());
        Name fullName = objectName.addAll(0, contextName);
        this.absoluteObjectNameString = (this.isContainerScope ? "" : "java:") + fullName.toString();
        Log.debug((String)("Bound " + this.absoluteObjectNameString));
    }
}

