/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.sensors;

import org.multiverse.utils.ToolUnsafe;
import sun.misc.Unsafe;

public final class StripedCounter {
    private static final long serialVersionUID = -2308431214976778248L;
    private static final Unsafe unsafe = ToolUnsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(long[].class);
    private static final int scale = unsafe.arrayIndexScale(long[].class);
    private final long[] array;

    public long rawIndex(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return (long)base + (long)i * (long)scale;
    }

    public StripedCounter(int length) {
        this.array = new long[length];
        if (length > 0) {
            unsafe.putLongVolatile(this.array, this.rawIndex(0), 0L);
        }
    }

    public long get() {
        long result = 0L;
        for (int k = 0; k < this.array.length; ++k) {
            result += unsafe.getLongVolatile(this.array, this.rawIndex(k));
        }
        return result;
    }

    public void inc(int random, long count) {
        long next;
        if (count == 0L) {
            return;
        }
        int index = (int)(Math.abs((long)random + count) % (long)this.array.length);
        do {
            long current;
            long rawIndex;
            if (!unsafe.compareAndSwapLong(this.array, rawIndex = this.rawIndex(index), current = unsafe.getLongVolatile(this.array, rawIndex), next = current + count)) continue;
            return;
        } while ((index = (int)(Math.abs((long)(random + index) + next) % (long)this.array.length)) >= 0);
        throw new RuntimeException();
    }

    public void inc(long count) {
        long next;
        if (count == 0L) {
            return;
        }
        int index = (int)(Math.abs(count) % (long)this.array.length);
        do {
            long current;
            long rawIndex;
            if (!unsafe.compareAndSwapLong(this.array, rawIndex = this.rawIndex(index), current = unsafe.getLongVolatile(this.array, rawIndex), next = current + count)) continue;
            return;
        } while ((index = (int)(Math.abs((long)index + next) % (long)this.array.length)) >= 0);
        throw new RuntimeException();
    }

    public void incAtIndex(int index, long count) {
        long next;
        long current;
        if (count == 0L) {
            return;
        }
        long rawIndex = this.rawIndex(index *= 128);
        while (!unsafe.compareAndSwapLong(this.array, rawIndex, current = unsafe.getLongVolatile(this.array, rawIndex), next = current + count)) {
        }
    }

    public String toString() {
        return String.format("StripedCounter(value=%s, width=%s)", this.get(), this.array.length);
    }
}

