/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactionalobjects;

import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.stms.beta.BetaObjectPool;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.CallableNode;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public final class BetaBooleanRefTranlocal
extends BetaTranlocal {
    public boolean value;
    public boolean oldValue;

    public BetaBooleanRefTranlocal(BetaBooleanRef ref) {
        super(ref);
    }

    @Override
    public final void openForRead(int desiredLockMode) {
        boolean loadSuccess;
        if (this.tx.status != 1) {
            throw this.tx.abortOpenForRead(this.owner);
        }
        BetaTransactionConfiguration config = this.tx.config;
        desiredLockMode = desiredLockMode >= config.readLockMode ? desiredLockMode : config.readLockMode;
        switch (this.status) {
            case 1: {
                return;
            }
            case 0: {
                BetaBooleanRef o = (BetaBooleanRef)this.owner;
                boolean loadSuccess2 = o.___load(config.spinCount, this.tx, desiredLockMode, this);
                if (!loadSuccess2) {
                    this.tx.abort();
                    throw ReadWriteConflict.INSTANCE;
                }
                this.setStatus(4);
                this.setIgnore(desiredLockMode == 0 && !this.hasDepartObligation());
                return;
            }
            case 3: {
                boolean loadSuccess3 = ((BetaBooleanRef)this.owner).___load(config.spinCount, this.tx, 2, this);
                if (!loadSuccess3) {
                    this.tx.abort();
                    throw ReadWriteConflict.INSTANCE;
                }
                this.evaluateCommutingFunctions(this.tx.pool);
                return;
            }
        }
        BetaBooleanRef o = (BetaBooleanRef)this.owner;
        if (this.getLockMode() < desiredLockMode && !(loadSuccess = o.___tryLockAndCheckConflict(this.tx, config.spinCount, this, desiredLockMode == 2))) {
            this.tx.abort();
            throw ReadWriteConflict.INSTANCE;
        }
    }

    @Override
    public final void openForWrite(int desiredLockMode) {
        boolean loadSuccess;
        if (this.tx.status != 1) {
            throw this.tx.abortOpenForRead(this.owner);
        }
        BetaTransactionConfiguration config = this.tx.config;
        if (config.readonly) {
            throw this.tx.abortOpenForWriteWhenReadonly(this.owner);
        }
        desiredLockMode = desiredLockMode >= config.readLockMode ? desiredLockMode : config.writeLockMode;
        switch (this.status) {
            case 1: {
                return;
            }
            case 0: {
                BetaBooleanRef o = (BetaBooleanRef)this.owner;
                boolean loadSuccess2 = o.___load(config.spinCount, this.tx, desiredLockMode, this);
                if (!loadSuccess2) {
                    this.tx.abort();
                    throw ReadWriteConflict.INSTANCE;
                }
                this.setStatus(2);
                this.tx.hasUpdates = true;
                this.setIgnore(desiredLockMode == 0 && !this.hasDepartObligation());
                return;
            }
            case 3: {
                boolean loadSuccess3 = ((BetaBooleanRef)this.owner).___load(config.spinCount, this.tx, 2, this);
                if (!loadSuccess3) {
                    this.tx.abort();
                    throw ReadWriteConflict.INSTANCE;
                }
                this.evaluateCommutingFunctions(this.tx.pool);
                this.setStatus(2);
                this.tx.hasUpdates = true;
                this.setIgnore(desiredLockMode == 0 && !this.hasDepartObligation());
                return;
            }
        }
        BetaBooleanRef o = (BetaBooleanRef)this.owner;
        this.setStatus(2);
        this.tx.hasUpdates = true;
        if (this.getLockMode() < desiredLockMode && !(loadSuccess = o.___tryLockAndCheckConflict(this.tx, config.spinCount, this, desiredLockMode == 2))) {
            this.tx.abort();
            throw ReadWriteConflict.INSTANCE;
        }
    }

    @Override
    public final void evaluateCommutingFunctions(BetaObjectPool pool) {
        assert (this.isCommuting());
        boolean newValue = this.value;
        CallableNode current = this.headCallable;
        this.headCallable = null;
        do {
            BooleanFunction function = (BooleanFunction)current.function;
            newValue = function.call(newValue);
            CallableNode old = current;
            current = current.next;
            pool.putCallableNode(old);
        } while (current != null);
        this.value = newValue;
        this.setDirty(newValue != this.oldValue);
        this.setStatus(2);
    }

    @Override
    public void addCommutingFunction(Function function, BetaObjectPool pool) {
        assert (this.isCommuting());
        CallableNode node = pool.takeCallableNode();
        node.function = function;
        node.next = this.headCallable;
        this.headCallable = node;
    }

    @Override
    public void prepareForPooling(BetaObjectPool pool) {
        this.version = 0L;
        this.value = false;
        this.oldValue = false;
        this.owner = null;
        this.setLockMode(0);
        this.setDepartObligation(false);
        this.setStatus(0);
        this.setDirty(false);
        this.setIsConflictCheckNeeded(false);
        this.tx = null;
        CallableNode current = this.headCallable;
        if (current != null) {
            CallableNode next;
            this.headCallable = null;
            do {
                next = current.next;
                pool.putCallableNode(current);
            } while ((current = next) != null);
        }
    }

    @Override
    public boolean calculateIsDirty() {
        if (this.isDirty()) {
            return true;
        }
        this.setDirty(this.value != this.oldValue);
        return this.isDirty();
    }
}

