/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

import java.util.ArrayList;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.TransactionalObject;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.IllegalTransactionStateException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.RetryNotAllowedException;
import org.multiverse.api.exceptions.RetryNotPossibleException;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.StmMismatchException;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.beta.BetaObjectPool;
import org.multiverse.stms.beta.BetaStmConstants;
import org.multiverse.stms.beta.BetaStmUtils;
import org.multiverse.stms.beta.conflictcounters.LocalConflictCounter;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRef;
import org.multiverse.stms.beta.transactionalobjects.BetaBooleanRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRef;
import org.multiverse.stms.beta.transactionalobjects.BetaDoubleRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRef;
import org.multiverse.stms.beta.transactionalobjects.BetaIntRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRef;
import org.multiverse.stms.beta.transactionalobjects.BetaLongRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaRef;
import org.multiverse.stms.beta.transactionalobjects.BetaRefTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTranlocal;
import org.multiverse.stms.beta.transactionalobjects.BetaTransactionalObject;
import org.multiverse.stms.beta.transactions.BetaTransactionConfiguration;

public abstract class BetaTransaction
implements Transaction,
BetaStmConstants {
    public static final int POOL_TRANSACTIONTYPE_LEAN_MONO = 0;
    public static final int POOL_TRANSACTIONTYPE_FAT_MONO = 1;
    public static final int POOL_TRANSACTIONTYPE_LEAN_ARRAY = 2;
    public static final int POOL_TRANSACTIONTYPE_FAT_ARRAY = 3;
    public static final int POOL_TRANSACTIONTYPE_LEAN_ARRAYTREE = 4;
    public static final int POOL_TRANSACTIONTYPE_FAT_ARRAYTREE = 5;
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int PREPARED = 2;
    public static final int ABORTED = 3;
    public static final int COMMITTED = 4;
    private final int poolTransactionType;
    public int status = 1;
    public int attempt = 1;
    public long remainingTimeoutNs;
    public BetaTransactionConfiguration config;
    public boolean abortOnly;
    public final BetaObjectPool pool = new BetaObjectPool();
    public boolean hasUpdates;

    public BetaTransaction(int poolTransactionType, BetaTransactionConfiguration config) {
        this.poolTransactionType = poolTransactionType;
        this.config = config;
    }

    public abstract LocalConflictCounter getLocalConflictCounter();

    public final boolean isAlive() {
        return this.status == 1 || this.status == 2;
    }

    public final BetaObjectPool getPool() {
        return this.pool;
    }

    public final int getPoolTransactionType() {
        return this.poolTransactionType;
    }

    @Override
    public final BetaTransactionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public final int getAttempt() {
        return this.attempt;
    }

    @Override
    public final TransactionStatus getStatus() {
        switch (this.status) {
            case 0: {
                return TransactionStatus.Undefined;
            }
            case 1: {
                return TransactionStatus.Active;
            }
            case 3: {
                return TransactionStatus.Aborted;
            }
            case 4: {
                return TransactionStatus.Committed;
            }
            case 2: {
                return TransactionStatus.Prepared;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final long getRemainingTimeoutNs() {
        return this.remainingTimeoutNs;
    }

    public final void setRemainingTimeoutNs(long timeoutNs) {
        if (timeoutNs > this.remainingTimeoutNs) {
            throw new IllegalArgumentException();
        }
        this.remainingTimeoutNs = timeoutNs;
    }

    public abstract BetaTranlocal get(BetaTransactionalObject var1);

    public abstract BetaTranlocal locate(BetaTransactionalObject var1);

    public abstract ArrayList<TransactionLifecycleListener> getNormalListeners();

    public final SpeculativeConfigurationError abortOnTooSmallSize(int minimalSize) {
        this.config.needsMinimalTransactionLength(minimalSize);
        this.abort();
        return SpeculativeConfigurationError.INSTANCE;
    }

    public final ReadWriteConflict abortOnReadConflict() {
        this.abort();
        return ReadWriteConflict.INSTANCE;
    }

    public final ReadWriteConflict abortOnWriteConflict() {
        this.abort();
        return ReadWriteConflict.INSTANCE;
    }

    public final void materializeConflict(BetaTransactionalObject ref) {
        BetaTranlocal tranlocal = this.openForRead(ref, 0);
        tranlocal.setIsConflictCheckNeeded(true);
    }

    public final IllegalTransactionStateException abortRead(BetaTransactionalObject owner) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.read, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.read, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.read, reason: the transaction is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final NullPointerException abortReadOnNull() {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.read, reason: the reference is null", this.config.familyName));
    }

    public final StmMismatchException abortReadOnStmMismatch(BetaTransactionalObject ref) {
        this.abort();
        return new StmMismatchException(String.format("[%s] Failed to execute Transaction.read, reason: The transaction belongs to a different stm than the stm that created ref '%s'", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final IllegalTransactionStateException abortLocate(BetaTransactionalObject owner) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.locate, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.locate, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.locate, reason: the transaction is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final NullPointerException abortLocateWhenNullReference() {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.locate, reason: the reference is null", this.config.familyName));
    }

    @Override
    public final void setAbortOnly() {
        switch (this.status) {
            case 0: {
                throw new TodoException();
            }
            case 1: {
                this.abortOnly = true;
                break;
            }
            case 2: {
                throw new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.setAbortOnly, reason: the transaction is prepared", this.config.familyName));
            }
            case 4: {
                throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.setAbortOnly, reason: the transaction is committed", this.config.familyName));
            }
            case 3: {
                throw new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.setAbortOnly, reason: the transaction is aborted", this.config.familyName));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public final NullPointerException abortCommuteOnNullFunction(TransactionalObject ref) {
        this.abort();
        throw new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.commute, reason: the function is null", this.config.familyName));
    }

    public final RetryNotPossibleException abortOnNoRetryPossible() {
        this.abort();
        throw new RetryNotPossibleException(String.format("[%s] Failed to execute BetaTransaction.retry, reason: there are no tracked reads", this.config.familyName));
    }

    public final RetryNotAllowedException abortOnNoBlockingAllowed() {
        this.abort();
        return new RetryNotAllowedException(String.format("[%s] Failed to execute BetaTransaction.retry, reason: the transaction doesn't allow blocking", this.config.familyName));
    }

    public final IllegalTransactionStateException abortOnFaultyStatusOfRetry() {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.retry, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.retry, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.retry, reason: the transaction is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final StmMismatchException abortOnStmMismatch(BetaTransactionalObject ref) {
        this.abort();
        return new StmMismatchException(String.format("[%s] The transaction belongs to a different stm than the stm that created ref '%s'", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final NullPointerException abortOpenOnNull() {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.open, reason: the reference is null", this.config.familyName));
    }

    public final RuntimeException abortOnOpenForReadWhileEvaluatingCommute(BetaTransactionalObject ref) {
        this.abort();
        return new IllegalTransactionStateException(String.format("[%s] Failed to execute BetaTransaction.openForRead '%s', reason: a commuting function is being evaluated", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final RuntimeException abortOnOpenForWriteWhileEvaluatingCommute(BetaTransactionalObject ref) {
        this.abort();
        return new IllegalTransactionStateException(String.format("[%s] Failed to execute BetaTransaction.openForWrite '%s', reason: a commuting function is being evaluated", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final RuntimeException abortOpen(BetaTransactionalObject ref) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.open '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(ref)));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.open '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(ref)));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.open '%s', reason: the transaction is committed", this.config.familyName, BetaStmUtils.toDebugString(ref)));
            }
        }
        throw new IllegalStateException();
    }

    public final RuntimeException abortOnOpenForConstructionWhileEvaluatingCommute(BetaTransactionalObject ref) {
        this.abort();
        return new IllegalTransactionStateException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: a commuting function is being evaluated", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final RuntimeException abortOnCommuteWhileEvaluatingCommute(BetaTransactionalObject ref) {
        this.abort();
        return new IllegalTransactionStateException(String.format("[%s] Failed to execute BetaTransaction.commute '%s', reason: a commuting function is being evaluated", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final IllegalArgumentException abortOpenForConstructionWithBadReference(BetaTransactionalObject ref) {
        this.abort();
        return new IllegalArgumentException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: the object is not new and has previous commits", this.config.familyName, BetaStmUtils.toDebugString(ref)));
    }

    public final ReadonlyException abortOpenForWriteWhenReadonly(BetaTransactionalObject object) {
        this.abort();
        return new ReadonlyException(String.format("[%s] Failed to execute BetaTransaction.openForWrite '%s', reason: the transaction is readonly", this.config.familyName, BetaStmUtils.toDebugString(object)));
    }

    public final NullPointerException abortOpenForWriteWhenNullReference() {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction BetaTransaction.openForWrite 'null', reason: the reference is null", this.config.familyName));
    }

    public final NullPointerException abortOpenForConstructionWhenNullReference() {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction 'null', reason the reference is null", this.config.familyName));
    }

    public final NullPointerException abortTryLockWhenNullReference(TransactionalObject object) {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.tryLock 'null', reason: the reference is null", this.config.familyName));
    }

    public final NullPointerException abortCommuteWhenNullReference(Function function) {
        this.abort();
        return new NullPointerException(String.format("[%s] Failed to execute BetaTransaction.commute 'null' and function '%s', reason: the reference is null", this.config.familyName, function));
    }

    public final ReadonlyException abortOpenForConstructionWhenReadonly(BetaTransactionalObject object) {
        this.abort();
        return new ReadonlyException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: the transaction is readonly", this.config.familyName, BetaStmUtils.toDebugString(object)));
    }

    public final ReadonlyException abortCommuteWhenReadonly(BetaTransactionalObject object, Function function) {
        this.abort();
        return new ReadonlyException(String.format("[%s] Failed to execute BetaTransaction.commute '%s' with function '%s', reason: the transaction is readonly", this.config.familyName, BetaStmUtils.toDebugString(object), function));
    }

    public final IllegalTransactionStateException abortEnsureWrites() {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.ensureWrites, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.ensureWrites, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.ensureWrites, reason: the transaction is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTransactionStateException abortTryLock(BetaTransactionalObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.tryLock '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.tryLock '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.tryLock '%s', reason: the transaction is committed", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTransactionStateException abortOpenForRead(BetaTransactionalObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForRead '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForRead '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForRead '%s', reason: the transaction is committed", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTransactionStateException abortOpenForWrite(BetaTransactionalObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForWrite '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForWrite '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForWrite '%s', reason: the transaction is committed", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTransactionStateException abortOpenForConstruction(BetaTransactionalObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.openForConstruction '%s', reason: the transaction is committed", this.config.familyName, BetaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTransactionStateException abortCommute(BetaTransactionalObject object, Function function) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTransactionException(String.format("[%s] Failed to execute BetaTransaction.commute '%s' with reference '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object), function));
            }
            case 3: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.commute '%s' with reference '%s', reason: the transaction is aborted", this.config.familyName, BetaStmUtils.toDebugString(object), function));
            }
            case 4: {
                return new DeadTransactionException(String.format("[%s] Failed to execute BetaTransaction.commute '%s' with reference '%s', reason: the transaction is prepared", this.config.familyName, BetaStmUtils.toDebugString(object), function));
            }
        }
        throw new IllegalStateException();
    }

    public abstract void copyForSpeculativeFailure(BetaTransaction var1);

    public abstract boolean softReset();

    public abstract void hardReset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void awaitUpdate(DefaultRetryLatch latch) {
        long lockEra = latch.getEra();
        try {
            if (this.config.timeoutNs == Long.MAX_VALUE) {
                if (this.config.isInterruptible()) {
                    latch.await(lockEra, this.config.familyName);
                } else {
                    latch.awaitUninterruptible(lockEra);
                }
            } else {
                this.remainingTimeoutNs = this.config.isInterruptible() ? latch.awaitNanos(lockEra, this.remainingTimeoutNs, this.config.familyName) : latch.awaitNanosUninterruptible(lockEra, this.remainingTimeoutNs);
                if (this.remainingTimeoutNs < 0L) {
                    throw new RetryTimeoutException(String.format("[%s] Transaction has timed with a total timeout of %s ns", this.config.getFamilyName(), this.config.getTimeoutNs()));
                }
            }
        }
        finally {
            this.pool.putDefaultRetryLatch(latch);
        }
    }

    public abstract void startEitherBranch();

    public abstract void endEitherBranch();

    public abstract void startOrElseBranch();

    public abstract void init(BetaTransactionConfiguration var1);

    public abstract boolean tryLock(BetaTransactionalObject var1, int var2);

    public abstract <E> E read(BetaRef<E> var1);

    public abstract <E> BetaRefTranlocal<E> open(BetaRef<E> var1);

    public abstract <E> BetaRefTranlocal<E> openForRead(BetaRef<E> var1, int var2);

    public abstract <E> BetaRefTranlocal<E> openForWrite(BetaRef<E> var1, int var2);

    public abstract <E> BetaRefTranlocal<E> openForConstruction(BetaRef<E> var1);

    public abstract <E> void commute(BetaRef<E> var1, Function<E> var2);

    public abstract int read(BetaIntRef var1);

    public abstract BetaIntRefTranlocal open(BetaIntRef var1);

    public abstract BetaIntRefTranlocal openForRead(BetaIntRef var1, int var2);

    public abstract BetaIntRefTranlocal openForWrite(BetaIntRef var1, int var2);

    public abstract BetaIntRefTranlocal openForConstruction(BetaIntRef var1);

    public abstract void commute(BetaIntRef var1, IntFunction var2);

    public abstract boolean read(BetaBooleanRef var1);

    public abstract BetaBooleanRefTranlocal open(BetaBooleanRef var1);

    public abstract BetaBooleanRefTranlocal openForRead(BetaBooleanRef var1, int var2);

    public abstract BetaBooleanRefTranlocal openForWrite(BetaBooleanRef var1, int var2);

    public abstract BetaBooleanRefTranlocal openForConstruction(BetaBooleanRef var1);

    public abstract void commute(BetaBooleanRef var1, BooleanFunction var2);

    public abstract double read(BetaDoubleRef var1);

    public abstract BetaDoubleRefTranlocal open(BetaDoubleRef var1);

    public abstract BetaDoubleRefTranlocal openForRead(BetaDoubleRef var1, int var2);

    public abstract BetaDoubleRefTranlocal openForWrite(BetaDoubleRef var1, int var2);

    public abstract BetaDoubleRefTranlocal openForConstruction(BetaDoubleRef var1);

    public abstract void commute(BetaDoubleRef var1, DoubleFunction var2);

    public abstract long read(BetaLongRef var1);

    public abstract BetaLongRefTranlocal open(BetaLongRef var1);

    public abstract BetaLongRefTranlocal openForRead(BetaLongRef var1, int var2);

    public abstract BetaLongRefTranlocal openForWrite(BetaLongRef var1, int var2);

    public abstract BetaLongRefTranlocal openForConstruction(BetaLongRef var1);

    public abstract void commute(BetaLongRef var1, LongFunction var2);

    public abstract BetaTranlocal open(BetaTransactionalObject var1);

    public abstract BetaTranlocal openForRead(BetaTransactionalObject var1, int var2);

    public abstract BetaTranlocal openForWrite(BetaTransactionalObject var1, int var2);

    public abstract BetaTranlocal openForConstruction(BetaTransactionalObject var1);

    public abstract void commute(BetaTransactionalObject var1, Function var2);
}

