/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.beta.transactions;

public final class SpeculativeBetaConfiguration {
    public final boolean areListenersRequired;
    public final int minimalLength;
    public final boolean isCommuteRequired;
    public final boolean isOrelseRequired;
    public final boolean isFat;

    public SpeculativeBetaConfiguration(boolean fat) {
        this(fat, false, false, 1, false);
    }

    public SpeculativeBetaConfiguration(boolean fat, boolean areListenersRequired, boolean commuteRequired, int minimalLength, boolean orelseRequired) {
        if (minimalLength < 0) {
            throw new IllegalArgumentException();
        }
        this.areListenersRequired = areListenersRequired;
        this.minimalLength = minimalLength;
        this.isCommuteRequired = commuteRequired;
        this.isOrelseRequired = orelseRequired;
        this.isFat = fat;
    }

    public SpeculativeBetaConfiguration createWithMinimalLength(int newMinimalLength) {
        if (newMinimalLength < 0) {
            throw new IllegalArgumentException();
        }
        if (this.minimalLength >= newMinimalLength) {
            return this;
        }
        return new SpeculativeBetaConfiguration(this.isFat, this.areListenersRequired, this.isCommuteRequired, newMinimalLength, this.isOrelseRequired);
    }

    public SpeculativeBetaConfiguration createWithListenersRequired() {
        if (this.areListenersRequired) {
            return this;
        }
        return new SpeculativeBetaConfiguration(true, true, this.isCommuteRequired, this.minimalLength, this.isOrelseRequired);
    }

    public SpeculativeBetaConfiguration createWithOrElseRequired() {
        if (this.isOrelseRequired) {
            return this;
        }
        return new SpeculativeBetaConfiguration(true, this.areListenersRequired, this.areListenersRequired, this.minimalLength, true);
    }

    public SpeculativeBetaConfiguration createWithCommuteRequired() {
        if (this.isCommuteRequired) {
            return this;
        }
        return new SpeculativeBetaConfiguration(true, this.areListenersRequired, true, this.minimalLength, this.isOrelseRequired);
    }

    public String toString() {
        return "SpeculativeBetaConfiguration{areListenersRequired=" + this.areListenersRequired + ", isCommuteRequired=" + this.isCommuteRequired + ", isOrelseRequired=" + this.isOrelseRequired + ", minimalLength=" + this.minimalLength + ", isFat=" + this.isFat + '}';
    }
}

