/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.request;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.drivers.embedded.response.GraphModelResponse;
import org.neo4j.ogm.drivers.embedded.response.GraphRowModelResponse;
import org.neo4j.ogm.drivers.embedded.response.RestModelResponse;
import org.neo4j.ogm.drivers.embedded.response.RowModelResponse;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedRequest
implements Request {
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private final GraphDatabaseService graphDatabaseService;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedRequest.class);
    private final TransactionManager transactionManager;
    private final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    public EmbeddedRequest(GraphDatabaseService graphDatabaseService, TransactionManager transactionManager) {
        this.graphDatabaseService = graphDatabaseService;
        this.transactionManager = transactionManager;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(DefaultRequest query) {
        final ArrayList<RowModel> rowmodels = new ArrayList<RowModel>();
        String[] columns = null;
        for (Statement statement : query.getStatements()) {
            RowModel model;
            Result result = this.executeRequest(statement);
            if (columns == null) {
                columns = result.columns().toArray(new String[result.columns().size()]);
            }
            RowModelResponse rowModelResponse = new RowModelResponse(result, this.transactionManager);
            while ((model = rowModelResponse.next()) != null) {
                rowmodels.add(model);
            }
            result.close();
        }
        final String[] finalColumns = columns;
        return new Response<RowModel>(){
            int currentRow = 0;

            public RowModel next() {
                if (this.currentRow < rowmodels.size()) {
                    return (RowModel)rowmodels.get(this.currentRow++);
                }
                return null;
            }

            public void close() {
                if (EmbeddedRequest.this.transactionManager.getCurrentTransaction() != null) {
                    EmbeddedRequest.this.logger.debug("Response closed: {}", (Object)this);
                }
            }

            public String[] columns() {
                return finalColumns;
            }
        };
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphRowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RestModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    private Result executeRequest(Statement statement) {
        try {
            String cypher = statement.getStatement();
            Map parameterMap = (Map)mapper.convertValue((Object)statement.getParameters(), this.MAP_TYPE_REF);
            this.logger.info("Request: {} with params {}", (Object)cypher, (Object)parameterMap);
            return this.graphDatabaseService.execute(cypher, parameterMap);
        }
        catch (QueryExecutionException qee) {
            throw new CypherException("Error executing Cypher", (Throwable)qee, qee.getStatusCode(), qee.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

