/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.push.sdk;

import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCode {
    private int value;
    private String description;
    private static HashMap<Integer, ErrorCode> intErrorCodeMap = new HashMap();
    public static ErrorCode UnknowError = ErrorCode.valueOf((Integer)-1, "\u672a\u77e5\u9519\u8bef");
    public static ErrorCode Success = ErrorCode.valueOf((Integer)0, "\u6210\u529f");
    public static ErrorCode NotBlank = ErrorCode.valueOf((Integer)100, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    public static ErrorCode SystemError = ErrorCode.valueOf((Integer)10001, "\u7cfb\u7edf\u9519\u8bef");
    public static ErrorCode ServiceUnavailable = ErrorCode.valueOf((Integer)10002, "\u670d\u52a1\u6682\u505c");
    public static ErrorCode RemoteServiceError = ErrorCode.valueOf((Integer)10003, "\u8fdc\u7a0b\u670d\u52a1\u9519\u8bef");
    public static ErrorCode IpLimit = ErrorCode.valueOf((Integer)10004, "IP\u9650\u5236\u4e0d\u80fd\u8bf7\u6c42\u8be5\u8d44\u6e90");
    public static ErrorCode PermissionDenied = ErrorCode.valueOf((Integer)10005, "\u8be5\u8d44\u6e90\u9700\u8981appkey\u62e5\u6709\u6388\u6743");
    public static ErrorCode MissAppKey = ErrorCode.valueOf((Integer)10006, "\u7f3a\u5c11appkey\u53c2\u6570");
    public static ErrorCode UnsupportMimeType = ErrorCode.valueOf((Integer)10007, "\u4e0d\u652f\u6301\u7684 mime type");
    public static ErrorCode ParameterError = ErrorCode.valueOf((Integer)10008, "\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u53c2\u8003API\u6587\u6863");
    public static ErrorCode SystemIsBusy = ErrorCode.valueOf((Integer)10009, "\u7cfb\u7edf\u7e41\u5fd9");
    public static ErrorCode JobExpired = ErrorCode.valueOf((Integer)10010, "\u4efb\u52a1\u8d85\u65f6");
    public static ErrorCode RpcError = ErrorCode.valueOf((Integer)10011, "RPC\u9519\u8bef");
    public static ErrorCode IllegalRequest = ErrorCode.valueOf((Integer)10012, "\u975e\u6cd5\u8bf7\u6c42");
    public static ErrorCode InvalidUser = ErrorCode.valueOf((Integer)10013, "\u4e0d\u5408\u6cd5\u7684\u7528\u6237");
    public static ErrorCode InsufficientPermissions = ErrorCode.valueOf((Integer)10014, "\u5e94\u7528\u7684\u63a5\u53e3\u8bbf\u95ee\u6743\u9650\u53d7\u9650");
    public static ErrorCode MissRequiredParameter = ErrorCode.valueOf((Integer)10016, "\u7f3a\u5931\u5fc5\u9009\u53c2\u6570");
    public static ErrorCode InvalidParameterValue = ErrorCode.valueOf((Integer)10017, "\u53c2\u6570\u503c\u975e\u6cd5");
    public static ErrorCode RequestBodyLengthTooLong = ErrorCode.valueOf((Integer)10018, "\u8bf7\u6c42\u957f\u5ea6\u8d85\u8fc7\u9650\u5236");
    public static ErrorCode RequestApiNotFound = ErrorCode.valueOf((Integer)10020, "\u63a5\u53e3\u4e0d\u5b58\u5728");
    public static ErrorCode HttpMethodUnsupport = ErrorCode.valueOf((Integer)10021, "\u8bf7\u6c42\u7684HTTP\u65b9\u6cd5\u4e0d\u652f\u6301");
    public static ErrorCode IpRequestExceedQuota = ErrorCode.valueOf((Integer)10022, "IP\u8bf7\u6c42\u9891\u6b21\u8d85\u8fc7\u4e0a\u9650");
    public static ErrorCode UserRequestExceedQuota = ErrorCode.valueOf((Integer)10023, "\u7528\u6237\u8bf7\u6c42\u9891\u6b21\u8d85\u8fc7\u4e0a\u9650");
    public static ErrorCode UserRequestApiExceedQuota = ErrorCode.valueOf((Integer)10024, "\u7528\u6237\u8bf7\u6c42\u7279\u6b8a\u63a5\u53e3\u9891\u6b21\u8d85\u8fc7\u4e0a\u9650");
    public static ErrorCode InvalidCallbackUrl = ErrorCode.valueOf((Integer)10025, "Callback\u8fde\u63a5\u4e0d\u5408\u6cd5");
    public static ErrorCode ApplicationInBlacklist = ErrorCode.valueOf((Integer)10026, "\u5e94\u7528\u88ab\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u4e0d\u80fd\u8c03\u7528API");
    public static ErrorCode ApplicationApiCallExceedQuota = ErrorCode.valueOf((Integer)10027, "\u5e94\u7528\u7684API\u8c03\u7528\u592a\u9891\u7e41");
    public static ErrorCode ApplicationTotalApiCallExceedQuota = ErrorCode.valueOf((Integer)10028, "\u5e94\u7528API\u8c03\u7528\u603b\u6570\u592a\u9891\u7e41");
    public static ErrorCode InvalidDevice = ErrorCode.valueOf((Integer)10029, "\u4e0d\u5408\u6cd5\u7684\u8bbe\u5907");
    public static ErrorCode ApplicationIllegal = ErrorCode.valueOf((Integer)22000, "\u975e\u6cd5\u5e94\u7528");
    public static ErrorCode ApplicationNotExists = ErrorCode.valueOf((Integer)22001, "\u5e94\u7528\u4e0d\u5b58\u5728");
    public static ErrorCode ApplicationRevoked = ErrorCode.valueOf((Integer)22002, "\u5e94\u7528\u5df2\u7ecf\u64a4\u9500");
    public static ErrorCode UpdateApplicationInfoFail = ErrorCode.valueOf((Integer)22003, "\u66f4\u65b0\u5e94\u7528\u7a0b\u5e8f\u5931\u8d25");
    public static ErrorCode MissApplicationInfo = ErrorCode.valueOf((Integer)22004, "\u7f3a\u5c11\u5e94\u7528\u7a0b\u5e8f\u4fe1\u606f");
    public static ErrorCode InvalidApplicationName = ErrorCode.valueOf((Integer)22005, "\u5e94\u7528\u7a0b\u5e8f\u540d\u5b57\u4e0d\u5408\u6cd5");
    public static ErrorCode InvalidApplicationId = ErrorCode.valueOf((Integer)22006, "\u5e94\u7528\u7a0b\u5e8fId\u4e0d\u5408\u6cd5");
    public static ErrorCode InvalidApplicationKey = ErrorCode.valueOf((Integer)22007, "\u5e94\u7528\u7a0b\u5e8fKey\u4e0d\u5408\u6cd5");
    public static ErrorCode InvalidApplicationSecret = ErrorCode.valueOf((Integer)22008, "\u5e94\u7528\u7a0b\u5e8fSecret\u4e0d\u5408\u6cd5");
    public static ErrorCode InvalidApplicationDescription = ErrorCode.valueOf((Integer)22020, "\u5e94\u7528\u7a0b\u5e8f\u63cf\u8ff0\u4fe1\u606f\u4e0d\u5408\u6cd5");
    public static ErrorCode UserNotAuthorizeApplication = ErrorCode.valueOf((Integer)22021, "\u7528\u6237\u6ca1\u6709\u6388\u6743\u7ed9\u5e94\u7528\u7a0b\u5e8f");
    public static ErrorCode InvalidPackageName = ErrorCode.valueOf((Integer)22022, "\u5e94\u7528\u7a0b\u5e8fpackage name\u4e0d\u5408\u6cd5");
    public static ErrorCode InvalidApplicationNotificationFormat = ErrorCode.valueOf((Integer)22100, "\u5e94\u7528\u901a\u77e5\u6570\u636e\u683c\u5f0f\u4e0d\u5408\u6cd5");
    public static ErrorCode TooManyApplicationNotification = ErrorCode.valueOf((Integer)22101, "\u592a\u591a\u5e94\u7528\u901a\u77e5\u6d88\u606f");
    public static ErrorCode SendApplicationNotificationFail = ErrorCode.valueOf((Integer)22102, "\u53d1\u9001\u5e94\u7528\u901a\u77e5\u6d88\u606f\u5931\u8d25");
    public static ErrorCode InvalidNotifyId = ErrorCode.valueOf((Integer)22103, "\u5e94\u7528\u901a\u77e5ID\u4e0d\u5408\u6cd5");

    public static Collection<ErrorCode> getAllErrorCodes() {
        return intErrorCodeMap.values();
    }

    private ErrorCode(int value) {
        this.value = value;
    }

    private ErrorCode(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public String toString() {
        return super.toString();
    }

    public String getFullDescription() {
        return this.getName() + "," + this.value + "," + this.description;
    }

    public String getName() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static ErrorCode valueOf(int value) {
        return intErrorCodeMap.get(value);
    }

    public static ErrorCode valueOf(int value, ErrorCode defaultIfMissing) {
        ErrorCode code = intErrorCodeMap.get(value);
        if (code == null) {
            return defaultIfMissing;
        }
        return code;
    }

    public static ErrorCode valueOf(Integer code, String reason) {
        ErrorCode result = intErrorCodeMap.get(code);
        if (result == null) {
            result = new ErrorCode(code, reason);
            intErrorCodeMap.put(code, result);
        }
        return result;
    }
}

