/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBase {
    protected static final String UTF8 = "UTF-8";
    protected static final int BACKOFF_INITIAL_DELAY = 1000;
    protected static final int MAX_BACKOFF_DELAY = 1024000;
    protected final Random random = new Random();
    protected final String security;
    protected static final Logger logger = Logger.getLogger((String)HttpBase.class.getName());

    public HttpBase(String security) {
        this.security = security;
    }

    protected HttpURLConnection doPost(String url, String body) throws IOException {
        return this.doPost(url, "application/x-www-form-urlencoded;charset=UTF-8", body);
    }

    protected HttpURLConnection doGet(String url, String parameter) throws IOException {
        return this.doGet(url, "application/x-www-form-urlencoded;charset=UTF-8", parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection doPost(String url, String contentType, String body) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!url.startsWith("https://")) {
            logger.warn((Object)("URL does not use https: " + url));
        }
        logger.info((Object)("Sending post to " + url));
        logger.debug((Object)("post body: " + body));
        byte[] bytes = body.getBytes();
        HttpURLConnection conn = this.getConnection(url);
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.security);
        conn.setRequestProperty("X-PUSH-SDK-VERSION", "2015.04.23");
        this.prepareConnection(conn);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            HttpBase.close(out);
        }
        return conn;
    }

    protected HttpURLConnection doGet(String url, String contentType, String parameter) throws IOException {
        if (url == null || parameter == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!url.startsWith("https://")) {
            logger.warn((Object)("URL does not use https: " + url));
        }
        logger.info((Object)("Sending get to " + url));
        logger.debug((Object)("get parameter: " + parameter));
        String fullUrl = url + "?" + parameter;
        HttpURLConnection conn = this.getConnection(fullUrl);
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.security);
        this.prepareConnection(conn);
        conn.getInputStream();
        return conn;
    }

    protected void prepareConnection(HttpURLConnection conn) {
    }

    protected static StringBuilder newBody(String name, String value) {
        return new StringBuilder(HttpBase.nonNull(name)).append('=').append(HttpBase.nonNull(value));
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.debug((Object)"IOException closing stream", (Throwable)e);
            }
        }
    }

    protected static StringBuilder newBodyWithArrayParameters(String name, List<String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == 0) {
                sb.append(HttpBase.nonNull(name)).append("=").append(URLEncoder.encode(HttpBase.nonNull(parameters.get(i)), UTF8));
                continue;
            }
            HttpBase.nonNull(sb).append('&').append(HttpBase.nonNull(name)).append('=').append(URLEncoder.encode(HttpBase.nonNull(parameters.get(i)), UTF8));
        }
        if (parameters.size() == 0) {
            sb.append(name).append("=").append("");
        }
        return sb;
    }

    protected static void addParameter(StringBuilder body, String name, String value) {
        HttpBase.nonNull(body).append('&').append(HttpBase.nonNull(name)).append('=').append(HttpBase.nonNull(value));
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    protected static String getAndClose(InputStream stream) throws IOException {
        try {
            String string = HttpBase.getString(stream);
            return string;
        }
        finally {
            if (stream != null) {
                HttpBase.close(stream);
            }
        }
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

