/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.push.sdk.ErrorCode;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.TargetedMessage;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sender
extends HttpBase {
    public static final int BROADCAST_TOPIC_MAX = 5;
    public static final String TOPIC_SPLITTER = ";$;";

    public Sender(String security) {
        super(Sender.nonNull(security));
    }

    public Result send(Message message, String registrationId, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to send message " + message + " to regIds " + registrationId));
            }
            boolean bl = tryAgain = (result = this.sendNoRetry(message, registrationId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    public Result broadcast(Message message, String topic, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to broadcast message " + message + " to topic: " + topic));
            }
            boolean bl = tryAgain = (result = this.broadcastNoRetry(message, topic)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not broadcast message after " + attempt + " attempts");
        }
        return result;
    }

    public Result multiTopicBroadcast(Message message, List<String> topics, BROADCAST_TOPIC_OP topicOp, int retries) throws IOException, ParseException, IllegalArgumentException {
        Result result;
        if (topics == null || topics.size() <= 0 || topics.size() > 5) {
            throw new IllegalArgumentException("topics size invalid");
        }
        if (topics.size() == 1) {
            return this.broadcast(message, topics.get(0), retries);
        }
        int attempt = 0;
        int backoff = 1000;
        boolean tryAgain = false;
        do {
            logger.info((Object)("Attempt #" + ++attempt + " to broadcast message " + message + " to topic: " + topics.get(0) + " op=" + topicOp.toString()));
            result = this.multiTopicBroadcastNoRetry(message, topics, topicOp);
            boolean bl = tryAgain = result == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not broadcast message after " + attempt + " attempts");
        }
        return result;
    }

    public Result broadcastAll(Message message, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to broadcast message " + message + " to all"));
            }
            boolean bl = tryAgain = (result = this.broadcastAllNoRetry(message)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not broadcast message to all after " + attempt + " attempts");
        }
        return result;
    }

    public Result sendToAlias(Message message, String alias, int retries) throws IOException, ParseException {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(alias);
        return this.sendToAlias(message, aliases, retries);
    }

    public Result sendToAlias(Message message, List<String> aliases, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to send message " + message + " to alias " + aliases));
            }
            boolean bl = tryAgain = (result = this.sendToAliasNoRetry(message, aliases)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    public Result sendToAliasNoRetry(Message message, List<String> aliases) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("alias", aliases);
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_ALIAS, message, body);
    }

    public Result sendToUserAccount(Message message, String userAccount, int retries) throws IOException, ParseException {
        ArrayList<String> userAccounts = new ArrayList<String>();
        userAccounts.add(userAccount);
        return this.sendToUserAccount(message, userAccounts, retries);
    }

    public Result sendToUserAccount(Message message, List<String> userAccounts, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to send message " + message + " to user account " + userAccounts));
            }
            boolean bl = tryAgain = (result = this.sendToUserAccountNoRetry(message, userAccounts)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    public Result sendToUserAccountNoRetry(Message message, List<String> userAccounts) throws IOException, ParseException {
        StringBuilder body = Sender.newBodyWithArrayParameters("user_account", userAccounts);
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_USER_ACCOUNT, message, body);
    }

    public Result sendNoRetry(Message message, String registrationId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("registration_id", URLEncoder.encode(registrationId, "UTF-8"));
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_REGID, message, body);
    }

    public Result broadcastNoRetry(Message message, String topic) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("topic", URLEncoder.encode(topic, "UTF-8"));
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_TOPIC, message, body);
    }

    public Result multiTopicBroadcastNoRetry(Message message, List<String> topics, BROADCAST_TOPIC_OP topicOp) throws IOException, ParseException, IllegalArgumentException {
        if (topics == null || topics.size() <= 0 || topics.size() > 5) {
            throw new IllegalArgumentException("topics size invalid");
        }
        if (topics.size() == 1) {
            return this.broadcastNoRetry(message, topics.get(0));
        }
        StringBuilder body = Sender.newBody("topic_op", topicOp.toString());
        StringBuilder topicsStr = new StringBuilder();
        for (String topic : topics) {
            if (topicsStr.length() != 0) {
                topicsStr.append(TOPIC_SPLITTER);
            }
            topicsStr.append(topic);
        }
        Sender.addParameter(body, "topics", URLEncoder.encode(topicsStr.toString(), "UTF-8"));
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_MULTI_TOPIC, message, body);
    }

    public Result broadcastAllNoRetry(Message message) throws IOException, ParseException {
        StringBuilder body = new StringBuilder("");
        return this.sendMessageNoRetry(Constants.XMPUSH_SEND_ENDPOINT_ALL, message, body);
    }

    private Result sendMessageNoRetry(String url, Message message, StringBuilder target) throws IOException, ParseException {
        String bodyStr;
        Map<String, String> extraInfo;
        Long timeToLive;
        StringBuilder body = new StringBuilder(target);
        if (!XMStringUtils.isEmpty(message.getCollapseKey())) {
            Sender.addParameter(body, "collapse_key", URLEncoder.encode(message.getCollapseKey(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getRestrictedPackageName())) {
            Sender.addParameter(body, "restricted_package_name", URLEncoder.encode(message.getRestrictedPackageName(), "UTF-8"));
        }
        if ((timeToLive = message.getTimeToLive()) != null) {
            Sender.addParameter(body, "time_to_live", Long.toString(timeToLive));
        }
        if (!XMStringUtils.isEmpty(message.getPayload())) {
            Sender.addParameter(body, "payload", URLEncoder.encode(message.getPayload(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getTitle())) {
            Sender.addParameter(body, "title", URLEncoder.encode(message.getTitle(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(message.getDescription())) {
            Sender.addParameter(body, "description", URLEncoder.encode(message.getDescription(), "UTF-8"));
        }
        if (message.getNotifyType() != null) {
            Sender.addParameter(body, "notify_type", Integer.toString(message.getNotifyType()));
        }
        if (message.getPassThrough() != null) {
            Sender.addParameter(body, "pass_through", Integer.toString(message.getPassThrough()));
        }
        if (message.getNotifyId() != null) {
            Sender.addParameter(body, "notify_id", Integer.toString(message.getNotifyId()));
        }
        if (message.getTimeToSend() != null) {
            Sender.addParameter(body, "time_to_send", Long.toString(message.getTimeToSend()));
        }
        if ((extraInfo = message.getExtra()) != null && !extraInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : extraInfo.entrySet()) {
                Sender.addParameter(body, URLEncoder.encode("extra." + entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        if (!(bodyStr = body.toString()).isEmpty() && bodyStr.charAt(0) == '&') {
            bodyStr = body.toString().substring(1);
        }
        return this.sendMessage(url, bodyStr);
    }

    private Result execScheduleJobNoRetry(String url, StringBuilder target) throws IOException, ParseException {
        return this.sendMessage(url, target.toString());
    }

    public Result send(Message message, List<String> regIds, int retries) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder(regIds.get(0));
        for (int i = 1; i < regIds.size(); ++i) {
            sb.append(",").append(regIds.get(i));
        }
        return this.send(message, sb.toString(), retries);
    }

    public Result send(List<TargetedMessage> messages, int retries) throws IOException, ParseException {
        return this.send(messages, retries, 0L);
    }

    public Result send(List<TargetedMessage> messages, int retries, long timeToSend) throws IOException, ParseException {
        boolean tryAgain;
        if (messages.isEmpty()) {
            logger.warn((Object)"send empty message. return");
            return new Result.Builder().errorCode(ErrorCode.Success).build();
        }
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        String url = messages.get(0).getTargetType() == 2 ? Constants.XMPUSH_SEND_ENDPOINT_MULTI_MESSAGE_ALIAS : (messages.get(0).getTargetType() == 3 ? Constants.XMPUSH_SEND_ENDPOINT_MULTI_MESSAGE_USER_ACCOUNT : Constants.XMPUSH_SEND_ENDPOINT_MULTI_MESSAGE_REGID);
        StringBuilder body = Sender.newBody("messages", URLEncoder.encode(this.toString(messages), "UTF-8"));
        Sender.addParameter(body, "time_to_send", Long.toString(timeToSend));
        String message = body.toString();
        do {
            ++attempt;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempt #" + attempt + " to send messages " + messages.size()));
            }
            boolean bl = tryAgain = (result = this.sendMessage(url, message)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not broadcast message after " + attempt + " attempts");
        }
        return result;
    }

    public Result deleteScheduleJob(String jobId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("job_id", URLEncoder.encode(jobId, "UTF-8"));
        return this.execScheduleJobNoRetry(Constants.XMPUSH_SEND_ENDPOINT_DELETE_SCHEDULE_JOB, body);
    }

    public Result checkScheduleJobExist(String jobId) throws IOException, ParseException {
        StringBuilder body = Sender.newBody("job_id", URLEncoder.encode(jobId, "UTF-8"));
        return this.execScheduleJobNoRetry(Constants.XMPUSH_SEND_ENDPOINT_CHECK_SCHEDULE_JOB_EXIST, body);
    }

    protected Result sendMessage(String url, String message) throws IOException, ParseException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.info((Object)("post to: " + url));
            conn = this.doPost(url, message);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException posting to XmPush", (Throwable)e);
            return null;
        }
        if (status / 100 == 5) {
            logger.info((Object)("XmPush service is unavailable (status " + status + ")"));
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Sender.getAndClose(conn.getErrorStream());
                logger.debug((Object)("Plain post error response: " + responseBody2));
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.warn((Object)"Exception reading response: ", (Throwable)e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Sender.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn((Object)"Exception reading response: ", (Throwable)e);
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.warn((Object)"Exception parsing response: ", (Throwable)e);
            throw new IOException("Invalid response from XmPush: " + responseBody);
        }
    }

    private String toString(List<TargetedMessage> messages) {
        JSONArray jsonArray = new JSONArray();
        for (TargetedMessage message : messages) {
            JSONObject jsonMessage = new JSONObject();
            JSONObject msg = this.toJson(message.getMessage());
            Sender.tryAddJson(jsonMessage, "target", message.getTarget());
            Sender.tryAddJson(jsonMessage, "message", msg);
            jsonArray.add((Object)jsonMessage);
        }
        return jsonArray.toString();
    }

    private JSONObject toJson(Message msg) {
        JSONObject json = new JSONObject();
        Sender.tryAddJson(json, "payload", msg.getPayload());
        Sender.tryAddJson(json, "title", msg.getTitle());
        Sender.tryAddJson(json, "description", msg.getDescription());
        Sender.tryAddJson(json, "notify_type", msg.getNotifyType());
        Sender.tryAddJson(json, "notify_id", msg.getNotifyId());
        Sender.tryAddJson(json, "pass_through", msg.getPassThrough());
        Sender.tryAddJson(json, "restricted_package_name", msg.getRestrictedPackageName());
        Sender.tryAddJson(json, "time_to_live", msg.getTimeToLive());
        Sender.tryAddJson(json, "collapse_key", msg.getCollapseKey());
        Map<String, String> extraInfo = msg.getExtra();
        if (extraInfo != null && !extraInfo.isEmpty()) {
            JSONObject extraJson = new JSONObject();
            for (Map.Entry<String, String> entry : extraInfo.entrySet()) {
                Sender.tryAddJson(extraJson, entry.getKey(), entry.getValue());
            }
            Sender.tryAddJson(json, "extra", extraJson);
        }
        return json;
    }

    protected static void tryAddJson(JSONObject json, String parameterName, Object value) {
        if (!XMStringUtils.isEmpty(parameterName) && value != null) {
            json.put((Object)parameterName, value);
        }
    }

    protected static final Map<String, String> newKeyValues(String key, String value) {
        HashMap<String, String> keyValues = new HashMap<String, String>(1);
        keyValues.put(Sender.nonNull(key), Sender.nonNull(value));
        return keyValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BROADCAST_TOPIC_OP {
        UNION,
        INTERSECTION,
        EXCEPT;

    }
}

