/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation
extends HttpBase {
    protected static final Logger logger = Logger.getLogger(Validation.class.getName());

    public Validation(String security) {
        super(security);
    }

    public String validateRegistrationIds(List<String> regIds, int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to validate regids.");
            }
            boolean bl = tryAgain = (result = this.validateRegistrationIdsNoRetry(regIds)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not get expired regids after " + attempt + " attempts");
        }
        return result;
    }

    public String validateRegistrationIdsNoRetry(List<String> regIds) throws UnsupportedEncodingException, InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = Validation.newBodyWithArrayParameters("registration_ids", regIds);
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XMPUSH_VALIDATE_REGID);
            conn = this.doPost(Constants.XMPUSH_VALIDATE_REGID, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOException while validating registration ids", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Validation.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Validation.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        return responseBody;
    }
}

