/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.nutz.castor.Castors;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.Segments;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.FileVisitor;
import org.nutz.lang.util.MultiLineProperties;
import org.nutz.web.jsp.RsScaner;

public class WebConfig {
    public static String JUNIT_DB_SUFFIX = "";
    private static final String APP_ROOT = "app-root";
    private static final String APP_PORT = "app-port";
    private static final String APP_RS = "app-rs";
    private static final String APP_CLASSPATH = "app-classpath";
    private static final String ADMIN_PORT = "admin-port";
    private static final String MACRO_INCLUDE = "$include";
    protected PropertiesProxy pp = new PropertiesProxy();

    public String getAppRoot() {
        return this.pp.get(APP_ROOT);
    }

    public int getAppPort() {
        return this.pp.getInt(APP_PORT);
    }

    public String getAppRs() {
        return this.pp.get(APP_RS);
    }

    public String getAppClasspath() {
        return this.pp.get(APP_CLASSPATH);
    }

    public int getAdminPort() {
        return this.pp.getInt(ADMIN_PORT, this.pp.getInt(APP_PORT) + 1);
    }

    public void set(String key, String val) {
        this.pp.put(key, val);
    }

    public String get(String key) {
        return this.pp.get(key);
    }

    public String check(String key) {
        String val = this.get(key);
        if (null == val) {
            throw Lang.makeThrow((String)"Ioc.$conf expect property '%s'", (Object[])new Object[]{key});
        }
        return val;
    }

    public String get(String key, String defaultValue) {
        return this.pp.get(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean dfval) {
        String val = this.pp.get(key);
        if (Strings.isBlank((CharSequence)val)) {
            return dfval;
        }
        return (Boolean)Castors.me().castTo((Object)val, Boolean.class);
    }

    public int getInt(String key) {
        return this.pp.getInt(key);
    }

    public int getInt(String key, int dfval) {
        return this.pp.getInt(key, dfval);
    }

    public long getLong(String key) {
        return this.pp.getLong(key);
    }

    public long getLong(String key, long dfval) {
        return this.pp.getLong(key, dfval);
    }

    public String getTrim(String key) {
        return this.pp.getTrim(key);
    }

    public String getTrim(String key, String defaultValue) {
        return this.pp.getTrim(key, defaultValue);
    }

    public List<String> getKeys() {
        return this.pp.getKeys();
    }

    public RsScaner getScaner() {
        RsScaner jrs = new RsScaner();
        jrs.setRs(this.check(APP_RS));
        jrs.setRsHome(this.check("app-rs-home"));
        jrs.setSegCss(Segments.create((String)this.check("app-rs-css")));
        jrs.setSegJs(Segments.create((String)this.check("app-rs-script")));
        jrs.setScanPaths(Strings.splitIgnoreBlank((String)this.check("app-rs-scan-path"), (String)"\n"));
        jrs.setForce("force".equalsIgnoreCase(this.get("app-rs-scan", "force")));
        return jrs;
    }

    public WebConfig(String path) {
        this.pp.setPaths(new String[]{path});
        String str = this.pp.get(MACRO_INCLUDE);
        if (!Strings.isBlank((CharSequence)str)) {
            String[] ss;
            for (String s : ss = Strings.splitIgnoreBlank((String)str, (String)"\n")) {
                File f = Files.findFile((String)s);
                if (null == f) {
                    throw Lang.makeThrow((String)"Fail to found path '%s' in CLASSPATH or File System!", (Object[])new Object[]{s});
                }
                if (f.isDirectory()) {
                    Disks.visitFile((File)f, (FileVisitor)new FileVisitor(){

                        public void visit(File f) {
                            WebConfig.this._join_propertiesFile(f);
                        }
                    }, (FileFilter)new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return !f.isHidden() && !f.getName().startsWith(".");
                            }
                            return f.getName().endsWith(".properties");
                        }
                    });
                    continue;
                }
                this._join_propertiesFile(f);
            }
        }
    }

    private void _join_propertiesFile(File f) {
        MultiLineProperties mp = new MultiLineProperties();
        try {
            mp.load(Streams.fileInr((File)f));
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        for (String key : mp.keys()) {
            this.pp.put(key, mp.get((Object)key));
        }
    }
}

