/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.nutz.http.Http;
import org.nutz.http.Response;
import org.nutz.lang.Files;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.socket.Sockets;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.WebConfig;
import org.nutz.web.Webs;

public class WebServer {
    private static final Log log = Logs.get();
    protected WebConfig dc;
    protected Server server;

    public WebServer(WebConfig config) {
        this.dc = config;
        Webs.setProp(config.pp);
    }

    protected void prepare() throws IOException {
        this.server = new Server(this.dc.getAppPort());
        File root = Files.findFile((String)this.dc.getAppRoot());
        if (root == null || !root.exists()) {
            throw new IllegalArgumentException("root: " + this.dc.getAppRoot() + " not exist!");
        }
        String warUrlString = root.toURI().toURL().toExternalForm();
        log.debugf("war path : %s", new Object[]{warUrlString});
        WebAppContext appContext = new WebAppContext(warUrlString, "/");
        appContext.setExtraClasspath(this.dc.getAppClasspath());
        appContext.setClassLoader(this.getClass().getClassLoader());
        this.server.setHandler((Handler)appContext);
    }

    void run() {
        block5: {
            try {
                this.prepare();
                this.server.start();
                Response resp = Http.get((String)("http://127.0.0.1:" + this.dc.getAppPort()));
                if (resp == null || resp.getStatus() >= 500) {
                    log.error((Object)"Self-Testing fail !!Server start fail?!!");
                    this.server.stop();
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Server is up!");
                }
                if (log.isInfoEnabled()) {
                    log.infof("Create admin port at %d", new Object[]{this.dc.getAdminPort()});
                }
                Sockets.localListenOne((int)this.dc.getAdminPort(), (String)"stop", (SocketAction)new SocketAction(){

                    public void run(SocketContext context) {
                        block3: {
                            if (null != WebServer.this.server) {
                                try {
                                    WebServer.this.server.stop();
                                }
                                catch (Exception e4stop) {
                                    if (!log.isErrorEnabled()) break block3;
                                    log.error((Object)"Fail to stop!", (Throwable)e4stop);
                                }
                            }
                        }
                        Sockets.close();
                    }
                });
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)"Unknow error", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.server) {
            try {
                this.server.stop();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Fail to stop!", e);
                }
                throw e;
            }
        }
        super.finalize();
    }
}

